/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.extensibility.impl;

import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Writer;
import org.springframework.extensions.surf.extensibility.CloseModelElement;
import org.springframework.extensions.surf.extensibility.ContentModelElement;
import org.springframework.extensions.surf.extensibility.ExtensibilityDirectiveData;
import org.springframework.extensions.surf.extensibility.OpenModelElement;
import org.springframework.extensions.surf.extensibility.impl.CloseModelElementImpl;
import org.springframework.extensions.surf.extensibility.impl.DefaultContentModelElement;
import org.springframework.extensions.surf.extensibility.impl.ModelWriter;
import org.springframework.extensions.surf.extensibility.impl.OpenModelElementImpl;

public class DefaultExtensibilityDirectiveData
implements ExtensibilityDirectiveData {
    private String id = "";
    private String action = "";
    private String target = "";
    private String directiveName = "";
    private TemplateDirectiveBody body = null;
    private Environment env = null;

    public DefaultExtensibilityDirectiveData(String id, String action, String target, String directiveName, TemplateDirectiveBody body, Environment env) {
        this.id = id;
        this.action = action;
        this.target = target;
        this.directiveName = directiveName;
        this.body = body;
        this.env = env;
    }

    public Environment getEnv() {
        return this.env;
    }

    public String getId() {
        return this.id;
    }

    public String getAction() {
        return this.action;
    }

    public String getTarget() {
        return this.target;
    }

    public String getDirectiveName() {
        return this.directiveName;
    }

    public TemplateDirectiveBody getBody() {
        return this.body;
    }

    public OpenModelElement createOpen() {
        return new OpenModelElementImpl(this.id, this.directiveName);
    }

    public ContentModelElement createContentModelElement() {
        return new DefaultContentModelElement(this.id, this.directiveName);
    }

    public CloseModelElement createClose() {
        return new CloseModelElementImpl(this.id, this.directiveName);
    }

    public String toString() {
        return "ID: " + this.id + ", ACTION:" + this.action;
    }

    public void render(ModelWriter writer) throws TemplateException, IOException {
        if (this.body != null) {
            this.body.render((Writer)writer);
        }
    }
}

