/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.extensions.webscripts.AbstractRuntimeContainer;
import org.springframework.extensions.webscripts.Authenticator;
import org.springframework.extensions.webscripts.DefaultURLModelFactory;
import org.springframework.extensions.webscripts.Description;
import org.springframework.extensions.webscripts.ServerModel;
import org.springframework.extensions.webscripts.URLModelFactory;
import org.springframework.extensions.webscripts.WebScript;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;

public class PresentationContainer
extends AbstractRuntimeContainer
implements BeanNameAware {
    private static final Log logger = LogFactory.getLog(PresentationContainer.class);
    private String beanId;
    private ServerModel serverModel = null;
    private URLModelFactory urlModelFactory = new DefaultURLModelFactory();

    public void setBeanName(String beanId) {
        this.beanId = beanId;
    }

    public void executeScript(WebScriptRequest scriptReq, WebScriptResponse scriptRes, Authenticator auth) throws IOException {
        WebScript script = scriptReq.getServiceMatch().getWebScript();
        script.setURLModelFactory(this.getUrlModelFactory());
        Description desc = script.getDescription();
        Description.RequiredAuthentication required = desc.getRequiredAuthentication();
        if (auth == null || Description.RequiredAuthentication.none == required || auth.authenticate(required, false)) {
            script.execute(scriptReq, scriptRes);
        }
    }

    public URLModelFactory getUrlModelFactory() {
        return this.urlModelFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerModel getDescription() {
        if (this.serverModel == null) {
            Properties props = null;
            URL url = this.getClass().getClassLoader().getResource("surfversion.properties");
            if (url != null) {
                try {
                    InputStream io = url.openStream();
                    props = new Properties();
                    try {
                        props.load(url.openStream());
                        Object var5_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_6 = null;
                        io.close();
                        throw throwable;
                    }
                    io.close();
                    {
                    }
                }
                catch (IOException err) {
                    logger.warn((Object)("Failed to load version properties: " + err.getMessage()), (Throwable)err);
                }
            }
            this.serverModel = new PresentationServerModel(this.beanId, props);
        }
        return this.serverModel;
    }

    public void reset() {
        super.reset();
        this.serverModel = null;
    }

    private class PresentationServerModel
    implements ServerModel {
        private Properties props = null;
        private String version = null;
        private String id = null;
        private static final String UNKNOWN = "<unknown>";

        public PresentationServerModel(String id, Properties props) {
            this.id = id;
            this.props = props;
        }

        public String getContainerName() {
            return this.getName();
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return "Spring Web Scripts";
        }

        public String getEdition() {
            return this.props != null ? "Spring WebScripts " + this.props.getProperty("surf.edition") : UNKNOWN;
        }

        public int getSchema() {
            return this.props != null ? Integer.parseInt(this.props.getProperty("surf.schema")) : -1;
        }

        public String getVersion() {
            if (this.version == null) {
                if (this.props != null) {
                    boolean hasBuild;
                    StringBuilder version = new StringBuilder(this.getVersionMajor());
                    version.append(".");
                    version.append(this.getVersionMinor());
                    version.append(".");
                    version.append(this.getVersionRevision());
                    String label = this.getVersionLabel();
                    String build = this.getVersionBuild();
                    boolean hasLabel = label != null && label.length() > 0;
                    boolean bl = hasBuild = build != null && build.length() > 0;
                    if (hasLabel || hasBuild) {
                        version.append(" (");
                    }
                    if (hasLabel) {
                        version.append(label);
                    }
                    if (hasBuild) {
                        if (hasLabel) {
                            version.append(" ");
                        }
                        version.append(build);
                    }
                    if (hasLabel || hasBuild) {
                        version.append(")");
                    }
                    this.version = version.toString();
                } else {
                    this.version = UNKNOWN;
                }
            }
            return this.version;
        }

        public String getVersionBuild() {
            return this.props != null ? this.props.getProperty("buildNumber") : UNKNOWN;
        }

        public String getVersionLabel() {
            return this.props != null ? this.props.getProperty("surf.version.label") : UNKNOWN;
        }

        public String getVersionMajor() {
            return this.props != null ? this.props.getProperty("surf.version.major") : UNKNOWN;
        }

        public String getVersionMinor() {
            return this.props != null ? this.props.getProperty("surf.version.minor") : UNKNOWN;
        }

        public String getVersionRevision() {
            return this.props != null ? this.props.getProperty("surf.version.revision") : UNKNOWN;
        }
    }
}

