/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.awt.event.ActionEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.tools.debugger.Dim;
import org.mozilla.javascript.tools.debugger.ScopeProvider;
import org.mozilla.javascript.tools.debugger.SwingGui;
import org.mozilla.javascript.tools.shell.Global;

public class ScriptDebugger
implements Runnable {
    private static final Log logger = LogFactory.getLog(ScriptDebugger.class);
    private ContextFactory factory = null;
    private SwingGui gui = null;
    protected Dim dim = null;
    private String title = "";

    public void setTitle(String title) {
        this.title = title;
    }

    protected void initDebugger() {
        this.dim = new Dim();
    }

    public void start() {
        if (logger.isDebugEnabled()) {
            this.activate();
            this.show();
        }
    }

    public synchronized void activate() {
        this.factory = ContextFactory.getGlobal();
        Global global = new Global();
        global.init(this.factory);
        global.setIn(System.in);
        global.setOut(System.out);
        global.setErr(System.err);
        this.initDebugger();
        AlfrescoScopeProvider sp = new AlfrescoScopeProvider((Scriptable)global);
        this.dim.setScopeProvider((ScopeProvider)sp);
        this.gui = new AlfrescoGui(this.dim, this.getTitle(), this);
        this.gui.setDefaultCloseOperation(2);
        this.gui.setExitAction((Runnable)this);
    }

    protected String getTitle() {
        return this.title;
    }

    public synchronized void show() {
        if (!this.isActive()) {
            this.activate();
        }
        this.dim.setBreakOnExceptions(true);
        this.dim.setBreak();
        this.dim.attachTo(this.factory);
        this.gui.pack();
        this.gui.setSize(600, 460);
        this.gui.setVisible(true);
    }

    public synchronized void hide() {
        if (this.isVisible()) {
            this.dim.detach();
            this.gui.dispose();
        }
    }

    public boolean isVisible() {
        return this.isActive() && this.gui.isVisible();
    }

    public boolean isActive() {
        return this.gui != null;
    }

    public void run() {
        this.dim.detach();
        this.gui.dispose();
    }

    public static class AlfrescoScopeProvider
    implements ScopeProvider {
        private Scriptable scope;

        AlfrescoScopeProvider(Scriptable scope) {
            this.scope = scope;
        }

        public Scriptable getScope() {
            return this.scope;
        }
    }

    private static class AlfrescoGui
    extends SwingGui {
        private static final long serialVersionUID = 5053205080777378416L;
        private ScriptDebugger debugger;

        public AlfrescoGui(Dim dim, String title, ScriptDebugger debugger) {
            super(dim, title);
            this.debugger = debugger;
        }

        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (cmd.equals("Exit")) {
                this.debugger.hide();
            } else {
                super.actionPerformed(e);
            }
        }
    }
}

