/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Runtime;
import org.springframework.extensions.webscripts.WebScriptResponseImpl;
import org.springframework.extensions.webscripts.ui.common.StringUtils;

public class WebScriptServletResponse
extends WebScriptResponseImpl {
    private static final Log logger = LogFactory.getLog(WebScriptServletResponse.class);
    private HttpServletResponse res;
    private static ThreadLocal<SimpleDateFormat> s_dateFormat = new ThreadLocal();

    public WebScriptServletResponse(Runtime container, HttpServletResponse res) {
        super(container);
        this.res = res;
    }

    public HttpServletResponse getHttpServletResponse() {
        return this.res;
    }

    public void setStatus(int status) {
        this.res.setStatus(status);
    }

    public void setHeader(String name, String value) {
        this.res.setHeader(name, value);
    }

    public void addHeader(String name, String value) {
        this.res.addHeader(name, value);
    }

    public void setContentType(String contentType) {
        this.res.setContentType(contentType);
    }

    public void setContentEncoding(String contentEncoding) {
        this.res.setCharacterEncoding(contentEncoding);
    }

    public void setCache(Cache cache) {
        String cacheControl = "";
        String pragma = "";
        if (cache.getIsPublic()) {
            cacheControl = cacheControl + "public";
        }
        if (cache.getNeverCache()) {
            cacheControl = cacheControl + (cacheControl.length() > 0 ? ", " : "") + "no-cache";
            pragma = pragma + (pragma.length() > 0 ? ", " : "no-cache");
        }
        if (cache.getMaxAge() != null && !cache.getNeverCache()) {
            cacheControl = cacheControl + (cacheControl.length() > 0 ? ", " : "") + " max-age=" + cache.getMaxAge();
        }
        if (cache.getMustRevalidate() && !cache.getNeverCache()) {
            cacheControl = cacheControl + (cacheControl.length() > 0 ? ", " : "") + " must-revalidate";
        }
        if (cacheControl.length() > 0) {
            this.res.setHeader("Cache-Control", cacheControl);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Cache - set response header Cache-Control: " + cacheControl));
            }
        }
        if (pragma.length() > 0) {
            this.res.setHeader("Pragma", pragma);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Cache - set response header Pragma: " + pragma));
            }
        }
        if (cache.getETag() != null) {
            String eTag = "\"" + cache.getETag() + "\"";
            this.res.setHeader("ETag", eTag);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Cache - set response header ETag: " + eTag));
            }
        }
        if (cache.getLastModified() != null) {
            this.res.setDateHeader("Last-Modified", cache.getLastModified().getTime());
            if (logger.isDebugEnabled()) {
                SimpleDateFormat formatter = WebScriptServletResponse.getHTTPDateFormat();
                String lastModified = formatter.format(cache.getLastModified());
                logger.debug((Object)("Cache - set response header Last-Modified: " + lastModified));
            }
        }
    }

    public void reset() {
        try {
            this.res.reset();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public Writer getWriter() throws IOException {
        return this.res.getWriter();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.res.getOutputStream();
    }

    public String encodeScriptUrl(String url) {
        return url;
    }

    public String getEncodeScriptUrlFunction(String name) {
        String s = "{ $name$: function(url) { return url; } }".replace("$name$", name);
        return StringUtils.encodeJavascript(s);
    }

    public String encodeResourceUrl(String url) {
        return url;
    }

    public String getEncodeResourceUrlFunction(String name) {
        String s = "{ $name$: function(url) { return url; } }".replace("$name$", name);
        return StringUtils.encodeJavascript(s);
    }

    private static SimpleDateFormat getHTTPDateFormat() {
        if (s_dateFormat.get() != null) {
            return s_dateFormat.get();
        }
        SimpleDateFormat formatter = new SimpleDateFormat("EEE, dd MMM yyyy kk:mm:ss zzz");
        formatter.setLenient(false);
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        s_dateFormat.set(formatter);
        return s_dateFormat.get();
    }
}

