/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr;

import java.util.LinkedList;
import junit.framework.TestCase;
import org.alfresco.solr.AlfrescoSolrEventListener;

public class AlfrescoSolrEventListenerTest
extends TestCase {
    static AlfrescoSolrEventListener asel = new AlfrescoSolrEventListener(null);
    SimpleCacheSection[] start = new SimpleCacheSection[]{new SimpleCacheSection(1, 0, 10, 10, 0), new SimpleCacheSection(2, 10, 11, 10, 0), new SimpleCacheSection(3, 21, 12, 10, 0), new SimpleCacheSection(4, 33, 13, 10, 0), new SimpleCacheSection(5, 46, 10, 0, 0), new SimpleCacheSection(6, 56, 10, 10, 0)};
    SimpleCacheSection[] startWithDeletions = new SimpleCacheSection[]{new SimpleCacheSection(1, 0, 10, 10, 0), new SimpleCacheSection(2, 10, 11, 10, 1), new SimpleCacheSection(3, 21, 12, 10, 0), new SimpleCacheSection(4, 33, 13, 10, 1), new SimpleCacheSection(5, 46, 10, 0, 0), new SimpleCacheSection(6, 56, 10, 10, 1)};
    SimpleCacheSection[][] mergeResults = new SimpleCacheSection[][]{{new SimpleCacheSection(1, 0, 10, 10, 0), new SimpleCacheSection(2, 10, 11, 10, 0), new SimpleCacheSection(3, 21, 12, 10, 0), new SimpleCacheSection(4, 33, 13, 10, 0), new SimpleCacheSection(7, 46, 10, 10, 0)}, {new SimpleCacheSection(1, 0, 10, 10, 0), new SimpleCacheSection(2, 10, 11, 10, 0), new SimpleCacheSection(3, 21, 12, 10, 0), new SimpleCacheSection(7, 33, 20, 20, 0)}, {new SimpleCacheSection(1, 0, 10, 10, 0), new SimpleCacheSection(2, 10, 11, 10, 0), new SimpleCacheSection(7, 21, 30, 30, 0)}, {new SimpleCacheSection(1, 0, 10, 10, 0), new SimpleCacheSection(7, 10, 40, 40, 0)}, {new SimpleCacheSection(7, 0, 50, 50, 0)}, {new SimpleCacheSection(7, 0, 20, 20, 0), new SimpleCacheSection(3, 20, 12, 10, 0), new SimpleCacheSection(4, 32, 13, 10, 0), new SimpleCacheSection(5, 45, 10, 0, 0), new SimpleCacheSection(6, 55, 10, 10, 0)}, {new SimpleCacheSection(7, 0, 30, 30, 0), new SimpleCacheSection(4, 30, 13, 10, 0), new SimpleCacheSection(5, 43, 10, 0, 0), new SimpleCacheSection(6, 53, 10, 10, 0)}, {new SimpleCacheSection(7, 0, 40, 40, 0), new SimpleCacheSection(5, 40, 10, 0, 0), new SimpleCacheSection(6, 50, 10, 10, 0)}, {new SimpleCacheSection(7, 0, 40, 40, 0), new SimpleCacheSection(6, 40, 10, 10, 0)}, {new SimpleCacheSection(1, 0, 10, 10, 0), new SimpleCacheSection(2, 10, 11, 10, 0), new SimpleCacheSection(7, 21, 20, 20, 0), new SimpleCacheSection(5, 41, 10, 0, 0), new SimpleCacheSection(6, 51, 10, 10, 0)}, {new SimpleCacheSection(1, 0, 10, 10, 0), new SimpleCacheSection(7, 10, 30, 30, 0), new SimpleCacheSection(6, 40, 10, 10, 0)}, {new SimpleCacheSection(7, 0, 20, 20, 0), new SimpleCacheSection(3, 20, 12, 10, 0), new SimpleCacheSection(4, 32, 13, 10, 0), new SimpleCacheSection(8, 45, 10, 10, 0)}, {new SimpleCacheSection(7, 0, 20, 20, 0), new SimpleCacheSection(8, 20, 30, 30, 0)}, {new SimpleCacheSection(7, 0, 30, 30, 0), new SimpleCacheSection(8, 30, 20, 20, 0)}, {new SimpleCacheSection(7, 0, 40, 40, 0), new SimpleCacheSection(8, 40, 10, 10, 0)}, {new SimpleCacheSection(7, 0, 20, 20, 0), new SimpleCacheSection(8, 20, 20, 20, 0), new SimpleCacheSection(9, 40, 10, 10, 0)}};
    AlfrescoSolrEventListener.CacheMatch[][] mergeOperations = new AlfrescoSolrEventListener.CacheMatch[][]{{new AlfrescoSolrEventListener.Match(10, 10), new AlfrescoSolrEventListener.Match(11, 10), new AlfrescoSolrEventListener.Match(12, 10), new AlfrescoSolrEventListener.Match(13, 10), new AlfrescoSolrEventListener.Merge(10, 10)}, {new AlfrescoSolrEventListener.Match(10, 10), new AlfrescoSolrEventListener.Match(11, 10), new AlfrescoSolrEventListener.Match(12, 10), new AlfrescoSolrEventListener.Merge(20, 20)}, {new AlfrescoSolrEventListener.Match(10, 10), new AlfrescoSolrEventListener.Match(11, 10), new AlfrescoSolrEventListener.Merge(30, 30)}, {new AlfrescoSolrEventListener.Match(10, 10), new AlfrescoSolrEventListener.Merge(40, 40)}, {new AlfrescoSolrEventListener.Merge(50, 50)}, {new AlfrescoSolrEventListener.Merge(20, 20), new AlfrescoSolrEventListener.Match(12, 10), new AlfrescoSolrEventListener.Match(13, 10), new AlfrescoSolrEventListener.Match(10, 0), new AlfrescoSolrEventListener.Match(10, 10)}, {new AlfrescoSolrEventListener.Merge(30, 30), new AlfrescoSolrEventListener.Match(13, 10), new AlfrescoSolrEventListener.Match(10, 0), new AlfrescoSolrEventListener.Match(10, 10)}, {new AlfrescoSolrEventListener.Merge(40, 40), new AlfrescoSolrEventListener.Match(10, 0), new AlfrescoSolrEventListener.Match(10, 10)}, {new AlfrescoSolrEventListener.Merge(40, 40), new AlfrescoSolrEventListener.Match(10, 10)}, {new AlfrescoSolrEventListener.Match(10, 10), new AlfrescoSolrEventListener.Match(11, 10), new AlfrescoSolrEventListener.Merge(20, 20), new AlfrescoSolrEventListener.Match(10, 0), new AlfrescoSolrEventListener.Match(10, 10)}, {new AlfrescoSolrEventListener.Match(10, 10), new AlfrescoSolrEventListener.Merge(30, 30), new AlfrescoSolrEventListener.Match(10, 10)}, {new AlfrescoSolrEventListener.Merge(20, 20), new AlfrescoSolrEventListener.Match(12, 10), new AlfrescoSolrEventListener.Match(13, 10), new AlfrescoSolrEventListener.Merge(10, 10)}, {new AlfrescoSolrEventListener.Merge(20, 20), new AlfrescoSolrEventListener.Merge(30, 30)}, {new AlfrescoSolrEventListener.Merge(30, 30), new AlfrescoSolrEventListener.Merge(20, 20)}, {new AlfrescoSolrEventListener.Merge(40, 40), new AlfrescoSolrEventListener.Merge(10, 10)}, {new AlfrescoSolrEventListener.Merge(20, 20), new AlfrescoSolrEventListener.Merge(20, 20), new AlfrescoSolrEventListener.Merge(10, 10)}};
    SimpleCacheSection[][] deleteResults = new SimpleCacheSection[][]{{new SimpleCacheSection(1, 0, 10, 10, 0), new SimpleCacheSection(2, 10, 11, 9, 0), new SimpleCacheSection(3, 21, 12, 10, 0), new SimpleCacheSection(4, 33, 13, 9, 0), new SimpleCacheSection(5, 46, 10, 0, 0), new SimpleCacheSection(6, 56, 10, 9, 0)}, {new SimpleCacheSection(1, 0, 10, 10, 0), new SimpleCacheSection(2, 10, 11, 9, 0), new SimpleCacheSection(3, 21, 12, 10, 0), new SimpleCacheSection(7, 33, 18, 18, 0)}};
    AlfrescoSolrEventListener.CacheMatch[][] deleteOperations = new AlfrescoSolrEventListener.CacheMatch[][]{{new AlfrescoSolrEventListener.Match(10, 10), new AlfrescoSolrEventListener.Delete(11, 9), new AlfrescoSolrEventListener.Match(12, 10), new AlfrescoSolrEventListener.Delete(13, 9), new AlfrescoSolrEventListener.Match(10, 0), new AlfrescoSolrEventListener.Delete(10, 9)}, {new AlfrescoSolrEventListener.Match(10, 10), new AlfrescoSolrEventListener.Delete(11, 9), new AlfrescoSolrEventListener.Match(12, 10), new AlfrescoSolrEventListener.Merge(18, 18)}};
    SimpleCacheSection[][] deleteAndNewResults = new SimpleCacheSection[][]{{new SimpleCacheSection(1, 0, 10, 10, 0), new SimpleCacheSection(2, 10, 11, 9, 0), new SimpleCacheSection(3, 21, 12, 10, 0), new SimpleCacheSection(4, 33, 13, 9, 0), new SimpleCacheSection(5, 46, 10, 0, 0), new SimpleCacheSection(6, 56, 10, 9, 0)}, {new SimpleCacheSection(1, 0, 10, 10, 0), new SimpleCacheSection(2, 10, 11, 9, 0), new SimpleCacheSection(3, 21, 12, 10, 0), new SimpleCacheSection(4, 33, 13, 9, 0), new SimpleCacheSection(5, 46, 10, 0, 0), new SimpleCacheSection(6, 56, 10, 9, 0), new SimpleCacheSection(7, 66, 10, 10, 0), new SimpleCacheSection(8, 76, 10, 9, 0)}, {new SimpleCacheSection(1, 0, 10, 10, 0), new SimpleCacheSection(2, 10, 11, 9, 0), new SimpleCacheSection(3, 21, 12, 10, 0), new SimpleCacheSection(7, 33, 18, 18, 0)}, {new SimpleCacheSection(1, 0, 10, 10, 0), new SimpleCacheSection(2, 10, 11, 9, 0), new SimpleCacheSection(3, 21, 12, 10, 0), new SimpleCacheSection(7, 33, 18, 18, 0), new SimpleCacheSection(8, 47, 20, 2, 0), new SimpleCacheSection(9, 67, 10, 10, 0)}, {new SimpleCacheSection(10, 0, 29, 29, 0), new SimpleCacheSection(7, 29, 18, 18, 0), new SimpleCacheSection(8, 47, 20, 2, 0), new SimpleCacheSection(9, 67, 10, 10, 0)}, {new SimpleCacheSection(1, 0, 10, 10, 0), new SimpleCacheSection(2, 10, 11, 9, 0), new SimpleCacheSection(3, 21, 12, 10, 0), new SimpleCacheSection(7, 33, 20, 20, 0)}, {new SimpleCacheSection(1, 0, 10, 10, 0), new SimpleCacheSection(2, 10, 11, 9, 0), new SimpleCacheSection(3, 21, 12, 10, 0), new SimpleCacheSection(7, 33, 20, 20, 0), new SimpleCacheSection(8, 47, 20, 2, 0), new SimpleCacheSection(9, 67, 10, 10, 0)}, {new SimpleCacheSection(7, 0, 19, 19, 0), new SimpleCacheSection(8, 19, 10, 10, 0), new SimpleCacheSection(9, 29, 9, 9, 0), new SimpleCacheSection(10, 38, 10, 10, 0)}};
    AlfrescoSolrEventListener.CacheMatch[][] deleteAndNewOperations;

    public AlfrescoSolrEventListenerTest() {
        AlfrescoSolrEventListener.CacheMatch[][] cacheMatchArrayArray = new AlfrescoSolrEventListener.CacheMatch[8][];
        cacheMatchArrayArray[0] = new AlfrescoSolrEventListener.CacheMatch[]{new AlfrescoSolrEventListener.Match(10, 10), new AlfrescoSolrEventListener.Delete(11, 9), new AlfrescoSolrEventListener.Match(12, 10), new AlfrescoSolrEventListener.Delete(13, 9), new AlfrescoSolrEventListener.Match(10, 0), new AlfrescoSolrEventListener.Delete(10, 10)};
        AlfrescoSolrEventListener.CacheMatch[] cacheMatchArray = new AlfrescoSolrEventListener.CacheMatch[8];
        cacheMatchArray[0] = new AlfrescoSolrEventListener.Match(10, 10);
        cacheMatchArray[1] = new AlfrescoSolrEventListener.Delete(11, 9);
        cacheMatchArray[2] = new AlfrescoSolrEventListener.Match(12, 10);
        cacheMatchArray[3] = new AlfrescoSolrEventListener.Delete(13, 9);
        cacheMatchArray[4] = new AlfrescoSolrEventListener.Match(10, 0);
        cacheMatchArray[5] = new AlfrescoSolrEventListener.Delete(10, 9);
        AlfrescoSolrEventListener alfrescoSolrEventListener = asel;
        alfrescoSolrEventListener.getClass();
        cacheMatchArray[6] = alfrescoSolrEventListener.new AlfrescoSolrEventListener.New(10, 10);
        AlfrescoSolrEventListener alfrescoSolrEventListener2 = asel;
        alfrescoSolrEventListener2.getClass();
        cacheMatchArray[7] = alfrescoSolrEventListener2.new AlfrescoSolrEventListener.New(10, 10);
        cacheMatchArrayArray[1] = cacheMatchArray;
        cacheMatchArrayArray[2] = new AlfrescoSolrEventListener.CacheMatch[]{new AlfrescoSolrEventListener.Match(10, 10), new AlfrescoSolrEventListener.Delete(11, 9), new AlfrescoSolrEventListener.Match(12, 10), new AlfrescoSolrEventListener.Merge(18, 18)};
        AlfrescoSolrEventListener.CacheMatch[] cacheMatchArray2 = new AlfrescoSolrEventListener.CacheMatch[6];
        cacheMatchArray2[0] = new AlfrescoSolrEventListener.Match(10, 10);
        cacheMatchArray2[1] = new AlfrescoSolrEventListener.Delete(11, 9);
        cacheMatchArray2[2] = new AlfrescoSolrEventListener.Match(12, 10);
        cacheMatchArray2[3] = new AlfrescoSolrEventListener.Merge(18, 18);
        AlfrescoSolrEventListener alfrescoSolrEventListener3 = asel;
        alfrescoSolrEventListener3.getClass();
        cacheMatchArray2[4] = alfrescoSolrEventListener3.new AlfrescoSolrEventListener.New(20, 20);
        AlfrescoSolrEventListener alfrescoSolrEventListener4 = asel;
        alfrescoSolrEventListener4.getClass();
        cacheMatchArray2[5] = alfrescoSolrEventListener4.new AlfrescoSolrEventListener.New(10, 20);
        cacheMatchArrayArray[3] = cacheMatchArray2;
        AlfrescoSolrEventListener.CacheMatch[] cacheMatchArray3 = new AlfrescoSolrEventListener.CacheMatch[4];
        cacheMatchArray3[0] = new AlfrescoSolrEventListener.Merge(29, 29);
        cacheMatchArray3[1] = new AlfrescoSolrEventListener.Merge(18, 18);
        AlfrescoSolrEventListener alfrescoSolrEventListener5 = asel;
        alfrescoSolrEventListener5.getClass();
        cacheMatchArray3[2] = alfrescoSolrEventListener5.new AlfrescoSolrEventListener.New(20, 20);
        AlfrescoSolrEventListener alfrescoSolrEventListener6 = asel;
        alfrescoSolrEventListener6.getClass();
        cacheMatchArray3[3] = alfrescoSolrEventListener6.new AlfrescoSolrEventListener.New(10, 10);
        cacheMatchArrayArray[4] = cacheMatchArray3;
        AlfrescoSolrEventListener.CacheMatch[] cacheMatchArray4 = new AlfrescoSolrEventListener.CacheMatch[4];
        cacheMatchArray4[0] = new AlfrescoSolrEventListener.Match(10, 10);
        cacheMatchArray4[1] = new AlfrescoSolrEventListener.Delete(11, 9);
        cacheMatchArray4[2] = new AlfrescoSolrEventListener.Match(12, 10);
        AlfrescoSolrEventListener alfrescoSolrEventListener7 = asel;
        alfrescoSolrEventListener7.getClass();
        cacheMatchArray4[3] = alfrescoSolrEventListener7.new AlfrescoSolrEventListener.MergeAndNew(20, 20);
        cacheMatchArrayArray[5] = cacheMatchArray4;
        AlfrescoSolrEventListener.CacheMatch[] cacheMatchArray5 = new AlfrescoSolrEventListener.CacheMatch[6];
        cacheMatchArray5[0] = new AlfrescoSolrEventListener.Match(10, 10);
        cacheMatchArray5[1] = new AlfrescoSolrEventListener.Delete(11, 9);
        cacheMatchArray5[2] = new AlfrescoSolrEventListener.Match(12, 10);
        AlfrescoSolrEventListener alfrescoSolrEventListener8 = asel;
        alfrescoSolrEventListener8.getClass();
        cacheMatchArray5[3] = alfrescoSolrEventListener8.new AlfrescoSolrEventListener.MergeAndNew(20, 20);
        AlfrescoSolrEventListener alfrescoSolrEventListener9 = asel;
        alfrescoSolrEventListener9.getClass();
        cacheMatchArray5[4] = alfrescoSolrEventListener9.new AlfrescoSolrEventListener.New(20, 20);
        AlfrescoSolrEventListener alfrescoSolrEventListener10 = asel;
        alfrescoSolrEventListener10.getClass();
        cacheMatchArray5[5] = alfrescoSolrEventListener10.new AlfrescoSolrEventListener.New(10, 10);
        cacheMatchArrayArray[6] = cacheMatchArray5;
        AlfrescoSolrEventListener.CacheMatch[] cacheMatchArray6 = new AlfrescoSolrEventListener.CacheMatch[4];
        cacheMatchArray6[0] = new AlfrescoSolrEventListener.Merge(19, 19);
        cacheMatchArray6[1] = new AlfrescoSolrEventListener.Merge(10, 10);
        cacheMatchArray6[2] = new AlfrescoSolrEventListener.Merge(9, 9);
        AlfrescoSolrEventListener alfrescoSolrEventListener11 = asel;
        alfrescoSolrEventListener11.getClass();
        cacheMatchArray6[3] = alfrescoSolrEventListener11.new AlfrescoSolrEventListener.MergeAndNew(10, 10);
        cacheMatchArrayArray[7] = cacheMatchArray6;
        this.deleteAndNewOperations = cacheMatchArrayArray;
    }

    public void testMerges() {
        for (int i = 0; i < this.mergeResults.length; ++i) {
            System.out.println("Test " + i);
            AlfrescoSolrEventListener.CacheSection[] after = this.mergeResults[i];
            LinkedList<AlfrescoSolrEventListener.CacheMatch> operations = asel.buildCacheUpdateOperations(false, this.start, after, null);
            AlfrescoSolrEventListener.CacheMatch[] expectedOperations = this.mergeOperations[i];
            AlfrescoSolrEventListenerTest.assertEquals((int)expectedOperations.length, (int)operations.size());
            for (int c = 0; c < expectedOperations.length; ++c) {
                System.out.println(c);
                System.out.println("\t" + operations.get(c).getFinalCacheSize());
                System.out.println("\t" + expectedOperations[c].getFinalCacheSize());
                AlfrescoSolrEventListenerTest.assertTrue((boolean)operations.get(c).getClass().isAssignableFrom(expectedOperations[c].getClass()));
                AlfrescoSolrEventListenerTest.assertTrue((operations.get(c).getFinalCacheSize() == expectedOperations[c].getFinalCacheSize() ? 1 : 0) != 0);
                AlfrescoSolrEventListenerTest.assertTrue((operations.get(c).getFinalDocCount() == expectedOperations[c].getFinalDocCount() ? 1 : 0) != 0);
            }
        }
    }

    public void testWithDeletes() {
        for (int i = 0; i < this.deleteResults.length; ++i) {
            System.out.println("Test " + i);
            AlfrescoSolrEventListener.CacheSection[] after = this.deleteResults[i];
            LinkedList<AlfrescoSolrEventListener.CacheMatch> operations = asel.buildCacheUpdateOperations(false, this.startWithDeletions, after, null);
            AlfrescoSolrEventListener.CacheMatch[] expectedOperations = this.deleteOperations[i];
            AlfrescoSolrEventListenerTest.assertEquals((int)expectedOperations.length, (int)operations.size());
            for (int c = 0; c < expectedOperations.length; ++c) {
                System.out.println(c);
                System.out.println("\t" + operations.get(c).getFinalCacheSize());
                System.out.println("\t" + expectedOperations[c].getFinalCacheSize());
                AlfrescoSolrEventListenerTest.assertTrue((boolean)operations.get(c).getClass().isAssignableFrom(expectedOperations[c].getClass()));
                AlfrescoSolrEventListenerTest.assertTrue((operations.get(c).getFinalCacheSize() == expectedOperations[c].getFinalCacheSize() ? 1 : 0) != 0);
            }
        }
    }

    public void testWithDeletesAndNew() {
        for (int i = 0; i < this.deleteAndNewResults.length; ++i) {
            System.out.println("Test " + i);
            AlfrescoSolrEventListener.CacheSection[] after = this.deleteAndNewResults[i];
            LinkedList<AlfrescoSolrEventListener.CacheMatch> operations = asel.buildCacheUpdateOperations(true, this.startWithDeletions, after, null);
            AlfrescoSolrEventListener.CacheMatch[] expectedOperations = this.deleteAndNewOperations[i];
            AlfrescoSolrEventListenerTest.assertEquals((int)expectedOperations.length, (int)operations.size());
            for (int c = 0; c < expectedOperations.length; ++c) {
                System.out.println(c);
                System.out.println("\t" + operations.get(c).getFinalCacheSize());
                System.out.println("\t" + expectedOperations[c].getFinalCacheSize());
                System.out.println("\t" + operations.get(c).toString());
                AlfrescoSolrEventListenerTest.assertTrue((boolean)operations.get(c).getClass().isAssignableFrom(expectedOperations[c].getClass()));
                AlfrescoSolrEventListenerTest.assertTrue((operations.get(c).getFinalCacheSize() == expectedOperations[c].getFinalCacheSize() ? 1 : 0) != 0);
            }
        }
    }

    public void testAllMatch() {
        for (int i = 0; i < 100; ++i) {
            this.testAllMatchAndNewSections(i, 0, 10);
        }
    }

    public void testAllMatchAndNewSections() {
        for (int i = 0; i < 100; ++i) {
            int j = 0;
            while (i < 100) {
                this.testAllMatchAndNewSections(i, j, 10);
                ++i;
            }
        }
    }

    private void testAllMatchAndNewSections(int count, int newCount, int docCount) {
        int i;
        int i2;
        AlfrescoSolrEventListener.CacheSection[] before = new SimpleCacheSection[count];
        AlfrescoSolrEventListener.CacheSection[] after = new SimpleCacheSection[count + newCount];
        for (i2 = 0; i2 < count; ++i2) {
            before[i2] = new SimpleCacheSection(i2, i2 * docCount, docCount, docCount, 0);
            after[i2] = new SimpleCacheSection(i2, i2 * docCount, docCount, docCount, 0);
        }
        for (i2 = 0; i2 < newCount; ++i2) {
            after[i2] = new SimpleCacheSection(i2, (count + i2) * docCount, docCount, docCount, 0);
        }
        LinkedList<AlfrescoSolrEventListener.CacheMatch> operations = asel.buildCacheUpdateOperations(true, before, after, null);
        for (i = 0; i < count; ++i) {
            AlfrescoSolrEventListenerTest.assertTrue((boolean)(operations.get(i) instanceof AlfrescoSolrEventListener.Match));
        }
        for (i = 0; i < newCount; ++i) {
            AlfrescoSolrEventListenerTest.assertTrue((boolean)(operations.get(count + i) instanceof AlfrescoSolrEventListener.New));
        }
    }

    private static class SimpleCacheSection
    implements AlfrescoSolrEventListener.CacheSection {
        int id;
        int start;
        int length;
        int docCount;
        int newDeletions = 0;

        SimpleCacheSection(int id, int start, int length, int docCount, int newDeletions) {
            this.id = id;
            this.start = start;
            this.length = length;
            this.docCount = docCount;
            this.newDeletions = newDeletions;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.id;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SimpleCacheSection other = (SimpleCacheSection)obj;
            return this.id == other.id;
        }

        public int getDocCount() {
            return this.docCount;
        }

        public void addDeletion(int doc) {
        }

        public int getDeletionsCount() {
            return this.length - this.docCount;
        }

        public int getLength() {
            return this.length;
        }

        public int getNewDeletionsCount() {
            return this.newDeletions;
        }

        public int getStart() {
            return this.start;
        }
    }
}

