/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ISO9075;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.BinaryRequestWriter;
import org.apache.solr.client.solrj.impl.CommonsHttpSolrServer;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;

public class SolrDocumentLoader {
    public static void main(String[] args) throws SolrServerException, IOException {
        int FOLDERS = 1000;
        int LEAVES = 10000;
        SolrServer solr = SolrDocumentLoader.getRemoteServer();
        solr.deleteByQuery("*:*");
        solr.commit(true, true);
        solr.optimize(true, true);
        int dbid = 0;
        solr.add(SolrDocumentLoader.createGlobalAclDocument());
        SolrInputDocument root = SolrDocumentLoader.createRootDocument(dbid);
        solr.add(root);
        SolrInputDocument rootPath = SolrDocumentLoader.createRootPathDocument(dbid++);
        solr.add(rootPath);
        SolrInputDocument rootAcl = SolrDocumentLoader.createRootAclDocument();
        solr.add(rootAcl);
        solr.commit(true, true);
        solr.optimize(true, true);
        SolrQuery query = new SolrQuery("*:*");
        QueryResponse response = solr.query((SolrParams)query);
        assert (2 == response.getResults().size());
        long start = System.nanoTime();
        for (int i = 0; i < FOLDERS; ++i) {
            ArrayList<SolrInputDocument> docs = new ArrayList<SolrInputDocument>();
            docs.add(SolrDocumentLoader.createContainerDocument(dbid, i));
            docs.add(SolrDocumentLoader.createContainerPathDocument(dbid++, i));
            docs.add(SolrDocumentLoader.createAclDocument(2 + i));
            for (int j = 0; j < LEAVES; ++j) {
                docs.add(SolrDocumentLoader.createLeafDocument(dbid, i, j));
                docs.add(SolrDocumentLoader.createLeafPathDocument(dbid++, i, j));
            }
            solr.add(docs);
            solr.commit(true, true);
        }
        solr.commit(true, true);
        solr.optimize(true, true);
        long end = System.nanoTime();
        query = new SolrQuery("*:*");
        response = solr.query((SolrParams)query);
        System.out.println("Time " + (double)(end - start) / 1.0E9);
        assert (FOLDERS * (LEAVES + 1) + 2 == response.getResults().size());
        System.out.println("Done " + (FOLDERS * (LEAVES + 1) + 2));
        SolrInputDocument doc = new SolrInputDocument();
        doc.addField("ID", (Object)"CHECK_CACHE");
        solr.add(doc);
        solr.commit(true, true);
    }

    public static SolrInputDocument createAclDocument(int i) {
        SolrInputDocument doc = new SolrInputDocument();
        doc.addField("ACLID", (Object)("" + i));
        doc.addField("READER", (Object)("ID-" + i));
        doc.addField("READER", (Object)"ROLE_OWNER");
        doc.addField("ID", (Object)("ACL-" + i));
        if (i == 2) {
            doc.addField("READER", (Object)"ROLE_1");
        }
        if (i < 12) {
            doc.addField("READER", (Object)"ROLE_10");
        }
        if (i < 102) {
            doc.addField("READER", (Object)"ROLE_100");
        }
        if (i < 1002) {
            doc.addField("READER", (Object)"ROLE_1000");
        }
        if (i < 10002) {
            doc.addField("READER", (Object)"ROLE_10000");
        }
        if (i < 100002) {
            doc.addField("READER", (Object)"ROLE_100000");
        }
        if (i < 1000002) {
            doc.addField("READER", (Object)"ROLE_1000000");
        }
        doc.addField("READER", (Object)"ROLE_ALL");
        return doc;
    }

    public static SolrInputDocument createGlobalAclDocument() {
        SolrInputDocument doc = new SolrInputDocument();
        doc.addField("ACLID", (Object)"0");
        doc.addField("READER", (Object)"ROLE_OWNER");
        doc.addField("READER", (Object)"ROLE_ADMIN");
        doc.addField("ID", (Object)"ACL-0");
        return doc;
    }

    public static SolrInputDocument createRootAclDocument() {
        SolrInputDocument doc = new SolrInputDocument();
        doc.addField("ACLID", (Object)"1");
        doc.addField("READER", (Object)"ROLE_ALL");
        doc.addField("READER", (Object)"ROLE_JUST_ROOT");
        doc.addField("ID", (Object)"ACL-1");
        return doc;
    }

    public static SolrInputDocument createLeafDocument(int dbid, int i, int j) {
        SolrInputDocument doc = new SolrInputDocument();
        doc.addField("ISCATEGORY", (Object)"F");
        doc.addField("PARENT", (Object)("ID-F-" + i));
        doc.addField("QNAME", (Object)("{http://www.alfresco.org/model/content/1.0}leaf-" + j));
        doc.addField("PRIMARYPARENT", (Object)("ID-F-" + i));
        doc.addField("ASSOCTYPEQNAME", (Object)"{http://www.alfresco.org/model/content/1.0}contains");
        doc.addField("PRIMARYASSOCTYPEQNAME", (Object)"{http://www.alfresco.org/model/content/1.0}contains");
        doc.addField("ANCESTOR", (Object)("ID-F-" + i));
        doc.addField("FTSSTATUS", (Object)"Clean");
        doc.addField("ID", (Object)("LEAF-" + dbid));
        doc.addField("TX", (Object)"TX-1");
        doc.addField("ISROOT", (Object)"F");
        doc.addField("ISNODE", (Object)"T");
        doc.addField("DBID", (Object)dbid);
        doc.addField("TYPE", (Object)"{http://www.alfresco.org/model/content/1.0}folder");
        doc.addField("ASPECT", (Object)"{http://www.alfresco.org/model/content/1.0}auditable");
        doc.addField("@{http://www.alfresco.org/model/system/1.0}locale", (Object)"en");
        doc.addField("@{http://www.alfresco.org/model/content/1.0}title", (Object)("Leaf " + i + " " + j));
        doc.addField("@{http://www.alfresco.org/model/content/1.0}name", (Object)("Leaf " + i + " " + j));
        doc.addField("@{http://www.alfresco.org/model/content/1.0}created", (Object)"2010-07-21T10:52:00.000Z");
        doc.addField("@{http://www.alfresco.org/model/content/1.0}creator", (Object)"Andy");
        doc.addField("@{http://www.alfresco.org/model/content/1.0}modified", (Object)"2010-07-21T10:52:00.000Z");
        doc.addField("@{http://www.alfresco.org/model/content/1.0}modifier", (Object)"Andy");
        return doc;
    }

    public static SolrInputDocument createLeafPathDocument(int dbid, int i, int j) {
        SolrInputDocument doc = new SolrInputDocument();
        doc.addField("ID", (Object)("AUX-" + dbid));
        doc.addField("TX", (Object)"TX-1");
        doc.addField("DBID", (Object)("" + dbid));
        QName first = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)("folder_" + i));
        QName second = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)("leaf_" + j));
        doc.addField("PATH", (Object)("/" + ISO9075.getXPathName((QName)first) + "/" + ISO9075.getXPathName((QName)second)));
        doc.addField("ACLID", (Object)("" + (i + 2)));
        doc.addField("OWNER", (Object)"Andy");
        return doc;
    }

    public static SolrInputDocument createContainerDocument(int dbid, int i) {
        SolrInputDocument doc = new SolrInputDocument();
        doc.addField("ISCATEGORY", (Object)"F");
        doc.addField("PARENT", (Object)"Root");
        doc.addField("QNAME", (Object)("{http://www.alfresco.org/model/content/1.0}folder-" + i));
        doc.addField("PRIMARYPARENT", (Object)"Root");
        doc.addField("ASSOCTYPEQNAME", (Object)"{http://www.alfresco.org/model/system/1.0}children");
        doc.addField("PRIMARYASSOCTYPEQNAME", (Object)"{http://www.alfresco.org/model/system/1.0}children");
        doc.addField("ANCESTOR", (Object)"Root");
        doc.addField("FTSSTATUS", (Object)"Clean");
        doc.addField("ID", (Object)("LEAF-" + dbid));
        doc.addField("TX", (Object)"TX-1");
        doc.addField("ISROOT", (Object)"T");
        doc.addField("ISNODE", (Object)"T");
        doc.addField("DBID", (Object)("" + dbid));
        doc.addField("TYPE", (Object)"{http://www.alfresco.org/model/content/1.0}folder");
        doc.addField("ASPECT", (Object)"{http://www.alfresco.org/model/content/1.0}auditable");
        doc.addField("@{http://www.alfresco.org/model/system/1.0}locale", (Object)"en");
        doc.addField("@{http://www.alfresco.org/model/content/1.0}title", (Object)("Folder " + i));
        doc.addField("@{http://www.alfresco.org/model/content/1.0}name", (Object)("Folder " + i));
        doc.addField("@{http://www.alfresco.org/model/content/1.0}created", (Object)"2010-07-21T10:52:00.000Z");
        doc.addField("@{http://www.alfresco.org/model/content/1.0}creator", (Object)"Andy");
        doc.addField("@{http://www.alfresco.org/model/content/1.0}modified", (Object)"2010-07-21T10:52:00.000Z");
        doc.addField("@{http://www.alfresco.org/model/content/1.0}modifier", (Object)"Andy");
        return doc;
    }

    public static SolrInputDocument createContainerPathDocument(int dbid, int i) {
        SolrInputDocument doc = new SolrInputDocument();
        doc.addField("ID", (Object)("AUX-" + dbid));
        doc.addField("TX", (Object)"TX-1");
        doc.addField("DBID", (Object)("" + dbid));
        QName first = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)("folder_" + i));
        doc.addField("PATH", (Object)("/" + ISO9075.getXPathName((QName)first)));
        doc.addField("ACLID", (Object)("" + (i + 2)));
        doc.addField("OWNER", (Object)"Bob");
        return doc;
    }

    public static SolrInputDocument createRootDocument(int dbid) {
        SolrInputDocument doc = new SolrInputDocument();
        doc.addField("ISCATEGORY", (Object)"F");
        doc.addField("FTSSTATUS", (Object)"Clean");
        doc.addField("ID", (Object)("LEAF-" + dbid));
        doc.addField("TX", (Object)"TX-1");
        doc.addField("ISROOT", (Object)"T");
        doc.addField("ISNODE", (Object)"T");
        doc.addField("DBID", (Object)("" + dbid));
        return doc;
    }

    public static SolrInputDocument createRootPathDocument(int dbid) {
        SolrInputDocument doc = new SolrInputDocument();
        doc.addField("PATH", (Object)"/");
        doc.addField("ID", (Object)("AUX-" + dbid));
        doc.addField("TX", (Object)"TX-1");
        doc.addField("DBID", (Object)("" + dbid));
        doc.addField("ACLID", (Object)"1");
        return doc;
    }

    public static SolrServer getRemoteServer() throws MalformedURLException {
        CommonsHttpSolrServer solr = new CommonsHttpSolrServer("http://localhost:8080/solr/test");
        solr.setRequestWriter((RequestWriter)new BinaryRequestWriter());
        return solr;
    }
}

