/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Locale;
import org.alfresco.repo.search.MLAnalysisMode;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.security.AuthorityType;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.QParser;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public abstract class AbstractQParser
extends QParser {
    protected static final Logger log = LoggerFactory.getLogger(AbstractQParser.class);
    private static final String ALFRESCO_JSON = "ALFRESCO_JSON";
    private static final String AUTHORITY_FILTER_FROM_JSON = "AUTHORITY_FILTER_FROM_JSON";
    private static final String TENANT_FILTER_FROM_JSON = "TENANT_FILTER_FROM_JSON";

    public AbstractQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        super(qstr, localParams, params, req);
    }

    protected SearchParameters getSearchParameters() {
        String defaultField;
        SearchParameters searchParameters = new SearchParameters();
        Iterable streams = this.req.getContentStreams();
        JSONObject json = (JSONObject)this.req.getContext().get(ALFRESCO_JSON);
        if (json == null && streams != null) {
            try {
                BufferedReader reader = null;
                for (ContentStream stream : streams) {
                    reader = new BufferedReader(new InputStreamReader(stream.getStream(), "UTF-8"));
                }
                if (reader != null) {
                    json = new JSONObject(new JSONTokener(reader));
                    this.req.getContext().put(ALFRESCO_JSON, json);
                }
            }
            catch (JSONException e) {
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (json != null) {
            try {
                String tenantString;
                JSONArray tenants;
                ArrayList<String> tenantList;
                if (this.getString().equals(AUTHORITY_FILTER_FROM_JSON)) {
                    tenantList = new ArrayList<String>(1);
                    tenants = json.getJSONArray("tenants");
                    for (int i = 0; i < tenants.length(); ++i) {
                        tenantString = tenants.getString(i);
                        tenantList.add(tenantString);
                    }
                    ArrayList<String> authorityList = new ArrayList<String>(1);
                    JSONArray authorities = json.getJSONArray("authorities");
                    for (int i = 0; i < authorities.length(); ++i) {
                        String authorityString = authorities.getString(i);
                        authorityList.add(authorityString);
                    }
                    StringBuilder authQuery = new StringBuilder();
                    for (String tenant : tenantList) {
                        block13: for (String authority : authorityList) {
                            if (authQuery.length() > 0) {
                                authQuery.append(" ");
                            }
                            switch (AuthorityType.getAuthorityType((String)authority)) {
                                case USER: {
                                    authQuery.append("|AUTHORITY:\"").append(authority).append("\"");
                                    continue block13;
                                }
                                case GROUP: 
                                case EVERYONE: 
                                case GUEST: {
                                    if (tenant.length() == 0) {
                                        authQuery.append("|AUTHORITY:\"").append(authority).append("\"");
                                        continue block13;
                                    }
                                    authQuery.append("|AUTHORITY:\"").append(authority).append("@").append(tenant).append("\"");
                                    continue block13;
                                }
                            }
                            authQuery.append("|AUTHORITY:\"").append(authority).append("\"");
                        }
                    }
                    if (authQuery.length() > 0) {
                        searchParameters.setQuery(authQuery.toString());
                    }
                } else if (this.getString().equals(TENANT_FILTER_FROM_JSON)) {
                    tenantList = new ArrayList(1);
                    tenants = json.getJSONArray("tenants");
                    for (int i = 0; i < tenants.length(); ++i) {
                        tenantString = tenants.getString(i);
                        tenantList.add(tenantString);
                    }
                    StringBuilder tenantQuery = new StringBuilder();
                    for (String tenant : tenantList) {
                        if (tenantQuery.length() > 0) {
                            tenantQuery.append(" ");
                        }
                        if (tenant.length() > 0) {
                            tenantQuery.append("|TENANT:\"").append(tenant).append("\"");
                            continue;
                        }
                        tenantQuery.append("|TENANT:\"").append("_DEFAULT_").append("\"");
                    }
                    searchParameters.setQuery(tenantQuery.toString());
                } else {
                    String query = json.getString("query");
                    if (query != null) {
                        searchParameters.setQuery(query);
                    }
                }
                JSONArray locales = json.getJSONArray("locales");
                for (int i = 0; i < locales.length(); ++i) {
                    String localeString = locales.getString(i);
                    Locale locale = (Locale)DefaultTypeConverter.INSTANCE.convert(Locale.class, (Object)localeString);
                    searchParameters.addLocale(locale);
                }
                JSONArray templates = json.getJSONArray("templates");
                for (int i = 0; i < templates.length(); ++i) {
                    JSONObject template = templates.getJSONObject(i);
                    String name = template.getString("name");
                    String queryTemplate = template.getString("template");
                    searchParameters.addQueryTemplate(name, queryTemplate);
                }
                JSONArray allAttributes = json.getJSONArray("allAttributes");
                for (int i = 0; i < allAttributes.length(); ++i) {
                    String allAttribute = allAttributes.getString(i);
                    searchParameters.addAllAttribute(allAttribute);
                }
                searchParameters.setDefaultFTSOperator(SearchParameters.Operator.valueOf((String)json.getString("defaultFTSOperator")));
                searchParameters.setDefaultFTSFieldConnective(SearchParameters.Operator.valueOf((String)json.getString("defaultFTSFieldOperator")));
                if (json.has("mlAnalaysisMode")) {
                    searchParameters.setMlAnalaysisMode(MLAnalysisMode.valueOf((String)json.getString("mlAnalaysisMode")));
                }
                searchParameters.setNamespace(json.getString("defaultNamespace"));
                JSONArray textAttributes = json.getJSONArray("textAttributes");
                for (int i = 0; i < textAttributes.length(); ++i) {
                    String textAttribute = textAttributes.getString(i);
                    searchParameters.addAllAttribute(textAttribute);
                }
            }
            catch (JSONException e) {
                // empty catch block
            }
        }
        if (json != null && log.isDebugEnabled()) {
            log.debug(json.toString());
        }
        if (searchParameters.getQuery() == null) {
            searchParameters.setQuery(this.getString());
        }
        if (searchParameters.getLocales().size() == 0) {
            searchParameters.addLocale(I18NUtil.getLocale());
        }
        if ((defaultField = this.getParam("df")) != null) {
            searchParameters.setDefaultFieldName(defaultField);
        }
        searchParameters.setNamespace("http://www.alfresco.org/model/content/1.0");
        return searchParameters;
    }
}

