/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import org.alfresco.repo.search.MLAnalysisMode;
import org.alfresco.repo.search.impl.lucene.AbstractLuceneQueryParser;
import org.alfresco.repo.search.impl.querymodel.impl.lucene.LuceneQueryBuilderContext;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.solr.AlfrescoSolrDataModel;
import org.alfresco.solr.SolrLuceneAnalyser;
import org.alfresco.solr.query.SolrQueryParser;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;

public class LuceneQueryBuilderContextSolrImpl
implements LuceneQueryBuilderContext {
    private SolrQueryParser lqp;
    private NamespacePrefixResolver namespacePrefixResolver;

    public LuceneQueryBuilderContextSolrImpl(DictionaryService dictionaryService, NamespacePrefixResolver namespacePrefixResolver, TenantService tenantService, SearchParameters searchParameters, MLAnalysisMode defaultSearchMLAnalysisMode, IndexReader indexReader, Analyzer defaultAnalyzer, AlfrescoSolrDataModel model) {
        SolrLuceneAnalyser analyzer = new SolrLuceneAnalyser(dictionaryService, searchParameters.getMlAnalaysisMode() == null ? defaultSearchMLAnalysisMode : searchParameters.getMlAnalaysisMode(), defaultAnalyzer, model);
        this.lqp = new SolrQueryParser(searchParameters.getDefaultFieldName(), (Analyzer)analyzer);
        this.lqp.setDefaultOperator(AbstractLuceneQueryParser.OR_OPERATOR);
        this.lqp.setDictionaryService(dictionaryService);
        this.lqp.setNamespacePrefixResolver(namespacePrefixResolver);
        this.lqp.setTenantService(tenantService);
        this.lqp.setSearchParameters(searchParameters);
        this.lqp.setDefaultSearchMLAnalysisMode(defaultSearchMLAnalysisMode);
        this.lqp.setIndexReader(indexReader);
        this.lqp.setAllowLeadingWildcard(true);
        this.namespacePrefixResolver = namespacePrefixResolver;
    }

    public AbstractLuceneQueryParser getLuceneQueryParser() {
        return this.lqp;
    }

    public NamespacePrefixResolver getNamespacePrefixResolver() {
        return this.namespacePrefixResolver;
    }
}

