/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.io.IOException;
import org.alfresco.solr.query.SolrCachingPathScorer;
import org.alfresco.solr.query.SolrPathQuery;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;
import org.apache.solr.search.SolrIndexReader;
import org.apache.solr.search.SolrIndexSearcher;

public class SolrCachingPathQuery
extends Query {
    SolrPathQuery pathQuery;

    public SolrCachingPathQuery(SolrPathQuery pathQuery) {
        this.pathQuery = pathQuery;
    }

    public Weight createWeight(Searcher searcher) throws IOException {
        if (!(searcher instanceof SolrIndexSearcher)) {
            throw new IllegalStateException("Must have a SolrIndexSearcher");
        }
        return new SolrCachingPathQueryWeight((SolrIndexSearcher)searcher);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CACHED -> :");
        stringBuilder.append(this.pathQuery.toString());
        return stringBuilder.toString();
    }

    public String toString(String field) {
        return this.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.pathQuery == null ? 0 : this.pathQuery.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        SolrCachingPathQuery other = (SolrCachingPathQuery)((Object)obj);
        return !(this.pathQuery == null ? other.pathQuery != null : !this.pathQuery.equals((Object)other.pathQuery));
    }

    private class SolrCachingPathQueryWeight
    extends Weight {
        SolrIndexSearcher searcher;
        private Similarity similarity;
        private float value;
        private float idf;
        private float queryNorm;
        private float queryWeight;
        private Explanation.IDFExplanation idfExp;

        public SolrCachingPathQueryWeight(SolrIndexSearcher searcher) throws IOException {
            this.searcher = searcher;
            this.similarity = SolrCachingPathQuery.this.getSimilarity((Searcher)searcher);
            this.idfExp = this.similarity.idfExplain(SolrCachingPathQuery.this.pathQuery.getTerms(), (Searcher)searcher);
            this.idf = this.idfExp.getIdf();
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            throw new UnsupportedOperationException();
        }

        public Query getQuery() {
            return SolrCachingPathQuery.this;
        }

        public float getValue() {
            return this.value;
        }

        public void normalize(float queryNorm) {
            this.queryNorm = queryNorm;
            this.queryWeight *= queryNorm;
            this.value = this.queryWeight * this.idf;
        }

        public float sumOfSquaredWeights() throws IOException {
            this.queryWeight = this.idf * SolrCachingPathQuery.this.getBoost();
            return this.queryWeight * this.queryWeight;
        }

        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            if (!(reader instanceof SolrIndexReader)) {
                throw new IllegalStateException("Must have a SolrIndexReader");
            }
            return SolrCachingPathScorer.createPathScorer(this.searcher, SolrCachingPathQuery.this.getSimilarity((Searcher)this.searcher), SolrCachingPathQuery.this.pathQuery, (SolrIndexReader)reader);
        }
    }
}

