/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.io.IOException;
import org.alfresco.solr.AlfrescoSolrEventListener;
import org.alfresco.solr.query.AbstractSolrCachingScorer;
import org.alfresco.solr.query.SolrPathQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.util.OpenBitSet;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.SolrIndexReader;
import org.apache.solr.search.SolrIndexSearcher;

public class SolrCachingPathScorer
extends AbstractSolrCachingScorer {
    SolrCachingPathScorer(Similarity similarity, DocSet in, SolrIndexReader solrIndexReader) {
        super(similarity, in, solrIndexReader);
    }

    public static SolrCachingPathScorer createPathScorer(SolrIndexSearcher searcher, Similarity similarity, SolrPathQuery solrPathQuery, SolrIndexReader reader) throws IOException {
        DocSet docSet = searcher.getDocSet((Query)solrPathQuery);
        AlfrescoSolrEventListener.CacheEntry[] indexedByDocId = (AlfrescoSolrEventListener.CacheEntry[])searcher.cacheLookup(AlfrescoSolrEventListener.ALFRESCO_CACHE, (Object)AlfrescoSolrEventListener.KEY_DBID_LEAF_PATH_BY_DOC_ID);
        OpenBitSet translated = new OpenBitSet();
        if (docSet instanceof BitDocSet) {
            BitDocSet source = (BitDocSet)docSet;
            OpenBitSet openBitSet = source.getBits();
            int current = -1;
            while ((current = openBitSet.nextSetBit(current + 1)) != -1) {
                AlfrescoSolrEventListener.CacheEntry entry = indexedByDocId[current];
                translated.set((long)entry.getLeaf());
            }
        } else {
            DocIterator it = docSet.iterator();
            while (it.hasNext()) {
                AlfrescoSolrEventListener.CacheEntry entry = indexedByDocId[it.nextDoc()];
                translated.set((long)entry.getLeaf());
            }
        }
        return new SolrCachingPathScorer(similarity, (DocSet)new BitDocSet(translated), reader);
    }
}

