/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.io.IOException;
import org.alfresco.solr.query.SolrCachingReaderScorer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;
import org.apache.solr.search.SolrIndexReader;
import org.apache.solr.search.SolrIndexSearcher;

public class SolrCachingReaderQuery
extends Query {
    String authority;

    public SolrCachingReaderQuery(String authority) {
        this.authority = authority;
    }

    public Weight createWeight(Searcher searcher) throws IOException {
        if (!(searcher instanceof SolrIndexSearcher)) {
            throw new IllegalStateException("Must have a SolrIndexSearcher");
        }
        return new SolrCachingAuthorityQueryWeight((SolrIndexSearcher)searcher);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CACHED -> :");
        stringBuilder.append(this.authority.toString());
        return stringBuilder.toString();
    }

    public String toString(String field) {
        return this.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.authority == null ? 0 : this.authority.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        SolrCachingReaderQuery other = (SolrCachingReaderQuery)((Object)obj);
        return !(this.authority == null ? other.authority != null : !this.authority.equals(other.authority));
    }

    private class SolrCachingAuthorityQueryWeight
    extends Weight {
        SolrIndexSearcher searcher;
        private Similarity similarity;
        private float value;
        private float idf;
        private float queryNorm;
        private float queryWeight;
        private Explanation.IDFExplanation idfExp;

        public SolrCachingAuthorityQueryWeight(SolrIndexSearcher searcher) throws IOException {
            this.searcher = searcher;
            this.similarity = SolrCachingReaderQuery.this.getSimilarity((Searcher)searcher);
            this.idfExp = this.similarity.idfExplain(new Term("READER", SolrCachingReaderQuery.this.authority), (Searcher)searcher);
            this.idf = this.idfExp.getIdf();
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            throw new UnsupportedOperationException();
        }

        public Query getQuery() {
            return SolrCachingReaderQuery.this;
        }

        public float getValue() {
            return this.value;
        }

        public void normalize(float queryNorm) {
            this.queryNorm = queryNorm;
            this.queryWeight *= queryNorm;
            this.value = this.queryWeight * this.idf;
        }

        public float sumOfSquaredWeights() throws IOException {
            this.queryWeight = this.idf * SolrCachingReaderQuery.this.getBoost();
            return this.queryWeight * this.queryWeight;
        }

        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            if (!(reader instanceof SolrIndexReader)) {
                throw new IllegalStateException("Must have a SolrIndexReader");
            }
            return SolrCachingReaderScorer.createReaderScorer(this.searcher, SolrCachingReaderQuery.this.getSimilarity((Searcher)this.searcher), SolrCachingReaderQuery.this.authority, (SolrIndexReader)reader);
        }
    }
}

