/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import com.werken.saxpath.XPathReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Locale;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.dictionary.IndexTokenisationMode;
import org.alfresco.repo.search.MLAnalysisMode;
import org.alfresco.repo.search.impl.lucene.AbstractLuceneQueryParser;
import org.alfresco.repo.search.impl.lucene.AnalysisMode;
import org.alfresco.repo.search.impl.lucene.LuceneFunction;
import org.alfresco.repo.search.impl.lucene.query.CaseInsensitiveFieldQuery;
import org.alfresco.repo.search.impl.lucene.query.CaseInsensitiveFieldRangeQuery;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.solr.query.SolrCachingAuthorityQuery;
import org.alfresco.solr.query.SolrCachingAuxDocQuery;
import org.alfresco.solr.query.SolrCachingOwnerQuery;
import org.alfresco.solr.query.SolrCachingPathQuery;
import org.alfresco.solr.query.SolrCachingReaderQuery;
import org.alfresco.solr.query.SolrPathQuery;
import org.alfresco.solr.query.SolrXPathHandler;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.CharStream;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParserTokenManager;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.saxpath.SAXPathException;
import org.saxpath.XPathHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolrQueryParser
extends AbstractLuceneQueryParser {
    protected Query createIdQuery(String queryText) {
        if (NodeRef.isNodeRef((String)queryText)) {
            return this.createNodeRefQuery("LID", queryText);
        }
        return this.createNodeRefQuery("ID", queryText);
    }

    protected Query createPathQuery(String queryText, boolean withRepeats) throws SAXPathException {
        XPathReader reader = new XPathReader();
        SolrXPathHandler handler = new SolrXPathHandler();
        handler.setNamespacePrefixResolver(this.namespacePrefixResolver);
        handler.setDictionaryService(this.dictionaryService);
        reader.setXPathHandler((XPathHandler)handler);
        reader.parse(queryText);
        SolrPathQuery pathQuery = handler.getQuery();
        pathQuery.setRepeats(withRepeats);
        return new SolrCachingPathQuery(pathQuery);
    }

    protected Query createQNameQuery(String queryText) throws SAXPathException {
        XPathReader reader = new XPathReader();
        SolrXPathHandler handler = new SolrXPathHandler();
        handler.setNamespacePrefixResolver(this.namespacePrefixResolver);
        handler.setDictionaryService(this.dictionaryService);
        reader.setXPathHandler((XPathHandler)handler);
        reader.parse("//" + queryText);
        SolrPathQuery pathQuery = handler.getQuery();
        return new SolrCachingPathQuery(pathQuery);
    }

    protected Query createPrimaryAssocTypeQNameQuery(String queryText) throws SAXPathException {
        XPathReader reader = new XPathReader();
        SolrXPathHandler handler = new SolrXPathHandler();
        handler.setNamespacePrefixResolver(this.namespacePrefixResolver);
        handler.setDictionaryService(this.dictionaryService);
        reader.setXPathHandler((XPathHandler)handler);
        reader.parse("//" + queryText);
        SolrPathQuery pathQuery = handler.getQuery();
        pathQuery.setPathField("PRIMARYASSOCTYPEQNAME");
        return new SolrCachingPathQuery(pathQuery);
    }

    protected Query createAssocTypeQNameQuery(String queryText) throws SAXPathException {
        BooleanQuery booleanQuery = new BooleanQuery();
        XPathReader reader = new XPathReader();
        SolrXPathHandler handler = new SolrXPathHandler();
        handler.setNamespacePrefixResolver(this.namespacePrefixResolver);
        handler.setDictionaryService(this.dictionaryService);
        reader.setXPathHandler((XPathHandler)handler);
        reader.parse("//" + queryText);
        SolrPathQuery pathQuery = handler.getQuery();
        pathQuery.setPathField("ASSOCTYPEQNAME");
        booleanQuery.add((Query)new SolrCachingPathQuery(pathQuery), BooleanClause.Occur.SHOULD);
        booleanQuery.add(this.createPrimaryAssocTypeQNameQuery(queryText), BooleanClause.Occur.SHOULD);
        return booleanQuery;
    }

    protected Query createAclIdQuery(String queryText) throws ParseException {
        return this.getFieldQueryImpl("ACLID", queryText, AnalysisMode.DEFAULT, LuceneFunction.FIELD);
    }

    protected Query createOwnerQuery(String queryText) throws ParseException {
        return new SolrCachingOwnerQuery(queryText);
    }

    protected Query createReaderQuery(String queryText) throws ParseException {
        return new SolrCachingReaderQuery(queryText);
    }

    protected Query createAuthorityQuery(String queryText) throws ParseException {
        return new SolrCachingAuthorityQuery(queryText);
    }

    protected Query createParentQuery(String queryText) {
        Query query = super.createParentQuery(queryText);
        return new SolrCachingAuxDocQuery(query);
    }

    protected Query createPrimaryParentQuery(String queryText) {
        Query query = super.createPrimaryParentQuery(queryText);
        return new SolrCachingAuxDocQuery(query);
    }

    protected Query create(String queryText) {
        Query query = super.createPrimaryParentQuery(queryText);
        return new SolrCachingAuxDocQuery(query);
    }

    public SolrQueryParser(String arg0, Analyzer arg1) {
        super(arg0, arg1);
    }

    public SolrQueryParser(CharStream arg0) {
        super(arg0);
    }

    public SolrQueryParser(QueryParserTokenManager arg0) {
        super(arg0);
    }

    protected Query addContentAttributeQuery(String queryText, AbstractLuceneQueryParser.SubQuery subQueryBuilder, AnalysisMode analysisMode, LuceneFunction luceneFunction, String expandedFieldName, List<Locale> expandedLocales, MLAnalysisMode mlAnalysisMode) throws ParseException {
        BooleanQuery booleanQuery = new BooleanQuery();
        for (Locale locale : expandedLocales) {
            Query subQuery;
            StringBuilder builder;
            if (locale.toString().length() == 0) {
                builder = new StringBuilder(queryText.length() + 10);
                builder.append("\u0000").append(locale.toString()).append("\u0000").append(queryText);
                subQuery = subQueryBuilder.getQuery(expandedFieldName + ".__", builder.toString(), analysisMode, luceneFunction);
                if (subQuery != null) {
                    booleanQuery.add(subQuery, BooleanClause.Occur.SHOULD);
                    continue;
                }
                booleanQuery.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
                continue;
            }
            builder = new StringBuilder(queryText.length() + 10);
            builder.append("\u0000").append(locale.toString()).append("\u0000").append(queryText);
            subQuery = subQueryBuilder.getQuery(expandedFieldName, builder.toString(), analysisMode, luceneFunction);
            if (subQuery != null) {
                booleanQuery.add(subQuery, BooleanClause.Occur.SHOULD);
                continue;
            }
            booleanQuery.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
        }
        return booleanQuery;
    }

    protected void addLocaleSpecificUntokenisedMLOrTextFunction(String expandedFieldName, String queryText, LuceneFunction luceneFunction, BooleanQuery booleanQuery, MLAnalysisMode mlAnalysisMode, Locale locale, IndexTokenisationMode tokenisationMode) {
        StringBuilder builder = new StringBuilder(queryText.length() + 10);
        builder.append("\u0000").append(locale.toString()).append("\u0000").append(queryText);
        CaseInsensitiveFieldQuery subQuery = new CaseInsensitiveFieldQuery(new Term(this.getFieldName(expandedFieldName, locale, tokenisationMode, IndexTokenisationMode.FALSE), builder.toString()));
        booleanQuery.add((Query)subQuery, BooleanClause.Occur.SHOULD);
        if (booleanQuery.getClauses().length == 0) {
            booleanQuery.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
        }
    }

    private String getFieldName(String baseFieldName, Locale locale, IndexTokenisationMode actualIndexTokenisationMode, IndexTokenisationMode preferredIndexTokenisationMode) {
        StringBuilder builder = new StringBuilder(baseFieldName.length() + 5);
        builder.append(baseFieldName);
        if (locale.toString().length() == 0) {
            builder.append(".__");
        }
        block0 : switch (actualIndexTokenisationMode) {
            case BOTH: {
                switch (preferredIndexTokenisationMode) {
                    case BOTH: {
                        throw new IllegalStateException("Preferred mode can not be BOTH");
                    }
                    case FALSE: {
                        builder.append(".u");
                        break block0;
                    }
                }
                break;
            }
            case FALSE: {
                builder.append(".u");
                break;
            }
        }
        return builder.toString();
    }

    protected void addLocaleSpecificUntokenisedTextRangeFunction(String expandedFieldName, String lower, String upper, boolean includeLower, boolean includeUpper, LuceneFunction luceneFunction, BooleanQuery booleanQuery, MLAnalysisMode mlAnalysisMode, Locale locale, IndexTokenisationMode tokenisationMode) throws ParseException {
        String field = this.getFieldName(expandedFieldName, locale, tokenisationMode, IndexTokenisationMode.FALSE);
        StringBuilder builder = new StringBuilder();
        builder.append("\u0000").append(locale.toString()).append("\u0000").append(lower);
        String first = this.getToken(field, builder.toString(), AnalysisMode.IDENTIFIER);
        builder = new StringBuilder();
        builder.append("\u0000").append(locale.toString()).append("\u0000").append(upper);
        String last = this.getToken(field, builder.toString(), AnalysisMode.IDENTIFIER);
        CaseInsensitiveFieldRangeQuery query = new CaseInsensitiveFieldRangeQuery(expandedFieldName, first, last, includeLower, includeUpper);
        booleanQuery.add((Query)query, BooleanClause.Occur.SHOULD);
    }

    protected void addMLTextAttributeQuery(String field, String queryText, AbstractLuceneQueryParser.SubQuery subQueryBuilder, AnalysisMode analysisMode, LuceneFunction luceneFunction, String expandedFieldName, PropertyDefinition propertyDef, IndexTokenisationMode tokenisationMode, BooleanQuery booleanQuery, MLAnalysisMode mlAnalysisMode, Locale locale) throws ParseException {
        this.addMLTextOrTextAttributeQuery(field, queryText, subQueryBuilder, analysisMode, luceneFunction, expandedFieldName, tokenisationMode, booleanQuery, mlAnalysisMode, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMLTextOrTextAttributeQuery(String field, String queryText, AbstractLuceneQueryParser.SubQuery subQueryBuilder, AnalysisMode analysisMode, LuceneFunction luceneFunction, String expandedFieldName, IndexTokenisationMode tokenisationMode, BooleanQuery booleanQuery, MLAnalysisMode mlAnalysisMode, Locale locale) throws ParseException {
        boolean lowercaseExpandedTerms = this.getLowercaseExpandedTerms();
        try {
            block1 : switch (tokenisationMode) {
                case BOTH: {
                    switch (analysisMode) {
                        default: {
                            this.addLocaleSpecificMLOrTextAttribute(queryText, subQueryBuilder, analysisMode, luceneFunction, booleanQuery, locale, expandedFieldName, tokenisationMode, IndexTokenisationMode.TRUE);
                            break block1;
                        }
                        case IDENTIFIER: 
                        case FUZZY: 
                        case PREFIX: 
                        case WILD: 
                        case LIKE: 
                    }
                    this.setLowercaseExpandedTerms(false);
                    this.addLocaleSpecificMLOrTextAttribute(queryText, subQueryBuilder, analysisMode, luceneFunction, booleanQuery, locale, expandedFieldName, tokenisationMode, IndexTokenisationMode.FALSE);
                    break;
                }
                case FALSE: {
                    this.setLowercaseExpandedTerms(false);
                    this.addLocaleSpecificMLOrTextAttribute(queryText, subQueryBuilder, analysisMode, luceneFunction, booleanQuery, locale, expandedFieldName, tokenisationMode, IndexTokenisationMode.FALSE);
                    break;
                }
                default: {
                    this.addLocaleSpecificMLOrTextAttribute(queryText, subQueryBuilder, analysisMode, luceneFunction, booleanQuery, locale, expandedFieldName, tokenisationMode, IndexTokenisationMode.TRUE);
                }
            }
            Object var13_12 = null;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            this.setLowercaseExpandedTerms(lowercaseExpandedTerms);
            throw throwable;
        }
        this.setLowercaseExpandedTerms(lowercaseExpandedTerms);
    }

    protected void addTextAttributeQuery(String field, String queryText, AbstractLuceneQueryParser.SubQuery subQueryBuilder, AnalysisMode analysisMode, LuceneFunction luceneFunction, String expandedFieldName, IndexTokenisationMode tokenisationMode, BooleanQuery booleanQuery, MLAnalysisMode mlAnalysisMode, Locale locale) throws ParseException {
        this.addMLTextOrTextAttributeQuery(field, queryText, subQueryBuilder, analysisMode, luceneFunction, expandedFieldName, tokenisationMode, booleanQuery, mlAnalysisMode, locale);
    }

    private void addLocaleSpecificMLOrTextAttribute(String queryText, AbstractLuceneQueryParser.SubQuery subQueryBuilder, AnalysisMode analysisMode, LuceneFunction luceneFunction, BooleanQuery booleanQuery, Locale locale, String textFieldName, IndexTokenisationMode tokenisationMode, IndexTokenisationMode preferredTokenisationMode) throws ParseException {
        StringBuilder builder = new StringBuilder(queryText.length() + 10);
        builder.append("\u0000").append(locale.toString()).append("\u0000").append(queryText);
        Query subQuery = subQueryBuilder.getQuery(this.getFieldName(textFieldName, locale, tokenisationMode, preferredTokenisationMode), builder.toString(), analysisMode, luceneFunction);
        if (subQuery != null) {
            booleanQuery.add(subQuery, BooleanClause.Occur.SHOULD);
        } else {
            booleanQuery.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
        }
    }

    protected void addTextRange(String field, String part1, String part2, boolean includeLower, boolean includeUpper, AnalysisMode analysisMode, String fieldName, PropertyDefinition propertyDef, IndexTokenisationMode tokenisationMode, BooleanQuery booleanQuery, MLAnalysisMode mlAnalysisMode, Locale locale) throws ParseException {
        block0 : switch (tokenisationMode) {
            case BOTH: {
                switch (analysisMode) {
                    case DEFAULT: 
                    case TOKENISE: {
                        this.addLocaleSpecificTextRange(fieldName, part1, part2, includeLower, includeUpper, booleanQuery, locale, analysisMode, tokenisationMode, IndexTokenisationMode.TRUE);
                        break block0;
                    }
                    case IDENTIFIER: {
                        this.addLocaleSpecificTextRange(fieldName, part1, part2, includeLower, includeUpper, booleanQuery, locale, analysisMode, tokenisationMode, IndexTokenisationMode.FALSE);
                        break block0;
                    }
                }
                throw new UnsupportedOperationException();
            }
            case FALSE: {
                this.addLocaleSpecificTextRange(fieldName, part1, part2, includeLower, includeUpper, booleanQuery, locale, analysisMode, tokenisationMode, IndexTokenisationMode.FALSE);
                break;
            }
            case TRUE: {
                this.addLocaleSpecificTextRange(fieldName, part1, part2, includeLower, includeUpper, booleanQuery, locale, analysisMode, tokenisationMode, IndexTokenisationMode.TRUE);
                break;
            }
        }
    }

    private void addLocaleSpecificTextRange(String expandedFieldName, String part1, String part2, boolean includeLower, boolean includeUpper, BooleanQuery booleanQuery, Locale locale, AnalysisMode analysisMode, IndexTokenisationMode tokenisationMode, IndexTokenisationMode preferredtokenisationMode) throws ParseException {
        String field = this.getFieldName(expandedFieldName, locale, tokenisationMode, preferredtokenisationMode);
        StringBuilder builder = new StringBuilder();
        builder.append("\u0000").append(locale.toString()).append("\u0000").append(part1);
        String first = this.getToken(field, builder.toString(), analysisMode);
        if (first == null && !field.endsWith(".u")) {
            first = this.getToken(field + ".u", builder.toString(), analysisMode);
        }
        builder = new StringBuilder();
        builder.append("\u0000").append(locale.toString()).append("\u0000").append(part2);
        String last = this.getToken(field, builder.toString(), analysisMode);
        if (last == null && !field.endsWith(".u")) {
            last = this.getToken(field + ".u", builder.toString(), analysisMode);
        }
        TermRangeQuery query = new TermRangeQuery(field, first, last, includeLower, includeUpper);
        booleanQuery.add((Query)query, BooleanClause.Occur.SHOULD);
    }

    protected boolean isLucene() {
        return false;
    }

    protected Query createAncestorQuery(String queryText) throws ParseException {
        Query query = super.createAncestorQuery(queryText);
        return new SolrCachingAuxDocQuery(query);
    }

    protected void addTextSpanQuery(String field, String first, String last, int slop, boolean inOrder, String expandedFieldName, IndexTokenisationMode tokenisationMode, BooleanQuery booleanQuery, MLAnalysisMode mlAnalysisMode, Locale locale) {
        this.addMLTextOrTextSpanQuery(field, first, last, slop, inOrder, expandedFieldName, tokenisationMode, booleanQuery, mlAnalysisMode, locale);
    }

    protected Query addContentSpanQuery(String field, String first, String last, int slop, boolean inOrder, String expandedFieldName, List<Locale> expandedLocales, MLAnalysisMode mlAnalysisMode) {
        try {
            BooleanQuery booleanQuery = new BooleanQuery();
            for (Locale locale : expandedLocales) {
                SpanNearQuery result;
                SpanTermQuery lastTerm;
                SpanTermQuery firstTerm;
                Token nextToken;
                Token reusableToken;
                TokenStream source;
                StringBuilder builder;
                if (locale.toString().length() == 0) {
                    builder = new StringBuilder(first.length() + 10);
                    builder.append("\u0000").append(locale.toString()).append("\u0000").append(first);
                    source = this.getAnalyzer().tokenStream(expandedFieldName + ".__", (Reader)new StringReader(builder.toString()), AnalysisMode.TOKENISE);
                    reusableToken = new Token();
                    nextToken = source.next(reusableToken);
                    firstTerm = new SpanTermQuery(new Term(expandedFieldName + ".__", nextToken.term()));
                    if (source.next(reusableToken) != null) {
                        throw new AlfrescoRuntimeException("Found extra token in span query: " + first);
                    }
                    builder = new StringBuilder(last.length() + 10);
                    builder.append("\u0000").append(locale.toString()).append("\u0000").append(last);
                    source = this.getAnalyzer().tokenStream(expandedFieldName + ".__", (Reader)new StringReader(builder.toString()), AnalysisMode.TOKENISE);
                    nextToken = source.next(reusableToken);
                    lastTerm = new SpanTermQuery(new Term(expandedFieldName + ".__", nextToken.term()));
                    if (source.next(reusableToken) != null) {
                        throw new AlfrescoRuntimeException("Found extra token in span query: " + last);
                    }
                    result = new SpanNearQuery(new SpanQuery[]{firstTerm, lastTerm}, slop, inOrder);
                    booleanQuery.add((Query)result, BooleanClause.Occur.SHOULD);
                    continue;
                }
                builder = new StringBuilder(first.length() + 10);
                builder.append("\u0000").append(locale.toString()).append("\u0000").append(first);
                source = this.getAnalyzer().tokenStream(expandedFieldName, (Reader)new StringReader(builder.toString()), AnalysisMode.TOKENISE);
                reusableToken = new Token();
                nextToken = source.next(reusableToken);
                firstTerm = new SpanTermQuery(new Term(expandedFieldName, nextToken.term()));
                if (source.next(reusableToken) != null) {
                    throw new AlfrescoRuntimeException("Found extra token in span query: " + first);
                }
                builder = new StringBuilder(last.length() + 10);
                builder.append("\u0000").append(locale.toString()).append("\u0000").append(last);
                source = this.getAnalyzer().tokenStream(expandedFieldName, (Reader)new StringReader(builder.toString()), AnalysisMode.TOKENISE);
                nextToken = source.next(reusableToken);
                lastTerm = new SpanTermQuery(new Term(expandedFieldName, nextToken.term()));
                if (source.next(reusableToken) != null) {
                    throw new AlfrescoRuntimeException("Found extra token in span query: " + last);
                }
                result = new SpanNearQuery(new SpanQuery[]{firstTerm, lastTerm}, slop, inOrder);
                booleanQuery.add((Query)result, BooleanClause.Occur.SHOULD);
            }
            return booleanQuery;
        }
        catch (IOException ioe) {
            return this.createNoMatchQuery();
        }
    }

    protected void addMLTextSpanQuery(String field, String first, String last, int slop, boolean inOrder, String expandedFieldName, PropertyDefinition propertyDef, IndexTokenisationMode tokenisationMode, BooleanQuery booleanQuery, MLAnalysisMode mlAnalysisMode, Locale locale) {
        this.addMLTextOrTextSpanQuery(field, first, last, slop, inOrder, expandedFieldName, tokenisationMode, booleanQuery, mlAnalysisMode, locale);
    }

    private void addMLTextOrTextSpanQuery(String field, String first, String last, int slop, boolean inOrder, String expandedFieldName, IndexTokenisationMode tokenisationMode, BooleanQuery booleanQuery, MLAnalysisMode mlAnalysisMode, Locale locale) {
        try {
            String fieldName = this.getFieldName(expandedFieldName, locale, tokenisationMode, IndexTokenisationMode.TRUE);
            StringBuilder builder = new StringBuilder(first.length() + 10);
            builder.append("\u0000").append(locale.toString()).append("\u0000").append(first);
            TokenStream source = this.getAnalyzer().tokenStream(fieldName, (Reader)new StringReader(builder.toString()), AnalysisMode.TOKENISE);
            Token reusableToken = new Token();
            Token nextToken = source.next(reusableToken);
            SpanTermQuery firstTerm = new SpanTermQuery(new Term(fieldName, nextToken.term()));
            if (source.next(reusableToken) != null) {
                throw new AlfrescoRuntimeException("Found extra token in span query: " + first);
            }
            builder = new StringBuilder(last.length() + 10);
            builder.append("\u0000").append(locale.toString()).append("\u0000").append(last);
            source = this.getAnalyzer().tokenStream(fieldName, (Reader)new StringReader(builder.toString()), AnalysisMode.TOKENISE);
            nextToken = source.next(reusableToken);
            SpanTermQuery lastTerm = new SpanTermQuery(new Term(fieldName, nextToken.term()));
            if (source.next(reusableToken) != null) {
                throw new AlfrescoRuntimeException("Found extra token in span query: " + last);
            }
            SpanNearQuery result = new SpanNearQuery(new SpanQuery[]{firstTerm, lastTerm}, slop, inOrder);
            booleanQuery.add((Query)result, BooleanClause.Occur.SHOULD);
        }
        catch (IOException ioe) {
            booleanQuery.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
        }
    }
}

