/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingDeque;
import org.alfresco.encryption.KeyResourceLoader;
import org.alfresco.encryption.KeyStoreParameters;
import org.alfresco.encryption.ssl.SSLEncryptionParameters;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.httpclient.AlfrescoHttpClient;
import org.alfresco.httpclient.AuthenticationException;
import org.alfresco.httpclient.HttpClientFactory;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.IndexTokenisationMode;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.dictionary.M2Namespace;
import org.alfresco.repo.search.impl.lucene.MultiReader;
import org.alfresco.repo.search.impl.lucene.analysis.NumericEncoder;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.ModelDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.solr.AclReport;
import org.alfresco.solr.AlfrescoCoreAdminHandler;
import org.alfresco.solr.AlfrescoSolrDataModel;
import org.alfresco.solr.NodeReport;
import org.alfresco.solr.client.Acl;
import org.alfresco.solr.client.AclChangeSet;
import org.alfresco.solr.client.AclReaders;
import org.alfresco.solr.client.AlfrescoModel;
import org.alfresco.solr.client.AlfrescoModelDiff;
import org.alfresco.solr.client.ContentPropertyValue;
import org.alfresco.solr.client.GetNodesParameters;
import org.alfresco.solr.client.MLTextPropertyValue;
import org.alfresco.solr.client.MultiPropertyValue;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.client.NodeMetaData;
import org.alfresco.solr.client.NodeMetaDataParameters;
import org.alfresco.solr.client.PropertyValue;
import org.alfresco.solr.client.SOLRAPIClient;
import org.alfresco.solr.client.SolrKeyResourceLoader;
import org.alfresco.solr.client.StringPropertyValue;
import org.alfresco.solr.client.Transaction;
import org.alfresco.solr.client.Transactions;
import org.alfresco.solr.tracker.CoreTrackerJob;
import org.alfresco.solr.tracker.IndexHealthReport;
import org.alfresco.util.ISO9075;
import org.alfresco.util.Pair;
import org.alfresco.util.TempFileProvider;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.OpenBitSet;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.core.CloseHook;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.schema.BinaryField;
import org.apache.solr.schema.CopyField;
import org.apache.solr.schema.DateField;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.SolrIndexReader;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.RollbackUpdateCommand;
import org.apache.solr.util.RefCounted;
import org.json.JSONException;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.util.FileCopyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreTracker
implements CloseHook {
    protected static final Logger log = LoggerFactory.getLogger(CoreTracker.class);
    private AlfrescoCoreAdminHandler adminHandler;
    private SOLRAPIClient client;
    private volatile long lastIndexedTxCommitTime = 0L;
    private volatile long lastIndexedChangeSetCommitTime = 0L;
    private volatile long lastTxOnServer = 0L;
    private volatile long lastIndexedTxIdBeforeHoles = -1L;
    private volatile long lastIndexedChangeSetIdBeforeHoles = -1L;
    private volatile boolean running = false;
    private volatile boolean checkedFirstTransactionTime = false;
    volatile boolean check = false;
    SolrCore core;
    private String alfrescoHost;
    private int alfrescoPort;
    private int alfrescoPortSSL;
    private String cron;
    private StoreRef storeRef;
    private long lag;
    private long holeRetention;
    private long batchCount;
    private String secureCommsType;
    private String cipherAlgorithm;
    private String keyStoreType;
    private String keyStoreProvider;
    private String passwordFileLocation;
    private String keyStoreLocation;
    private Long messageTimeout;
    private String macAlgorithm;
    private String sslKeyStoreType;
    private String sslKeyStoreProvider;
    private String sslKeyStoreLocation;
    private String sslKeyStorePasswordFileLocation;
    private String sslTrustStoreType;
    private String sslTrustStoreProvider;
    private String sslTrustStoreLocation;
    private String sslTrustStorePasswordFileLocation;
    private String id;
    private AlfrescoSolrDataModel dataModel;
    private ConcurrentLinkedQueue<Long> transactionsToReindex = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<Long> transactionsToIndex = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<Long> transactionsToPurge = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<Long> aclChangeSetsToReindex = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<Long> aclChangeSetsToIndex = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<Long> aclChangeSetsToPurge = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<Long> nodesToReindex = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<Long> nodesToIndex = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<Long> nodesToPurge = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<Long> aclsToReindex = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<Long> aclsToIndex = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<Long> aclsToPurge = new ConcurrentLinkedQueue();

    public long getLastIndexedCommitTime() {
        return this.lastIndexedTxCommitTime;
    }

    public boolean isRunning() {
        return this.running;
    }

    public long getLastTxOnServer() {
        return this.lastTxOnServer;
    }

    CoreTracker(AlfrescoCoreAdminHandler adminHandler, SolrCore core) {
        this.adminHandler = adminHandler;
        this.core = core;
        boolean storeAll = false;
        try {
            List lines = core.getResourceLoader().getLines("solrcore.properties");
            for (String line : lines) {
                if (line.length() == 0 || line.startsWith("#")) continue;
                String[] split = line.split("=", 2);
                if (split.length != 2) {
                    return;
                }
                if (split[0].equals("alfresco.host")) {
                    this.alfrescoHost = split[1];
                    continue;
                }
                if (split[0].equals("alfresco.port")) {
                    this.alfrescoPort = Integer.parseInt(split[1]);
                    continue;
                }
                if (split[0].equals("alfresco.port.ssl")) {
                    this.alfrescoPortSSL = Integer.parseInt(split[1]);
                    continue;
                }
                if (split[0].equals("alfresco.cron")) {
                    this.cron = split[1];
                    continue;
                }
                if (split[0].equals("alfresco.stores")) {
                    this.storeRef = new StoreRef(split[1]);
                    continue;
                }
                if (split[0].equals("alfresco.lag")) {
                    this.lag = Long.parseLong(split[1]);
                    continue;
                }
                if (split[0].equals("alfresco.hole.retention")) {
                    this.holeRetention = Long.parseLong(split[1]);
                    continue;
                }
                if (split[0].equals("alfresco.batch.count")) {
                    this.batchCount = Long.parseLong(split[1]);
                    continue;
                }
                if (split[0].equals("alfresco.storeAll")) {
                    storeAll = Boolean.parseBoolean(split[1]);
                    continue;
                }
                if (split[0].equals("alfresco.encryption.cipherAlgorithm")) {
                    this.cipherAlgorithm = split[1];
                    continue;
                }
                if (split[0].equals("alfresco.encryption.keystore.type")) {
                    this.keyStoreType = split[1];
                    continue;
                }
                if (split[0].equals("alfresco.encryption.keystore.provider")) {
                    this.keyStoreProvider = split[1];
                    continue;
                }
                if (split[0].equals("alfresco.encryption.keystore.passwordFileLocation")) {
                    this.passwordFileLocation = split[1];
                    continue;
                }
                if (split[0].equals("alfresco.encryption.keystore.location")) {
                    this.keyStoreLocation = split[1];
                    continue;
                }
                if (split[0].equals("alfresco.encryption.ssl.keystore.type")) {
                    this.sslKeyStoreType = split[1];
                    continue;
                }
                if (split[0].equals("alfresco.encryption.ssl.keystore.provider")) {
                    this.sslKeyStoreProvider = split[1];
                    continue;
                }
                if (split[0].equals("alfresco.encryption.ssl.keystore.location")) {
                    this.sslKeyStoreLocation = split[1];
                    continue;
                }
                if (split[0].equals("alfresco.encryption.ssl.keystore.passwordFileLocation")) {
                    this.sslKeyStorePasswordFileLocation = split[1];
                    continue;
                }
                if (split[0].equals("alfresco.encryption.ssl.truststore.type")) {
                    this.sslTrustStoreType = split[1];
                    continue;
                }
                if (split[0].equals("alfresco.encryption.ssl.truststore.provider")) {
                    this.sslTrustStoreProvider = split[1];
                    continue;
                }
                if (split[0].equals("alfresco.encryption.ssl.truststore.location")) {
                    this.sslTrustStoreLocation = split[1];
                    continue;
                }
                if (split[0].equals("alfresco.encryption.ssl.truststore.passwordFileLocation")) {
                    this.sslTrustStorePasswordFileLocation = split[1];
                    continue;
                }
                if (split[0].equals("alfresco.encryption.messageTimeout")) {
                    this.messageTimeout = Long.parseLong(split[1]);
                    continue;
                }
                if (split[0].equals("alfresco.encryption.macAlgorithm")) {
                    this.macAlgorithm = split[1];
                    continue;
                }
                if (!split[0].equals("alfresco.secureComms")) continue;
                this.secureCommsType = split[1];
            }
        }
        catch (IOException e1) {
            throw new AlfrescoRuntimeException("Error reading alfrecso core config for " + core.getName());
        }
        SolrResourceLoader loader = core.getSchema().getResourceLoader();
        this.id = loader.getInstanceDir();
        this.dataModel = AlfrescoSolrDataModel.getInstance(this.id);
        this.dataModel.setStoreAll(storeAll);
        this.client = new SOLRAPIClient(this.getRepoClient(loader), this.dataModel.getDictionaryService(), this.dataModel.getNamespaceDAO());
        JobDetail job = new JobDetail("CoreTracker-" + core.getName(), "Solr", CoreTrackerJob.class);
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put((Object)"TRACKER", (Object)this);
        job.setJobDataMap(jobDataMap);
        try {
            CronTrigger trigger = new CronTrigger("CoreTrackerTrigger" + core.getName(), "Solr", this.cron);
            adminHandler.getScheduler().scheduleJob(job, (Trigger)trigger);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
        core.addCloseHook((CloseHook)this);
    }

    protected AlfrescoHttpClient getRepoClient(SolrResourceLoader loader) {
        KeyStoreParameters keyStoreParameters = new KeyStoreParameters("SSL Key Store", this.sslKeyStoreType, this.sslKeyStoreProvider, this.sslKeyStorePasswordFileLocation, this.sslKeyStoreLocation);
        KeyStoreParameters trustStoreParameters = new KeyStoreParameters("SSL Trust Store", this.sslTrustStoreType, this.sslTrustStoreProvider, this.sslTrustStorePasswordFileLocation, this.sslTrustStoreLocation);
        SSLEncryptionParameters sslEncryptionParameters = new SSLEncryptionParameters(keyStoreParameters, trustStoreParameters);
        SolrKeyResourceLoader keyResourceLoader = new SolrKeyResourceLoader(loader);
        HttpClientFactory httpClientFactory = new HttpClientFactory(HttpClientFactory.SecureCommsType.getType((String)this.secureCommsType), sslEncryptionParameters, (KeyResourceLoader)keyResourceLoader, null, null, this.alfrescoHost, this.alfrescoPort, this.alfrescoPortSSL);
        AlfrescoHttpClient repoClient = httpClientFactory.getRepoClient(this.alfrescoHost, this.alfrescoPortSSL);
        return repoClient;
    }

    public boolean isCheck() {
        return this.check;
    }

    public void setCheck(boolean check) {
        this.check = check;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateIndex() {
        CoreTracker coreTracker = this;
        synchronized (coreTracker) {
            if (this.running) {
                log.info("... update for " + this.core.getName() + " is already running");
                return;
            }
            log.info("... updating " + this.core.getName());
            this.running = true;
        }
        try {
            this.purgeAclChangeSets();
            this.purgeAcls();
            this.purgeTransactions();
            this.purgeNodes();
            this.reindexAclChangeSets();
            this.reindexAcls();
            this.reindexTransactions();
            this.reindexNodes();
            this.indexAclChangeSets();
            this.indexAcls();
            this.indexTransactions();
            this.indexNodes();
            this.trackRepository();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (JSONException e1) {
            e1.printStackTrace();
        }
        catch (AuthenticationException e1) {
            e1.printStackTrace();
        }
        finally {
            this.running = false;
            this.check = false;
        }
    }

    public void indexAclChangeSets() throws AuthenticationException, IOException, JSONException {
        boolean requiresCommit = false;
        while (this.aclChangeSetsToIndex.peek() != null) {
            List<AclChangeSet> aclChangeSets;
            Long aclChangeSetId = this.aclChangeSetsToIndex.poll();
            if (aclChangeSetId == null || (aclChangeSets = this.client.getAclChangeSets(null, aclChangeSetId, null, aclChangeSetId + 1L, 1)).size() <= 0 || !aclChangeSetId.equals(aclChangeSets.get(0).getId())) continue;
            AclChangeSet changeSet = aclChangeSets.get(0);
            List<Acl> acls = this.client.getAcls(Collections.singletonList(changeSet), null, Integer.MAX_VALUE);
            for (Acl acl : acls) {
                List<AclReaders> readers = this.client.getAclReaders(Collections.singletonList(acl));
                this.indexAcl(readers, false);
            }
            this.indexAclTransaction(changeSet, false);
            requiresCommit = true;
        }
        if (requiresCommit) {
            this.core.getUpdateHandler().commit(new CommitUpdateCommand(false));
        }
    }

    public void indexAcls() throws AuthenticationException, IOException, JSONException {
        boolean requiresCommit = false;
        while (this.aclsToIndex.peek() != null) {
            Long aclId = this.aclsToIndex.poll();
            if (aclId == null) continue;
            Acl acl = new Acl(0L, aclId);
            List<AclReaders> readers = this.client.getAclReaders(Collections.singletonList(acl));
            this.indexAcl(readers, false);
            requiresCommit = true;
        }
        if (requiresCommit) {
            this.core.getUpdateHandler().commit(new CommitUpdateCommand(false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reindexAclChangeSets() throws AuthenticationException, IOException, JSONException {
        RefCounted refCounted = null;
        try {
            refCounted = this.core.getSearcher(false, true, null);
            SolrIndexSearcher solrIndexSearcher = (SolrIndexSearcher)refCounted.get();
            boolean requiresCommit = false;
            while (this.aclChangeSetsToReindex.peek() != null) {
                Long aclChangeSetId = this.aclChangeSetsToReindex.poll();
                if (aclChangeSetId == null) continue;
                this.deleteByAclChangeSetId(solrIndexSearcher, aclChangeSetId);
                List<AclChangeSet> aclChangeSets = this.client.getAclChangeSets(null, aclChangeSetId, null, aclChangeSetId + 1L, 1);
                if (aclChangeSets.size() <= 0 || !aclChangeSetId.equals(aclChangeSets.get(0).getId())) continue;
                AclChangeSet changeSet = aclChangeSets.get(0);
                List<Acl> acls = this.client.getAcls(Collections.singletonList(changeSet), null, Integer.MAX_VALUE);
                for (Acl acl : acls) {
                    List<AclReaders> readers = this.client.getAclReaders(Collections.singletonList(acl));
                    this.indexAcl(readers, true);
                }
                this.indexAclTransaction(changeSet, true);
                requiresCommit = true;
            }
            if (requiresCommit) {
                this.core.getUpdateHandler().commit(new CommitUpdateCommand(false));
            }
        }
        finally {
            if (refCounted != null) {
                refCounted.decref();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reindexAcls() throws AuthenticationException, IOException, JSONException {
        RefCounted refCounted = null;
        try {
            refCounted = this.core.getSearcher(false, true, null);
            SolrIndexSearcher solrIndexSearcher = (SolrIndexSearcher)refCounted.get();
            boolean requiresCommit = false;
            while (this.aclsToReindex.peek() != null) {
                Long aclId = this.aclsToReindex.poll();
                if (aclId == null) continue;
                this.deleteByAclId(solrIndexSearcher, aclId);
                Acl acl = new Acl(0L, aclId);
                List<AclReaders> readers = this.client.getAclReaders(Collections.singletonList(acl));
                this.indexAcl(readers, true);
                requiresCommit = true;
            }
            if (requiresCommit) {
                this.core.getUpdateHandler().commit(new CommitUpdateCommand(false));
            }
        }
        finally {
            if (refCounted != null) {
                refCounted.decref();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeAclChangeSets() throws AuthenticationException, IOException, JSONException {
        RefCounted refCounted = null;
        try {
            refCounted = this.core.getSearcher(false, true, null);
            SolrIndexSearcher solrIndexSearcher = (SolrIndexSearcher)refCounted.get();
            boolean requiresCommit = false;
            while (this.aclChangeSetsToPurge.peek() != null) {
                Long aclChangeSetId = this.aclChangeSetsToPurge.poll();
                if (aclChangeSetId == null) continue;
                this.deleteByAclChangeSetId(solrIndexSearcher, aclChangeSetId);
                requiresCommit = true;
            }
            if (requiresCommit) {
                this.core.getUpdateHandler().commit(new CommitUpdateCommand(false));
            }
        }
        finally {
            if (refCounted != null) {
                refCounted.decref();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeAcls() throws AuthenticationException, IOException, JSONException {
        RefCounted refCounted = null;
        try {
            refCounted = this.core.getSearcher(false, true, null);
            SolrIndexSearcher solrIndexSearcher = (SolrIndexSearcher)refCounted.get();
            boolean requiresCommit = false;
            while (this.aclsToPurge.peek() != null) {
                Long aclId = this.aclsToPurge.poll();
                if (aclId == null) continue;
                this.deleteByAclId(solrIndexSearcher, aclId);
                requiresCommit = true;
            }
            if (requiresCommit) {
                this.core.getUpdateHandler().commit(new CommitUpdateCommand(false));
            }
        }
        finally {
            if (refCounted != null) {
                refCounted.decref();
            }
        }
    }

    public void deleteByAclChangeSetId(SolrIndexSearcher solrIndexSearcher, Long aclChangeSetId) throws IOException {
        TermQuery query = new TermQuery(new Term("INACLTXID", NumericEncoder.encode((long)aclChangeSetId)));
        this.deleteByQuery(solrIndexSearcher, (Query)query);
    }

    public void deleteByAclId(SolrIndexSearcher solrIndexSearcher, Long aclId) throws IOException {
        TermQuery query = new TermQuery(new Term("ACLID", NumericEncoder.encode((long)aclId)));
        this.deleteByQuery(solrIndexSearcher, (Query)query);
    }

    private void deleteByQuery(SolrIndexSearcher solrIndexSearcher, Query query) throws IOException {
        HashSet<String> idsToDelete = new HashSet<String>();
        DocSet docSet = solrIndexSearcher.getDocSet(query);
        if (docSet instanceof BitDocSet) {
            BitDocSet source = (BitDocSet)docSet;
            OpenBitSet openBitSet = source.getBits();
            int current = -1;
            while ((current = openBitSet.nextSetBit(current + 1)) != -1) {
                Document doc = solrIndexSearcher.doc(current, Collections.singleton("ID"));
                Fieldable fieldable = doc.getFieldable("ID");
                if (fieldable == null) continue;
                idsToDelete.add(fieldable.stringValue());
            }
        } else {
            DocIterator it = docSet.iterator();
            while (it.hasNext()) {
                Document doc = solrIndexSearcher.doc(it.nextDoc(), Collections.singleton("ID"));
                Fieldable fieldable = doc.getFieldable("ID");
                if (fieldable == null) continue;
                idsToDelete.add(fieldable.stringValue());
            }
        }
        for (String idToDelete : idsToDelete) {
            DeleteUpdateCommand docCmd = new DeleteUpdateCommand();
            docCmd.id = idToDelete;
            docCmd.fromPending = true;
            docCmd.fromCommitted = true;
            this.core.getUpdateHandler().delete(docCmd);
        }
    }

    public void addTransactionToReindex(Long transactionToReindex) {
        this.transactionsToReindex.offer(transactionToReindex);
    }

    public void addTransactionToIndex(Long transactionToIndex) {
        this.transactionsToIndex.offer(transactionToIndex);
    }

    public void addTransactionToPurge(Long transactionToPurge) {
        this.transactionsToPurge.offer(transactionToPurge);
    }

    public void addNodeToReindex(Long nodeToReindex) {
        this.nodesToReindex.offer(nodeToReindex);
    }

    public void addNodeToIndex(Long nodeToIndex) {
        this.nodesToIndex.offer(nodeToIndex);
    }

    public void addNodeToPurge(Long nodeToPurge) {
        this.nodesToPurge.offer(nodeToPurge);
    }

    public void addAclChangeSetToReindex(Long aclChangeSetToReindex) {
        this.aclChangeSetsToReindex.offer(aclChangeSetToReindex);
    }

    public void addAclChangeSetToIndex(Long aclChangeSetToIndex) {
        this.aclChangeSetsToIndex.offer(aclChangeSetToIndex);
    }

    public void addAclChangeSetToPurge(Long aclChangeSetToPurge) {
        this.aclChangeSetsToPurge.offer(aclChangeSetToPurge);
    }

    public void addAclToReindex(Long aclToReindex) {
        this.aclsToReindex.offer(aclToReindex);
    }

    public void addAclToIndex(Long aclToIndex) {
        this.aclsToIndex.offer(aclToIndex);
    }

    public void addAclToPurge(Long aclToPurge) {
        this.aclsToPurge.offer(aclToPurge);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reindexTransactions() throws IOException, AuthenticationException, JSONException {
        RefCounted refCounted = null;
        try {
            refCounted = this.core.getSearcher(false, true, null);
            SolrIndexSearcher solrIndexSearcher = (SolrIndexSearcher)refCounted.get();
            int docCount = 0;
            boolean requiresCommit = false;
            while (this.transactionsToReindex.peek() != null) {
                Long transactionId = this.transactionsToReindex.poll();
                if (transactionId != null) {
                    this.deleteByTransactionId(solrIndexSearcher, transactionId);
                    Transactions transactions = this.client.getTransactions(null, transactionId, null, transactionId + 1L, 1);
                    if (transactions.getTransactions().size() > 0 && transactionId.equals(transactions.getTransactions().get(0).getId())) {
                        Transaction info = transactions.getTransactions().get(0);
                        GetNodesParameters gnp = new GetNodesParameters();
                        ArrayList<Long> txs = new ArrayList<Long>();
                        txs.add(info.getId());
                        gnp.setTransactionIds(txs);
                        gnp.setStoreProtocol(this.storeRef.getProtocol());
                        gnp.setStoreIdentifier(this.storeRef.getIdentifier());
                        List<Node> nodes = this.client.getNodes(gnp, (int)info.getUpdates());
                        for (Node node : nodes) {
                            ++docCount;
                            if (log.isDebugEnabled()) {
                                log.debug(node.toString());
                            }
                            this.indexNode(node, solrIndexSearcher, true);
                        }
                        this.indexTransaction(info, true);
                        requiresCommit = true;
                    }
                }
                if ((long)docCount <= this.batchCount) continue;
                this.core.getUpdateHandler().commit(new CommitUpdateCommand(false));
                docCount = 0;
                requiresCommit = false;
            }
            if (requiresCommit || docCount > 0) {
                this.core.getUpdateHandler().commit(new CommitUpdateCommand(false));
            }
        }
        finally {
            if (refCounted != null) {
                refCounted.decref();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reindexNodes() throws IOException, AuthenticationException, JSONException {
        RefCounted refCounted = null;
        try {
            refCounted = this.core.getSearcher(false, true, null);
            SolrIndexSearcher solrIndexSearcher = (SolrIndexSearcher)refCounted.get();
            boolean requiresCommit = false;
            while (this.nodesToReindex.peek() != null) {
                Long nodeId = this.nodesToReindex.poll();
                if (nodeId == null) continue;
                this.deleteByNodeId(solrIndexSearcher, nodeId);
                Node node = new Node();
                node.setId(nodeId);
                node.setStatus(Node.SolrApiNodeStatus.UNKNOWN);
                this.indexNode(node, solrIndexSearcher, true);
                requiresCommit = true;
            }
            if (requiresCommit) {
                this.core.getUpdateHandler().commit(new CommitUpdateCommand(false));
            }
        }
        finally {
            if (refCounted != null) {
                refCounted.decref();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexNodes() throws IOException, AuthenticationException, JSONException {
        RefCounted refCounted = null;
        try {
            refCounted = this.core.getSearcher(false, true, null);
            SolrIndexSearcher solrIndexSearcher = (SolrIndexSearcher)refCounted.get();
            boolean requiresCommit = false;
            while (this.nodesToIndex.peek() != null) {
                Long nodeId = this.nodesToIndex.poll();
                if (nodeId == null) continue;
                Node node = new Node();
                node.setId(nodeId);
                node.setStatus(Node.SolrApiNodeStatus.UNKNOWN);
                this.indexNode(node, solrIndexSearcher, false);
                requiresCommit = true;
            }
            if (requiresCommit) {
                this.core.getUpdateHandler().commit(new CommitUpdateCommand(false));
            }
        }
        finally {
            if (refCounted != null) {
                refCounted.decref();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexTransactions() throws IOException, AuthenticationException, JSONException {
        RefCounted refCounted = null;
        try {
            refCounted = this.core.getSearcher(false, true, null);
            SolrIndexSearcher solrIndexSearcher = (SolrIndexSearcher)refCounted.get();
            int docCount = 0;
            boolean requiresCommit = false;
            while (this.transactionsToIndex.peek() != null) {
                Transactions transactions;
                Long transactionId = this.transactionsToIndex.poll();
                if (transactionId != null && (transactions = this.client.getTransactions(null, transactionId, null, transactionId + 1L, 1)).getTransactions().size() > 0 && transactionId.equals(transactions.getTransactions().get(0).getId())) {
                    Transaction info = transactions.getTransactions().get(0);
                    GetNodesParameters gnp = new GetNodesParameters();
                    ArrayList<Long> txs = new ArrayList<Long>();
                    txs.add(info.getId());
                    gnp.setTransactionIds(txs);
                    gnp.setStoreProtocol(this.storeRef.getProtocol());
                    gnp.setStoreIdentifier(this.storeRef.getIdentifier());
                    List<Node> nodes = this.client.getNodes(gnp, (int)info.getUpdates());
                    for (Node node : nodes) {
                        ++docCount;
                        if (log.isDebugEnabled()) {
                            log.debug(node.toString());
                        }
                        this.indexNode(node, solrIndexSearcher, false);
                    }
                    this.indexTransaction(info, false);
                    requiresCommit = true;
                }
                if ((long)docCount <= this.batchCount) continue;
                this.core.getUpdateHandler().commit(new CommitUpdateCommand(false));
                docCount = 0;
                requiresCommit = false;
            }
            if (requiresCommit || docCount > 0) {
                this.core.getUpdateHandler().commit(new CommitUpdateCommand(false));
            }
        }
        finally {
            if (refCounted != null) {
                refCounted.decref();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeTransactions() throws IOException, AuthenticationException, JSONException {
        RefCounted refCounted = null;
        try {
            refCounted = this.core.getSearcher(false, true, null);
            SolrIndexSearcher solrIndexSearcher = (SolrIndexSearcher)refCounted.get();
            boolean requiresCommit = false;
            while (this.transactionsToPurge.peek() != null) {
                Long transactionId = this.transactionsToPurge.poll();
                if (transactionId == null) continue;
                this.deleteByTransactionId(solrIndexSearcher, transactionId);
                requiresCommit = true;
            }
            if (requiresCommit) {
                this.core.getUpdateHandler().commit(new CommitUpdateCommand(false));
            }
        }
        finally {
            if (refCounted != null) {
                refCounted.decref();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeNodes() throws IOException, AuthenticationException, JSONException {
        RefCounted refCounted = null;
        try {
            refCounted = this.core.getSearcher(false, true, null);
            SolrIndexSearcher solrIndexSearcher = (SolrIndexSearcher)refCounted.get();
            boolean requiresCommit = false;
            while (this.nodesToPurge.peek() != null) {
                Long nodeId = this.nodesToPurge.poll();
                if (nodeId == null) continue;
                this.deleteByNodeId(solrIndexSearcher, nodeId);
                requiresCommit = true;
            }
            if (requiresCommit) {
                this.core.getUpdateHandler().commit(new CommitUpdateCommand(false));
            }
        }
        finally {
            if (refCounted != null) {
                refCounted.decref();
            }
        }
    }

    private void deleteByTransactionId(SolrIndexSearcher solrIndexSearcher, Long transactionId) throws IOException {
        TermQuery query = new TermQuery(new Term("INTXID", NumericEncoder.encode((long)transactionId)));
        this.deleteByQuery(solrIndexSearcher, (Query)query);
    }

    private void deleteByNodeId(SolrIndexSearcher solrIndexSearcher, Long nodeId) throws IOException {
        TermQuery query = new TermQuery(new Term("DBID", NumericEncoder.encode((long)nodeId)));
        this.deleteByQuery(solrIndexSearcher, (Query)query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trackRepository() throws IOException, AuthenticationException, JSONException {
        boolean indexing = false;
        boolean aclIndexing = false;
        this.trackModels();
        RefCounted refCounted = null;
        try {
            Transactions transactions;
            List<AclChangeSet> aclChangeSets;
            Transactions firstTransactions;
            Transaction firstTransaction;
            long currentBestFromIndex;
            long timeBeforeWhichThereCanBeNoChangeSetHolesInIndex;
            long lastGoodChangeSetCommitTimeInIndex;
            refCounted = this.core.getSearcher(false, true, null);
            SolrIndexSearcher solrIndexSearcher = (SolrIndexSearcher)refCounted.get();
            SolrIndexReader reader = solrIndexSearcher.getReader();
            if (this.lastIndexedTxCommitTime == 0L) {
                this.lastIndexedTxCommitTime = this.getLastTransactionCommitTime(reader);
            }
            if (this.lastIndexedChangeSetCommitTime == 0L) {
                this.lastIndexedChangeSetCommitTime = this.getLastTransactionCommitTime(reader);
            }
            long startTime = System.currentTimeMillis();
            long timeToStopIndexing = startTime - this.lag;
            long timeBeforeWhichThereCanBeNoHoles = startTime - this.holeRetention;
            long timeBeforeWhichThereCanBeNoTxHolesInIndex = this.lastIndexedTxCommitTime - this.holeRetention;
            long lastGoodTxCommitTimeInIndex = this.getLastTxCommitTimeBeforeHoles(reader, timeBeforeWhichThereCanBeNoTxHolesInIndex);
            if (lastGoodTxCommitTimeInIndex == 0L) {
                lastGoodTxCommitTimeInIndex = timeBeforeWhichThereCanBeNoHoles;
            }
            if ((lastGoodChangeSetCommitTimeInIndex = this.getLastChangeSetCommitTimeBeforeHoles(reader, timeBeforeWhichThereCanBeNoChangeSetHolesInIndex = this.lastIndexedChangeSetCommitTime - this.holeRetention)) == 0L) {
                lastGoodChangeSetCommitTimeInIndex = timeBeforeWhichThereCanBeNoHoles;
            }
            if (this.lastIndexedTxIdBeforeHoles == -1L) {
                this.lastIndexedTxIdBeforeHoles = this.getLargestTxIdByCommitTime(reader, lastGoodTxCommitTimeInIndex);
            } else {
                currentBestFromIndex = this.getLargestTxIdByCommitTime(reader, lastGoodTxCommitTimeInIndex);
                if (currentBestFromIndex > this.lastIndexedTxIdBeforeHoles) {
                    this.lastIndexedTxIdBeforeHoles = currentBestFromIndex;
                }
            }
            if (this.lastIndexedChangeSetIdBeforeHoles == -1L) {
                this.lastIndexedChangeSetIdBeforeHoles = this.getLargestChangeSetIdByCommitTime(reader, lastGoodChangeSetCommitTimeInIndex);
            } else {
                currentBestFromIndex = this.getLargestChangeSetIdByCommitTime(reader, lastGoodChangeSetCommitTimeInIndex);
                if (currentBestFromIndex > this.lastIndexedTxIdBeforeHoles) {
                    this.lastIndexedChangeSetIdBeforeHoles = currentBestFromIndex;
                }
            }
            if (reader.numDocs() == 0) {
                this.checkedFirstTransactionTime = true;
                log.info("Empty index - no verification required");
                Transactions firstTransactions2 = this.client.getTransactions(null, 0L, null, 2000L, 1);
                if (firstTransactions2.getTransactions().size() > 0) {
                    long firstTransactionCommitTime;
                    firstTransaction = firstTransactions2.getTransactions().get(0);
                    lastGoodChangeSetCommitTimeInIndex = firstTransactionCommitTime = firstTransaction.getCommitTimeMs();
                    lastGoodTxCommitTimeInIndex = firstTransactionCommitTime;
                }
            }
            if (!this.checkedFirstTransactionTime && (firstTransactions = this.client.getTransactions(null, 0L, null, 2000L, 1)).getTransactions().size() > 0) {
                firstTransaction = firstTransactions.getTransactions().get(0);
                long firstTxId = firstTransaction.getId();
                String targetTxId = NumericEncoder.encode((long)firstTxId);
                long firstTransactionCommitTime = firstTransaction.getCommitTimeMs();
                String targetTxCommitTime = NumericEncoder.encode((long)firstTransactionCommitTime);
                BooleanQuery query = new BooleanQuery();
                query.add((Query)new TermQuery(new Term("TXID", targetTxId)), BooleanClause.Occur.MUST);
                query.add((Query)new TermQuery(new Term("TXCOMMITTIME", targetTxCommitTime)), BooleanClause.Occur.MUST);
                DocSet set = solrIndexSearcher.getDocSet((Query)query);
                if (set.size() == 0) {
                    log.error("First transaction was not found with the correct timestamp.");
                    log.error("SOLR has successfully connected to your repository  however the SOLR indexes and repository database do not match.");
                    log.error("If this is a new or rebuilt database you SOLR indexes also need to be re-built to match the database.");
                    log.error("You can also check your SOLR connection details in solrcore.properties.");
                    throw new AlfrescoRuntimeException("Initial transaction not found with correct timestamp");
                }
                if (set.size() == 1) {
                    this.checkedFirstTransactionTime = true;
                    log.info("Verified first transaction and timetsamp in index");
                } else {
                    log.warn("Duplicate initial transaction found with correct timestamp");
                }
            }
            boolean aclsUpToDate = false;
            BoundedDeque<AclChangeSet> changeSetsFound = new BoundedDeque<AclChangeSet>(100);
            do {
                Long fromCommitTime = this.getChangeSetFromCommitTime(changeSetsFound, lastGoodChangeSetCommitTimeInIndex);
                aclChangeSets = this.getSomeAclChangeSets(changeSetsFound, fromCommitTime, 3600000, 2000, timeToStopIndexing);
                log.info("Scanning Acl change sets ...");
                if (aclChangeSets.size() > 0) {
                    log.info(".... from " + aclChangeSets.get(0));
                    log.info(".... to " + aclChangeSets.get(aclChangeSets.size() - 1));
                } else {
                    log.info(".... non found after lastTxCommitTime " + fromCommitTime);
                }
                for (AclChangeSet changeSet : aclChangeSets) {
                    if (!aclIndexing) {
                        String target = NumericEncoder.encode((long)changeSet.getId());
                        TermEnum termEnum = reader.terms(new Term("ACLTXID", target));
                        Term term = termEnum.term();
                        termEnum.close();
                        if (term == null) {
                            aclIndexing = true;
                        } else if (target.equals(term.text())) {
                            changeSetsFound.add(changeSet);
                        } else {
                            aclIndexing = true;
                        }
                    }
                    if (!aclIndexing) continue;
                    if (changeSet.getCommitTimeMs() > timeToStopIndexing) {
                        aclsUpToDate = true;
                        continue;
                    }
                    List<Acl> acls = this.client.getAcls(Collections.singletonList(changeSet), null, Integer.MAX_VALUE);
                    for (Acl acl : acls) {
                        List<AclReaders> readers = this.client.getAclReaders(Collections.singletonList(acl));
                        this.indexAcl(readers, true);
                    }
                    this.indexAclTransaction(changeSet, true);
                    changeSetsFound.add(changeSet);
                }
            } while (aclChangeSets.size() > 0 && !aclsUpToDate);
            if (aclIndexing) {
                this.core.getUpdateHandler().commit(new CommitUpdateCommand(false));
            }
            boolean upToDate = false;
            ArrayList<Transaction> transactionsOrderedById = new ArrayList<Transaction>(10000);
            BoundedDeque<Transaction> txnsFound = new BoundedDeque<Transaction>(100);
            do {
                int docCount = 0;
                Long fromCommitTime = this.getTxFromCommitTime(txnsFound, lastGoodTxCommitTimeInIndex);
                transactions = this.getSomeTransactions(txnsFound, fromCommitTime, 3600000, 2000, timeToStopIndexing);
                Long maxTxnCommitTime = transactions.getMaxTxnCommitTime();
                if (maxTxnCommitTime != null) {
                    this.lastTxOnServer = transactions.getMaxTxnCommitTime();
                }
                log.info("Scanning transactions ...");
                if (transactions.getTransactions().size() > 0) {
                    log.info(".... from " + transactions.getTransactions().get(0));
                    log.info(".... to " + transactions.getTransactions().get(transactions.getTransactions().size() - 1));
                } else {
                    log.info(".... non found after lastTxCommitTime " + (txnsFound.size() > 0 ? txnsFound.getLast().getCommitTimeMs() : this.lastIndexedTxCommitTime));
                }
                for (Transaction info : transactions.getTransactions()) {
                    if (!indexing) {
                        String target = NumericEncoder.encode((long)info.getId());
                        TermEnum termEnum = reader.terms(new Term("TXID", target));
                        Term term = termEnum.term();
                        termEnum.close();
                        if (term == null) {
                            indexing = true;
                        } else if (target.equals(term.text())) {
                            txnsFound.add(info);
                        } else {
                            indexing = true;
                        }
                    }
                    if (indexing) {
                        if (info.getCommitTimeMs() > timeToStopIndexing) {
                            upToDate = true;
                        } else {
                            GetNodesParameters gnp = new GetNodesParameters();
                            ArrayList<Long> txs = new ArrayList<Long>();
                            txs.add(info.getId());
                            gnp.setTransactionIds(txs);
                            gnp.setStoreProtocol(this.storeRef.getProtocol());
                            gnp.setStoreIdentifier(this.storeRef.getIdentifier());
                            List<Node> nodes = this.client.getNodes(gnp, Integer.MAX_VALUE);
                            for (Node node : nodes) {
                                ++docCount;
                                if (log.isDebugEnabled()) {
                                    log.debug(node.toString());
                                }
                                this.indexNode(node, solrIndexSearcher, true);
                            }
                            this.indexTransaction(info, true);
                            if (info.getCommitTimeMs() > this.lastIndexedTxCommitTime) {
                                this.lastIndexedTxCommitTime = info.getCommitTimeMs();
                            }
                            txnsFound.add(info);
                        }
                    }
                    if ((long)docCount <= this.batchCount) continue;
                    this.core.getUpdateHandler().commit(new CommitUpdateCommand(false));
                    docCount = 0;
                }
                if (transactionsOrderedById.size() >= 10000) continue;
                transactionsOrderedById.addAll(transactions.getTransactions());
                Collections.sort(transactionsOrderedById, new Comparator<Transaction>(){

                    @Override
                    public int compare(Transaction o1, Transaction o2) {
                        return (int)(o1.getId() - o2.getId());
                    }
                });
                ArrayList<Transaction> newTransactionsOrderedById = new ArrayList<Transaction>(10000);
                for (Transaction info : transactions.getTransactions()) {
                    if (info.getCommitTimeMs() < timeBeforeWhichThereCanBeNoHoles) {
                        this.lastIndexedTxIdBeforeHoles = info.getId();
                        continue;
                    }
                    if (info.getId() == this.lastIndexedTxIdBeforeHoles + 1L) {
                        this.lastIndexedTxIdBeforeHoles = info.getId();
                        continue;
                    }
                    newTransactionsOrderedById.add(info);
                }
                transactionsOrderedById = newTransactionsOrderedById;
            } while (transactions.getTransactions().size() > 0 && !upToDate);
        }
        catch (Throwable t) {
            this.core.getUpdateHandler().rollback(new RollbackUpdateCommand());
            log.error("Tracking failed", t);
        }
        finally {
            if (refCounted != null) {
                refCounted.decref();
            }
        }
        if (indexing) {
            this.core.getUpdateHandler().commit(new CommitUpdateCommand(false));
        }
        if (this.check) {
            this.checkIndex(null, null, null, null, null, null);
        }
    }

    private Long getTxFromCommitTime(BoundedDeque<Transaction> txnsFound, long lastGoodTxCommitTimeInIndex) {
        if (txnsFound.size() > 0) {
            return txnsFound.getLast().getCommitTimeMs();
        }
        return lastGoodTxCommitTimeInIndex;
    }

    private Long getChangeSetFromCommitTime(BoundedDeque<AclChangeSet> changeSetsFound, long lastGoodChangeSetCommitTimeInIndex) {
        if (changeSetsFound.size() > 0) {
            return changeSetsFound.getLast().getCommitTimeMs();
        }
        return lastGoodChangeSetCommitTimeInIndex;
    }

    private List<AclChangeSet> getSomeAclChangeSets(BoundedDeque<AclChangeSet> changeSetsFound, Long fromCommitTime, int timeStep, int maxResults, long endTime) throws AuthenticationException, IOException, JSONException {
        List<AclChangeSet> aclChangeSets;
        Long startTime = fromCommitTime == null ? Long.valueOf(0L) : fromCommitTime;
        do {
            aclChangeSets = this.client.getAclChangeSets(startTime, null, startTime + (long)timeStep, null, maxResults);
            startTime = startTime + (long)timeStep;
        } while (aclChangeSets.size() == 0 && startTime < endTime || aclChangeSets.size() > 0 && this.alreadyFoundChangeSets(changeSetsFound, aclChangeSets));
        return aclChangeSets;
    }

    private boolean alreadyFoundChangeSets(BoundedDeque<AclChangeSet> changeSetsFound, List<AclChangeSet> aclChangeSets) {
        if (changeSetsFound.size() == 0) {
            return false;
        }
        if (aclChangeSets.size() == 1) {
            return aclChangeSets.get(0).getId() == changeSetsFound.getLast().getId();
        }
        HashSet alreadyFound = new HashSet(((BoundedDeque)changeSetsFound).deque);
        for (AclChangeSet aclChangeSet : aclChangeSets) {
            if (alreadyFound.contains(aclChangeSet)) continue;
            return false;
        }
        return true;
    }

    private Transactions getSomeTransactions(BoundedDeque<Transaction> txnsFound, Long fromCommitTime, int timeStep, int maxResults, long endTime) throws AuthenticationException, IOException, JSONException {
        Transactions transactions;
        Long startTime = fromCommitTime == null ? Long.valueOf(0L) : fromCommitTime;
        do {
            transactions = this.client.getTransactions(startTime, null, startTime + (long)timeStep, null, maxResults);
            startTime = startTime + (long)timeStep;
        } while (transactions.getTransactions().size() == 0 && startTime < endTime || transactions.getTransactions().size() > 0 && this.alreadyFoundTransactions(txnsFound, transactions));
        return transactions;
    }

    private boolean alreadyFoundTransactions(BoundedDeque<Transaction> txnsFound, Transactions transactions) {
        if (txnsFound.size() == 0) {
            return false;
        }
        if (transactions.getTransactions().size() == 1) {
            return transactions.getTransactions().get(0).getId() == txnsFound.getLast().getId();
        }
        HashSet alreadyFound = new HashSet(((BoundedDeque)txnsFound).deque);
        for (Transaction txn : transactions.getTransactions()) {
            if (alreadyFound.contains(txn)) continue;
            return false;
        }
        return true;
    }

    private void trackModels() throws AuthenticationException, IOException, JSONException {
        File alfrescoModelDir;
        List<AlfrescoModelDiff> modelDiffs = this.client.getModelsDiff(this.dataModel.getAlfrescoModels());
        HashMap<String, M2Model> modelMap = new HashMap<String, M2Model>();
        block9: for (AlfrescoModelDiff modelDiff : modelDiffs) {
            switch (modelDiff.getType()) {
                case CHANGED: {
                    AlfrescoModel changedModel = this.client.getModel(modelDiff.getModelName());
                    for (M2Namespace namespace : changedModel.getModel().getNamespaces()) {
                        modelMap.put(namespace.getUri(), changedModel.getModel());
                    }
                    continue block9;
                }
                case NEW: {
                    AlfrescoModel newModel = this.client.getModel(modelDiff.getModelName());
                    for (M2Namespace namespace : newModel.getModel().getNamespaces()) {
                        modelMap.put(namespace.getUri(), newModel.getModel());
                    }
                    continue block9;
                }
            }
        }
        HashSet<String> loadedModels = new HashSet<String>();
        for (M2Model model : modelMap.values()) {
            this.loadModel(modelMap, loadedModels, model, this.dataModel);
        }
        if (modelDiffs.size() > 0) {
            this.dataModel.afterInitModels();
        }
        if (!(alfrescoModelDir = new File(this.id, "alfrescoModels")).exists()) {
            alfrescoModelDir.mkdir();
        }
        for (AlfrescoModelDiff modelDiff : modelDiffs) {
            switch (modelDiff.getType()) {
                case CHANGED: {
                    this.removeMatchingModels(alfrescoModelDir, modelDiff.getModelName());
                    M2Model changedModel = this.dataModel.getM2Model(modelDiff.getModelName());
                    File changedFile = new File(alfrescoModelDir, this.getModelFileName(changedModel));
                    FileOutputStream cos = new FileOutputStream(changedFile);
                    changedModel.toXML((OutputStream)cos);
                    cos.flush();
                    cos.close();
                    break;
                }
                case NEW: {
                    M2Model newModel = this.dataModel.getM2Model(modelDiff.getModelName());
                    File newFile = new File(alfrescoModelDir, this.getModelFileName(newModel));
                    FileOutputStream nos = new FileOutputStream(newFile);
                    newModel.toXML((OutputStream)nos);
                    nos.flush();
                    nos.close();
                    break;
                }
                case REMOVED: {
                    this.removeMatchingModels(alfrescoModelDir, modelDiff.getModelName());
                }
            }
        }
    }

    private void removeMatchingModels(File alfrescoModelDir, QName modelName) {
        final String prefix = modelName.toPrefixString((NamespacePrefixResolver)this.dataModel.getNamespaceDAO()).replace(":", ".") + ".";
        String postFix = ".xml";
        File[] toDelete = alfrescoModelDir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                if (pathname.isDirectory()) {
                    return false;
                }
                String name = pathname.getName();
                if (!name.endsWith(".xml")) {
                    return false;
                }
                if (!name.startsWith(prefix)) {
                    return false;
                }
                String checksum = name.substring(prefix.length(), name.length() - ".xml".length());
                try {
                    Long.parseLong(checksum);
                    return true;
                }
                catch (NumberFormatException nfe) {
                    return false;
                }
            }
        });
        if (toDelete != null) {
            for (File file : toDelete) {
                file.delete();
            }
        }
    }

    private void indexAcl(List<AclReaders> aclReaderList, boolean overwrite) throws IOException {
        for (AclReaders aclReaders : aclReaderList) {
            AddUpdateCommand cmd = new AddUpdateCommand();
            cmd.overwriteCommitted = overwrite;
            cmd.overwritePending = overwrite;
            SolrInputDocument input = new SolrInputDocument();
            input.addField("ID", (Object)("ACL-" + aclReaders.getId()));
            input.addField("ACLID", (Object)aclReaders.getId());
            input.addField("INACLTXID", (Object)aclReaders.getAclChangeSetId());
            String tenant = aclReaders.getTenantDomain();
            block5: for (String reader : aclReaders.getReaders()) {
                switch (AuthorityType.getAuthorityType((String)reader)) {
                    case USER: {
                        input.addField("READER", (Object)reader);
                        continue block5;
                    }
                    case GROUP: 
                    case EVERYONE: 
                    case GUEST: {
                        if (tenant.length() == 0) {
                            input.addField("READER", (Object)reader);
                            continue block5;
                        }
                        input.addField("READER", (Object)(reader + "@" + tenant));
                        continue block5;
                    }
                }
                input.addField("READER", (Object)reader);
            }
            cmd.solrDoc = input;
            cmd.doc = CoreTracker.toDocument(cmd.getSolrInputDocument(), this.core.getSchema(), this.dataModel);
            this.core.getUpdateHandler().addDoc(cmd);
        }
    }

    private void indexTransaction(Transaction info, boolean overwrite) throws IOException {
        AddUpdateCommand cmd = new AddUpdateCommand();
        cmd.overwriteCommitted = overwrite;
        cmd.overwritePending = overwrite;
        SolrInputDocument input = new SolrInputDocument();
        input.addField("ID", (Object)("TX-" + info.getId()));
        input.addField("TXID", (Object)info.getId());
        input.addField("INTXID", (Object)info.getId());
        input.addField("TXCOMMITTIME", (Object)info.getCommitTimeMs());
        cmd.solrDoc = input;
        cmd.doc = CoreTracker.toDocument(cmd.getSolrInputDocument(), this.core.getSchema(), this.dataModel);
        this.core.getUpdateHandler().addDoc(cmd);
    }

    private void indexAclTransaction(AclChangeSet changeSet, boolean overwrite) throws IOException {
        AddUpdateCommand cmd = new AddUpdateCommand();
        cmd.overwriteCommitted = overwrite;
        cmd.overwritePending = overwrite;
        SolrInputDocument input = new SolrInputDocument();
        input.addField("ID", (Object)("ACLTX-" + changeSet.getId()));
        input.addField("ACLTXID", (Object)changeSet.getId());
        input.addField("INACLTXID", (Object)changeSet.getId());
        input.addField("ACLTXCOMMITTIME", (Object)changeSet.getCommitTimeMs());
        cmd.solrDoc = input;
        cmd.doc = CoreTracker.toDocument(cmd.getSolrInputDocument(), this.core.getSchema(), this.dataModel);
        this.core.getUpdateHandler().addDoc(cmd);
    }

    private void indexNode(Node node, SolrIndexSearcher solrIndexSearcher, boolean overwrite) throws IOException, AuthenticationException, JSONException {
        if (node.getStatus() == Node.SolrApiNodeStatus.DELETED || node.getStatus() == Node.SolrApiNodeStatus.UNKNOWN) {
            log.debug(".. deleting");
            DeleteUpdateCommand docCmd = new DeleteUpdateCommand();
            docCmd.id = "LEAF-" + node.getId();
            docCmd.fromPending = true;
            docCmd.fromCommitted = true;
            this.core.getUpdateHandler().delete(docCmd);
            docCmd = new DeleteUpdateCommand();
            docCmd.id = "AUX-" + node.getId();
            docCmd.fromPending = true;
            docCmd.fromCommitted = true;
            this.core.getUpdateHandler().delete(docCmd);
        }
        if (node.getStatus() == Node.SolrApiNodeStatus.UPDATED || node.getStatus() == Node.SolrApiNodeStatus.UNKNOWN) {
            log.info(".. updating");
            NodeMetaDataParameters nmdp = new NodeMetaDataParameters();
            nmdp.setFromNodeId(node.getId());
            nmdp.setToNodeId(node.getId());
            List<NodeMetaData> nodeMetaDatas = this.client.getNodesMetaData(nmdp, 1);
            AddUpdateCommand leafDocCmd = new AddUpdateCommand();
            leafDocCmd.overwriteCommitted = overwrite;
            leafDocCmd.overwritePending = overwrite;
            AddUpdateCommand auxDocCmd = new AddUpdateCommand();
            auxDocCmd.overwriteCommitted = overwrite;
            auxDocCmd.overwritePending = overwrite;
            ArrayList<Reader> toClose = new ArrayList<Reader>();
            ArrayList<File> toDelete = new ArrayList<File>();
            for (NodeMetaData nodeMetaData : nodeMetaDatas) {
                SolrInputDocument aux;
                Boolean isIndexed;
                StringPropertyValue pValue;
                Boolean isIndexed2;
                StringPropertyValue pValue2;
                Map<QName, PropertyValue> properties;
                if (nodeMetaData.getTxnId() > node.getTxnId()) continue;
                if (this.mayHaveChildren(nodeMetaData)) {
                    log.info(".. checking for path change");
                    BooleanQuery bQuery = new BooleanQuery();
                    bQuery.add((Query)new TermQuery(new Term("DBID", NumericEncoder.encode((long)nodeMetaData.getId()))), BooleanClause.Occur.MUST);
                    bQuery.add((Query)new TermQuery(new Term("PARENTASSOCCRC", NumericEncoder.encode((long)nodeMetaData.getParentAssocsCrc()))), BooleanClause.Occur.MUST);
                    DocSet docSet = solrIndexSearcher.getDocSet((Query)bQuery);
                    if (docSet.size() > 0) {
                        log.debug("... found aux match");
                    } else {
                        docSet = solrIndexSearcher.getDocSet((Query)new TermQuery(new Term("DBID", NumericEncoder.encode((long)nodeMetaData.getId()))));
                        if (docSet.size() > 0) {
                            log.debug("... cascade updating aux doc");
                            this.updateDescendantAuxDocs(nodeMetaData, overwrite);
                        } else {
                            log.debug("... no aux doc");
                        }
                    }
                }
                if ((properties = nodeMetaData.getProperties()).containsKey(ContentModel.PROP_IS_INDEXED) && (pValue2 = (StringPropertyValue)properties.get(ContentModel.PROP_IS_INDEXED)) != null && (isIndexed2 = Boolean.valueOf(pValue2.getValue())) != null && !isIndexed2.booleanValue()) {
                    DeleteUpdateCommand docCmd = new DeleteUpdateCommand();
                    docCmd.id = "LEAF-" + node.getId();
                    docCmd.fromPending = true;
                    docCmd.fromCommitted = true;
                    this.core.getUpdateHandler().delete(docCmd);
                    docCmd = new DeleteUpdateCommand();
                    docCmd.id = "AUX-" + node.getId();
                    docCmd.fromPending = true;
                    docCmd.fromCommitted = true;
                    this.core.getUpdateHandler().delete(docCmd);
                    return;
                }
                boolean isContentIndexedForNode = true;
                if (properties.containsKey(ContentModel.PROP_IS_CONTENT_INDEXED) && (pValue = (StringPropertyValue)properties.get(ContentModel.PROP_IS_CONTENT_INDEXED)) != null && (isIndexed = Boolean.valueOf(pValue.getValue())) != null && !isIndexed.booleanValue()) {
                    isContentIndexedForNode = false;
                }
                SolrInputDocument doc = new SolrInputDocument();
                doc.addField("ID", (Object)("LEAF-" + nodeMetaData.getId()));
                doc.addField("DBID", (Object)nodeMetaData.getId());
                doc.addField("LID", (Object)nodeMetaData.getNodeRef());
                doc.addField("INTXID", (Object)nodeMetaData.getTxnId());
                for (QName propertyQname : properties.keySet()) {
                    PropertyValue value;
                    if (!this.dataModel.isIndexedOrStored(propertyQname) || (value = properties.get(propertyQname)) == null) continue;
                    if (value instanceof ContentPropertyValue) {
                        if (!isContentIndexedForNode) continue;
                        this.addContentPropertyToDoc(doc, toClose, toDelete, nodeMetaData, propertyQname, (ContentPropertyValue)value);
                        continue;
                    }
                    if (value instanceof MLTextPropertyValue) {
                        this.addMLTextPropertyToDoc(doc, propertyQname, (MLTextPropertyValue)value);
                        continue;
                    }
                    if (value instanceof MultiPropertyValue) {
                        MultiPropertyValue typedValue = (MultiPropertyValue)value;
                        for (PropertyValue singleValue : typedValue.getValues()) {
                            if (singleValue instanceof ContentPropertyValue) {
                                if (!isContentIndexedForNode) continue;
                                this.addContentPropertyToDoc(doc, toClose, toDelete, nodeMetaData, propertyQname, (ContentPropertyValue)singleValue);
                                continue;
                            }
                            if (singleValue instanceof MLTextPropertyValue) {
                                this.addMLTextPropertyToDoc(doc, propertyQname, (MLTextPropertyValue)singleValue);
                                continue;
                            }
                            if (!(singleValue instanceof StringPropertyValue)) continue;
                            this.addStringPropertyToDoc(doc, propertyQname, (StringPropertyValue)singleValue, properties);
                        }
                        continue;
                    }
                    if (!(value instanceof StringPropertyValue)) continue;
                    this.addStringPropertyToDoc(doc, propertyQname, (StringPropertyValue)value, properties);
                }
                doc.addField("TYPE", (Object)nodeMetaData.getType().toString());
                for (QName aspect : nodeMetaData.getAspects()) {
                    doc.addField("ASPECT", (Object)aspect.toString());
                }
                doc.addField("ISNODE", (Object)"T");
                doc.addField("FTSSTATUS", (Object)"Clean");
                String tenant = nodeMetaData.getTenantDomain();
                if (tenant.length() > 0) {
                    doc.addField("TENANT", (Object)nodeMetaData.getTenantDomain());
                } else {
                    doc.addField("TENANT", (Object)"_DEFAULT_");
                }
                leafDocCmd.solrDoc = doc;
                leafDocCmd.doc = CoreTracker.toDocument(leafDocCmd.getSolrInputDocument(), this.core.getSchema(), this.dataModel);
                auxDocCmd.solrDoc = aux = this.createAuxDoc(nodeMetaData);
                auxDocCmd.doc = CoreTracker.toDocument(auxDocCmd.getSolrInputDocument(), this.core.getSchema(), this.dataModel);
            }
            this.core.getUpdateHandler().addDoc(leafDocCmd);
            this.core.getUpdateHandler().addDoc(auxDocCmd);
            for (Reader forClose : toClose) {
                try {
                    forClose.close();
                }
                catch (IOException ioe) {}
            }
            for (File file : toDelete) {
                file.delete();
            }
        }
    }

    private void updateDescendantAuxDocs(NodeMetaData parentNodeMetaData, boolean overwrite) throws AuthenticationException, IOException, JSONException {
        if (parentNodeMetaData.getChildIds() != null) {
            for (Long childId : parentNodeMetaData.getChildIds()) {
                NodeMetaDataParameters nmdp = new NodeMetaDataParameters();
                nmdp.setFromNodeId(childId);
                nmdp.setToNodeId(childId);
                nmdp.setIncludeAclId(true);
                nmdp.setIncludeAspects(true);
                nmdp.setIncludeChildAssociations(false);
                nmdp.setIncludeChildIds(true);
                nmdp.setIncludeNodeRef(false);
                nmdp.setIncludeOwner(true);
                nmdp.setIncludeParentAssociations(true);
                nmdp.setIncludePaths(true);
                nmdp.setIncludeProperties(false);
                nmdp.setIncludeType(true);
                nmdp.setIncludeTxnId(true);
                List<NodeMetaData> nodeMetaDatas = this.client.getNodesMetaData(nmdp, 1);
                for (NodeMetaData nodeMetaData : nodeMetaDatas) {
                    if (this.mayHaveChildren(nodeMetaData)) {
                        this.updateDescendantAuxDocs(nodeMetaData, overwrite);
                    }
                    SolrInputDocument aux = this.createAuxDoc(nodeMetaData);
                    AddUpdateCommand auxDocCmd = new AddUpdateCommand();
                    auxDocCmd.overwriteCommitted = overwrite;
                    auxDocCmd.overwritePending = overwrite;
                    auxDocCmd.solrDoc = aux;
                    auxDocCmd.doc = CoreTracker.toDocument(auxDocCmd.getSolrInputDocument(), this.core.getSchema(), this.dataModel);
                    this.core.getUpdateHandler().addDoc(auxDocCmd);
                }
            }
        }
    }

    private SolrInputDocument createAuxDoc(NodeMetaData nodeMetaData) {
        SolrInputDocument aux = new SolrInputDocument();
        aux.addField("ID", (Object)("AUX-" + nodeMetaData.getId()));
        aux.addField("DBID", (Object)nodeMetaData.getId());
        aux.addField("ACLID", (Object)nodeMetaData.getAclId());
        aux.addField("INTXID", (Object)nodeMetaData.getTxnId());
        for (Pair<String, QName> path : nodeMetaData.getPaths()) {
            aux.addField("PATH", path.getFirst());
        }
        if (nodeMetaData.getOwner() != null) {
            aux.addField("OWNER", (Object)nodeMetaData.getOwner());
        }
        aux.addField("PARENTASSOCCRC", (Object)nodeMetaData.getParentAssocsCrc());
        StringBuilder qNameBuffer = new StringBuilder(64);
        StringBuilder assocTypeQNameBuffer = new StringBuilder(64);
        if (nodeMetaData.getParentAssocs() != null) {
            for (ChildAssociationRef childAssocRef : nodeMetaData.getParentAssocs()) {
                if (qNameBuffer.length() > 0) {
                    qNameBuffer.append(";/");
                    assocTypeQNameBuffer.append(";/");
                }
                qNameBuffer.append(ISO9075.getXPathName((QName)childAssocRef.getQName()));
                assocTypeQNameBuffer.append(ISO9075.getXPathName((QName)childAssocRef.getTypeQName()));
                aux.addField("PARENT", (Object)childAssocRef.getParentRef());
                if (!childAssocRef.isPrimary()) continue;
                aux.addField("PRIMARYPARENT", (Object)childAssocRef.getParentRef());
                aux.addField("PRIMARYASSOCTYPEQNAME", (Object)ISO9075.getXPathName((QName)childAssocRef.getTypeQName()));
                aux.addField("PRIMARYASSOCQNAME", (Object)ISO9075.getXPathName((QName)childAssocRef.getQName()));
            }
            aux.addField("ASSOCTYPEQNAME", (Object)assocTypeQNameBuffer.toString());
            aux.addField("QNAME", (Object)qNameBuffer.toString());
        }
        if (nodeMetaData.getAncestors() != null) {
            for (NodeRef ancestor : nodeMetaData.getAncestors()) {
                aux.addField("ANCESTOR", (Object)ancestor.toString());
            }
        }
        return aux;
    }

    private boolean mayHaveChildren(NodeMetaData nodeMetaData) {
        TypeDefinition nodeTypeDef = this.dataModel.getDictionaryService().getType(nodeMetaData.getType());
        if (nodeTypeDef != null && nodeTypeDef.getChildAssociations().size() > 0) {
            return true;
        }
        for (QName aspect : nodeMetaData.getAspects()) {
            AspectDefinition aspectDef = this.dataModel.getDictionaryService().getAspect(aspect);
            if (aspectDef == null || aspectDef.getChildAssociations().size() <= 0) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addContentPropertyToDoc(SolrInputDocument doc, ArrayList<Reader> toClose, ArrayList<File> toDelete, NodeMetaData nodeMetaData, QName propertyQName, ContentPropertyValue contentPropertyValue) throws AuthenticationException, IOException {
        doc.addField("@" + propertyQName.toString() + ".size", (Object)contentPropertyValue.getLength());
        doc.addField("@" + propertyQName.toString() + ".locale", (Object)contentPropertyValue.getLocale());
        doc.addField("@" + propertyQName.toString() + ".mimetype", (Object)contentPropertyValue.getMimetype());
        doc.addField("@" + propertyQName.toString() + ".encoding", (Object)contentPropertyValue.getEncoding());
        SOLRAPIClient.GetTextContentResponse response = this.client.getTextContent(nodeMetaData.getId(), propertyQName, null);
        doc.addField("@" + propertyQName.toString() + ".transformationStatus", (Object)response.getStatus());
        doc.addField("@" + propertyQName.toString() + ".transformationTime", (Object)response.getTransformDuration());
        doc.addField("@" + propertyQName.toString() + ".transformationException", (Object)response.getTransformException());
        InputStreamReader isr = null;
        InputStream ris = response.getContent();
        File temp = null;
        try {
            if (ris != null) {
                temp = TempFileProvider.createTempFile((String)"solr", (String)"content");
                toDelete.add(temp);
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(temp));
                FileCopyUtils.copy((InputStream)ris, (OutputStream)os);
            }
        }
        finally {
            response.release();
        }
        if (ris != null) {
            ris = new BufferedInputStream(new FileInputStream(temp));
            try {
                isr = new InputStreamReader(ris, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                isr = new InputStreamReader(ris);
            }
            toClose.add(isr);
            StringBuilder builder = new StringBuilder();
            builder.append("\u0000").append(contentPropertyValue.getLocale().toString()).append("\u0000");
            StringReader prefix = new StringReader(builder.toString());
            MultiReader multiReader = new MultiReader((Reader)prefix, (Reader)isr);
            doc.addField("@" + propertyQName.toString(), (Object)multiReader);
            ris = new BufferedInputStream(new FileInputStream(temp));
            try {
                isr = new InputStreamReader(ris, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                isr = new InputStreamReader(ris);
            }
            toClose.add(isr);
            builder = new StringBuilder();
            builder.append("\u0000").append(contentPropertyValue.getLocale().toString()).append("\u0000");
            prefix = new StringReader(builder.toString());
            multiReader = new MultiReader((Reader)prefix, (Reader)isr);
            doc.addField("@" + propertyQName.toString() + ".__", (Object)multiReader);
        }
    }

    private void addMLTextPropertyToDoc(SolrInputDocument doc, QName propertyQName, MLTextPropertyValue mlTextPropertyValue) throws IOException {
        PropertyDefinition propertyDefinition = this.dataModel.getPropertyDefinition(propertyQName);
        if (propertyDefinition != null) {
            StringBuilder sort = new StringBuilder();
            for (Locale locale : mlTextPropertyValue.getLocales()) {
                StringBuilder builder = new StringBuilder();
                builder.append("\u0000").append(locale.toString()).append("\u0000").append(mlTextPropertyValue.getValue(locale));
                if (propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.TRUE || propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.BOTH) {
                    doc.addField("@" + propertyQName.toString(), (Object)builder.toString());
                    doc.addField("@" + propertyQName.toString() + ".__", (Object)builder.toString());
                }
                if (propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.FALSE || propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.BOTH) {
                    doc.addField("@" + propertyQName.toString() + ".u", (Object)builder.toString());
                    doc.addField("@" + propertyQName.toString() + ".__.u", (Object)builder.toString());
                }
                if (sort.length() > 0) {
                    sort.append("\u0000");
                }
                sort.append(builder.toString());
            }
            if (propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.FALSE || propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.BOTH) {
                doc.addField("@" + propertyQName.toString() + ".sort", (Object)sort.toString());
            }
        } else {
            for (Locale locale : mlTextPropertyValue.getLocales()) {
                doc.addField("@" + propertyQName.toString(), (Object)mlTextPropertyValue.getValue(locale));
            }
        }
    }

    private void addStringPropertyToDoc(SolrInputDocument doc, QName propertyQName, StringPropertyValue stringPropertyValue, Map<QName, PropertyValue> properties) throws IOException {
        PropertyDefinition propertyDefinition = this.dataModel.getPropertyDefinition(propertyQName);
        if (propertyDefinition != null) {
            if (propertyDefinition.getDataType().getName().equals((Object)DataTypeDefinition.DATETIME)) {
                doc.addField("@" + propertyQName.toString(), (Object)stringPropertyValue.getValue());
                doc.addField("@" + propertyQName.toString() + ".sort", (Object)stringPropertyValue.getValue());
            } else if (propertyDefinition.getDataType().getName().equals((Object)DataTypeDefinition.TEXT)) {
                Locale locale = null;
                PropertyValue localePropertyValue = properties.get(ContentModel.PROP_LOCALE);
                if (localePropertyValue != null) {
                    locale = (Locale)DefaultTypeConverter.INSTANCE.convert(Locale.class, (Object)((StringPropertyValue)localePropertyValue).getValue());
                }
                if (locale == null) {
                    locale = I18NUtil.getLocale();
                }
                StringBuilder builder = new StringBuilder();
                builder.append("\u0000").append(locale.toString()).append("\u0000").append(stringPropertyValue.getValue());
                if (propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.TRUE || propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.BOTH) {
                    doc.addField("@" + propertyQName.toString(), (Object)builder.toString());
                    doc.addField("@" + propertyQName.toString() + ".__", (Object)builder.toString());
                }
                if (propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.FALSE || propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.BOTH) {
                    doc.addField("@" + propertyQName.toString() + ".u", (Object)builder.toString());
                    doc.addField("@" + propertyQName.toString() + ".__.u", (Object)builder.toString());
                }
                if (propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.FALSE || propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.BOTH) {
                    doc.addField("@" + propertyQName.toString() + ".sort", (Object)builder.toString());
                }
            } else {
                doc.addField("@" + propertyQName.toString(), (Object)stringPropertyValue.getValue());
            }
        } else {
            doc.addField("@" + propertyQName.toString(), (Object)stringPropertyValue.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexHealthReport checkIndex(Long fromTx, Long toTx, Long fromAclTx, Long toAclTx, Long fromTime, Long toTime) throws AuthenticationException, IOException, JSONException {
        List<AclChangeSet> aclTransactions;
        Transactions transactions;
        IndexHealthReport indexHealthReport = new IndexHealthReport();
        Long minTxId = null;
        Long minAclTxId = null;
        long firstTransactionCommitTime = 0L;
        Transactions firstTransactions = this.client.getTransactions(null, 0L, null, 2000L, 1);
        if (firstTransactions.getTransactions().size() > 0) {
            Transaction firstTransaction = firstTransactions.getTransactions().get(0);
            firstTransactionCommitTime = firstTransaction.getCommitTimeMs();
        }
        OpenBitSet txIdsInDb = new OpenBitSet();
        Long lastTxCommitTime = firstTransactionCommitTime;
        if (fromTime != null) {
            lastTxCommitTime = fromTime;
        }
        long maxTxId = 0L;
        BoundedDeque<Transaction> txnsFound = new BoundedDeque<Transaction>(100);
        long endTime = System.currentTimeMillis() + this.holeRetention;
        block3: do {
            transactions = this.getSomeTransactions(txnsFound, lastTxCommitTime, 3600000, 2000, endTime);
            for (Transaction info : transactions.getTransactions()) {
                if (toTime != null && info.getCommitTimeMs() > toTime || toTx != null && info.getId() > toTx) break block3;
                if (minTxId == null) {
                    minTxId = info.getId();
                }
                if (maxTxId < info.getId()) {
                    maxTxId = info.getId();
                }
                lastTxCommitTime = info.getCommitTimeMs();
                txIdsInDb.set(info.getId());
                txnsFound.add(info);
            }
        } while (transactions.getTransactions().size() > 0);
        indexHealthReport.setDbTransactionCount(txIdsInDb.cardinality());
        OpenBitSet aclTxIdsInDb = new OpenBitSet();
        Long lastAclTxCommitTime = firstTransactionCommitTime;
        if (fromTime != null) {
            lastAclTxCommitTime = fromTime;
        }
        long maxAclTxId = 0L;
        BoundedDeque<AclChangeSet> changeSetsFound = new BoundedDeque<AclChangeSet>(100);
        block5: do {
            aclTransactions = this.getSomeAclChangeSets(changeSetsFound, lastAclTxCommitTime, 3600000, 2000, endTime);
            for (AclChangeSet set : aclTransactions) {
                if (toTime != null && set.getCommitTimeMs() > toTime || toAclTx != null && set.getId() > toAclTx) break block5;
                if (minAclTxId == null) {
                    minAclTxId = set.getId();
                }
                if (maxAclTxId < set.getId()) {
                    maxAclTxId = set.getId();
                }
                lastAclTxCommitTime = set.getCommitTimeMs();
                aclTxIdsInDb.set(set.getId());
                changeSetsFound.add(set);
            }
        } while (aclTransactions.size() > 0);
        indexHealthReport.setDbAclTransactionCount(aclTxIdsInDb.cardinality());
        OpenBitSet txIdsInIndex = new OpenBitSet();
        OpenBitSet aclTxIdsInIndex = new OpenBitSet();
        RefCounted refCounted = this.core.getSearcher(false, true, null);
        if (refCounted == null) {
            return indexHealthReport;
        }
        try {
            Term term;
            Term term2;
            int doc;
            Term term3;
            String target;
            int docCount;
            long i;
            int count;
            TermDocs termDocs;
            SolrIndexSearcher solrIndexSearcher = (SolrIndexSearcher)refCounted.get();
            SolrIndexReader reader = solrIndexSearcher.getReader();
            if (minTxId != null) {
                termDocs = null;
                count = 0;
                for (i = minTxId.longValue(); i <= maxTxId; ++i) {
                    docCount = 0;
                    target = NumericEncoder.encode((long)i);
                    term3 = new Term("TXID", target);
                    if (termDocs == null) {
                        termDocs = reader.termDocs(term3);
                    } else {
                        termDocs.seek(term3);
                    }
                    while (termDocs.next()) {
                        doc = termDocs.doc();
                        if (reader.isDeleted(doc)) continue;
                        ++docCount;
                    }
                    if (docCount == 0) {
                        if (!txIdsInDb.get(i)) continue;
                        indexHealthReport.setMissingTxFromIndex(i);
                        continue;
                    }
                    if (docCount == 1) {
                        txIdsInIndex.set(i);
                        if (!txIdsInDb.get(i)) {
                            indexHealthReport.setTxInIndexButNotInDb(i);
                        }
                        ++count;
                        continue;
                    }
                    if (docCount <= 1) continue;
                    indexHealthReport.setDuplicatedTxInIndex(i);
                    if (!txIdsInDb.get(i)) {
                        indexHealthReport.setTxInIndexButNotInDb(i);
                    }
                    ++count;
                }
                if (termDocs != null) {
                    termDocs.close();
                }
                indexHealthReport.setUniqueTransactionDocsInIndex(txIdsInIndex.cardinality());
                indexHealthReport.setTransactionDocsInIndex(count);
            }
            if (minAclTxId != null) {
                termDocs = null;
                count = 0;
                for (i = minAclTxId.longValue(); i <= maxTxId; ++i) {
                    docCount = 0;
                    target = NumericEncoder.encode((long)i);
                    term3 = new Term("ACLTXID", target);
                    if (termDocs == null) {
                        termDocs = reader.termDocs(term3);
                    } else {
                        termDocs.seek(term3);
                    }
                    while (termDocs.next()) {
                        doc = termDocs.doc();
                        if (reader.isDeleted(doc)) continue;
                        ++docCount;
                    }
                    if (docCount == 0) {
                        if (!aclTxIdsInDb.get(i)) continue;
                        indexHealthReport.setMissingAclTxFromIndex(i);
                        continue;
                    }
                    if (docCount == 1) {
                        aclTxIdsInIndex.set(i);
                        if (!aclTxIdsInDb.get(i)) {
                            indexHealthReport.setAclTxInIndexButNotInDb(i);
                        }
                        ++count;
                        continue;
                    }
                    if (docCount <= 1) continue;
                    indexHealthReport.setDuplicatedAclTxInIndex(i);
                    if (!aclTxIdsInDb.get(i)) {
                        indexHealthReport.setAclTxInIndexButNotInDb(i);
                    }
                    ++count;
                }
                if (termDocs != null) {
                    termDocs.close();
                }
                indexHealthReport.setUniqueAclTransactionDocsInIndex(aclTxIdsInIndex.cardinality());
                indexHealthReport.setAclTransactionDocsInIndex(count);
            }
            int leafCount = 0;
            TermEnum termEnum = reader.terms(new Term("ID", "LEAF-"));
            while ((term2 = termEnum.term()).field().equals("ID") && term2.text().startsWith("LEAF-")) {
                int docCount2 = 0;
                TermDocs termDocs2 = reader.termDocs(new Term("ID", term2.text()));
                while (termDocs2.next()) {
                    if (reader.isDeleted(termDocs2.doc())) continue;
                    ++docCount2;
                }
                if (docCount2 > 1) {
                    long txid = Long.parseLong(term2.text().substring(5));
                    indexHealthReport.setDuplicatedLeafInIndex(txid);
                }
                ++leafCount;
                if (termEnum.next()) continue;
            }
            termEnum.close();
            indexHealthReport.setLeafDocCountInIndex(leafCount);
            int auxCount = 0;
            termEnum = reader.terms(new Term("ID", "AUX-"));
            while ((term = termEnum.term()).field().equals("ID") && term.text().startsWith("AUX-")) {
                int docCount3 = 0;
                TermDocs termDocs3 = reader.termDocs(new Term("ID", term.text()));
                while (termDocs3.next()) {
                    if (reader.isDeleted(termDocs3.doc())) continue;
                    ++docCount3;
                }
                if (docCount3 > 1) {
                    long txid = Long.parseLong(term.text().substring(5));
                    indexHealthReport.setDuplicatedAuxInIndex(txid);
                }
                ++auxCount;
                if (termEnum.next()) continue;
            }
            termEnum.close();
            indexHealthReport.setAuxDocCountInIndex(auxCount);
            indexHealthReport.setLastIndexedCommitTime(this.lastIndexedTxCommitTime);
            indexHealthReport.setLastIndexedIdBeforeHoles(this.lastIndexedTxIdBeforeHoles);
            IndexHealthReport indexHealthReport2 = indexHealthReport;
            return indexHealthReport2;
        }
        finally {
            refCounted.decref();
        }
    }

    private long getLastTxCommitTimeBeforeHoles(SolrIndexReader reader, Long cutOffTime) throws IOException {
        Long txCommitTime;
        Term term;
        long lastTxCommitTimeBeforeHoles = 0L;
        TermEnum termEnum = reader.terms(new Term("TXCOMMITTIME", ""));
        while ((term = termEnum.term()) != null && term.field().equals("TXCOMMITTIME") && (txCommitTime = Long.valueOf(NumericEncoder.decodeLong((String)term.text()))) < cutOffTime) {
            lastTxCommitTimeBeforeHoles = txCommitTime;
            if (termEnum.next()) continue;
        }
        termEnum.close();
        return lastTxCommitTimeBeforeHoles;
    }

    private long getLastChangeSetCommitTimeBeforeHoles(SolrIndexReader reader, Long cutOffTime) throws IOException {
        Long txCommitTime;
        Term term;
        long lastTxCommitTimeBeforeHoles = 0L;
        TermEnum termEnum = reader.terms(new Term("ACLTXCOMMITTIME", ""));
        while ((term = termEnum.term()) != null && term.field().equals("ACLTXCOMMITTIME") && (txCommitTime = Long.valueOf(NumericEncoder.decodeLong((String)term.text()))) < cutOffTime) {
            lastTxCommitTimeBeforeHoles = txCommitTime;
            if (termEnum.next()) continue;
        }
        termEnum.close();
        return lastTxCommitTimeBeforeHoles;
    }

    private long getLargestTxIdByCommitTime(SolrIndexReader reader, Long lastTxCommitTimeBeforeHoles) throws IOException {
        long txid = -1L;
        if (lastTxCommitTimeBeforeHoles != -1L) {
            TermDocs docs = reader.termDocs(new Term("TXCOMMITTIME", NumericEncoder.encode((long)lastTxCommitTimeBeforeHoles)));
            while (docs.next()) {
                long currentTxId;
                Document doc = reader.document(docs.doc());
                Fieldable field = doc.getFieldable("TXID");
                if (field == null || (currentTxId = Long.valueOf(field.stringValue()).longValue()) <= txid) continue;
                txid = currentTxId;
            }
        }
        return txid;
    }

    private long getLargestChangeSetIdByCommitTime(SolrIndexReader reader, Long lastChangeSetCommitTimeBeforeHoles) throws IOException {
        long txid = -1L;
        if (lastChangeSetCommitTimeBeforeHoles != -1L) {
            TermDocs docs = reader.termDocs(new Term("ACLTXCOMMITTIME", NumericEncoder.encode((long)lastChangeSetCommitTimeBeforeHoles)));
            while (docs.next()) {
                long currentTxId;
                Document doc = reader.document(docs.doc());
                Fieldable field = doc.getFieldable("ACLTXID");
                if (field == null || (currentTxId = Long.valueOf(field.stringValue()).longValue()) <= txid) continue;
                txid = currentTxId;
            }
        }
        return txid;
    }

    private long getLastTransactionCommitTime(SolrIndexReader reader) throws IOException {
        long lastTxCommitTime = 0L;
        try {
            Term term;
            TermEnum termEnum = reader.terms(new Term("TXCOMMITTIME", ""));
            while ((term = termEnum.term()) != null && term.field().equals("TXCOMMITTIME")) {
                Long txCommitTime = NumericEncoder.decodeLong((String)term.text());
                lastTxCommitTime = txCommitTime;
                if (termEnum.next()) continue;
            }
            termEnum.close();
        }
        catch (IOException e1) {
            // empty catch block
        }
        return lastTxCommitTime;
    }

    private long getLastChangeSetCommitTime(SolrIndexReader reader) throws IOException {
        long lastTxCommitTime = 0L;
        try {
            Term term;
            TermEnum termEnum = reader.terms(new Term("ACLTXCOMMITTIME", ""));
            while ((term = termEnum.term()) != null && term.field().equals("ACLTXCOMMITTIME")) {
                Long txCommitTime = NumericEncoder.decodeLong((String)term.text());
                lastTxCommitTime = txCommitTime;
                if (termEnum.next()) continue;
            }
            termEnum.close();
        }
        catch (IOException e1) {
            // empty catch block
        }
        return lastTxCommitTime;
    }

    public static Document toDocument(SolrInputDocument doc, IndexSchema schema, AlfrescoSolrDataModel model) {
        Document out = new Document();
        out.setBoost(doc.getDocumentBoost());
        for (SolrInputField field : doc) {
            String name = field.getName();
            SchemaField sfield = schema.getFieldOrNull(name);
            boolean used = false;
            float boost = field.getBoost();
            if (sfield != null && !sfield.multiValued() && field.getValueCount() > 1) {
                String id = "";
                SchemaField sf = schema.getUniqueKeyField();
                if (sf != null) {
                    id = "[" + doc.getFieldValue(sf.getName()) + "] ";
                }
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "ERROR: " + id + "multiple values encountered for non multiValued field " + sfield.getName() + ": " + field.getValue());
            }
            boolean hasField = false;
            for (Object v : field) {
                if (v == null) continue;
                String val = null;
                hasField = true;
                boolean isBinaryField = false;
                if (sfield != null && sfield.getType() instanceof BinaryField) {
                    isBinaryField = true;
                    BinaryField binaryField = (BinaryField)sfield.getType();
                    Field f = binaryField.createField(sfield, v, boost);
                    if (f != null) {
                        out.add((Fieldable)f);
                    }
                    used = true;
                } else {
                    if (sfield != null && v instanceof Date && sfield.getType() instanceof DateField) {
                        DateField df = (DateField)sfield.getType();
                        val = df.toInternal((Date)v) + 'Z';
                    } else if (v != null) {
                        val = v.toString();
                    }
                    if (sfield != null) {
                        Field f;
                        if (v instanceof Reader) {
                            used = true;
                            f = new Field(field.getName(), (Reader)v, model.getFieldTermVec(sfield));
                            f.setOmitNorms(model.getOmitNorms(sfield));
                            f.setOmitTermFreqAndPositions(sfield.omitTf());
                            if (f != null) {
                                out.add((Fieldable)f);
                            }
                        } else {
                            used = true;
                            f = sfield.createField(val, boost);
                            if (f != null) {
                                out.add((Fieldable)f);
                            }
                        }
                    }
                }
                List copyFields = schema.getCopyFieldsList(name);
                for (CopyField cf : copyFields) {
                    SchemaField destinationField = cf.getDestination();
                    if (!destinationField.multiValued() && out.get(destinationField.getName()) != null) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "ERROR: multiple values encountered for non multiValued copy field " + destinationField.getName() + ": " + val);
                    }
                    used = true;
                    Field f = null;
                    if (isBinaryField) {
                        if (destinationField.getType() instanceof BinaryField) {
                            BinaryField binaryField = (BinaryField)destinationField.getType();
                            f = binaryField.createField(destinationField, v, boost);
                        }
                    } else {
                        f = destinationField.createField(cf.getLimitedValue(val), boost);
                    }
                    if (f == null) continue;
                    out.add((Fieldable)f);
                }
                boost = 1.0f;
            }
            if (used || !hasField) continue;
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "ERROR:unknown field '" + name + "'");
        }
        for (SolrInputField field : schema.getRequiredFields()) {
            if (out.getField(field.getName()) != null) continue;
            if (field.getDefaultValue() != null) {
                out.add((Fieldable)field.createField(field.getDefaultValue(), 1.0f));
                continue;
            }
            String id = schema.printableUniqueKey(out);
            String msg = "Document [" + id + "] missing required field: " + field.getName();
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, msg);
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeReport checkNodeCommon(NodeReport nodeReport) {
        long dbid = nodeReport.getDbid();
        try {
            RefCounted refCounted = this.core.getSearcher(false, true, null);
            refCounted = this.core.getSearcher(false, true, null);
            if (refCounted == null) {
                return nodeReport;
            }
            try {
                SolrIndexSearcher solrIndexSearcher = (SolrIndexSearcher)refCounted.get();
                String dbidString = NumericEncoder.encode((long)dbid);
                DocSet docSet = solrIndexSearcher.getDocSet((Query)new TermQuery(new Term("DBID", dbidString)));
                DocIterator it = docSet.iterator();
                while (it.hasNext()) {
                    String value;
                    int doc = it.nextDoc();
                    Document document = solrIndexSearcher.doc(doc);
                    Fieldable fieldable = document.getFieldable("ID");
                    if (fieldable == null || (value = fieldable.stringValue()) == null) continue;
                    if (value.startsWith("LEAF-")) {
                        nodeReport.setIndexLeafDoc(Long.valueOf(doc));
                        continue;
                    }
                    if (!value.startsWith("AUX-")) continue;
                    nodeReport.setIndexAuxDoc(Long.valueOf(doc));
                }
                DocSet txDocSet = solrIndexSearcher.getDocSet((Query)new WildcardQuery(new Term("TXID", "*")));
                DocIterator it2 = txDocSet.iterator();
                while (it2.hasNext()) {
                    long txid;
                    String value;
                    int doc = it2.nextDoc();
                    Document document = solrIndexSearcher.doc(doc);
                    Fieldable fieldable = document.getFieldable("TXID");
                    if (fieldable == null) continue;
                    if (nodeReport.getIndexLeafDoc() == null || (long)doc < nodeReport.getIndexLeafDoc()) {
                        value = fieldable.stringValue();
                        txid = Long.parseLong(value);
                        nodeReport.setIndexLeafTx(txid);
                    }
                    if (nodeReport.getIndexAuxDoc() != null && (long)doc >= nodeReport.getIndexAuxDoc()) continue;
                    value = fieldable.stringValue();
                    txid = Long.parseLong(value);
                    nodeReport.setIndexAuxTx(txid);
                }
            }
            finally {
                refCounted.decref();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return nodeReport;
    }

    public NodeReport checkNode(Node node) {
        NodeReport nodeReport = new NodeReport();
        nodeReport.setDbid(node.getId());
        nodeReport.setDbNodeStatus(node.getStatus());
        nodeReport.setDbTx(node.getTxnId());
        this.checkNodeCommon(nodeReport);
        return nodeReport;
    }

    public NodeReport checkNode(Long dbid) {
        NodeReport nodeReport = new NodeReport();
        nodeReport.setDbid(dbid);
        GetNodesParameters parameters = new GetNodesParameters();
        parameters.setFromNodeId(dbid);
        parameters.setToNodeId(dbid);
        try {
            List<Node> dbnodes = this.client.getNodes(parameters, 1);
            if (dbnodes.size() == 1) {
                Node dbnode = dbnodes.get(0);
                nodeReport.setDbNodeStatus(dbnode.getStatus());
                nodeReport.setDbTx(dbnode.getTxnId());
            } else {
                nodeReport.setDbNodeStatus(Node.SolrApiNodeStatus.UNKNOWN);
                nodeReport.setDbTx(-1L);
            }
        }
        catch (IOException e) {
            nodeReport.setDbNodeStatus(Node.SolrApiNodeStatus.UNKNOWN);
            nodeReport.setDbTx(-2L);
        }
        catch (JSONException e) {
            nodeReport.setDbNodeStatus(Node.SolrApiNodeStatus.UNKNOWN);
            nodeReport.setDbTx(-3L);
        }
        catch (AuthenticationException e1) {
            nodeReport.setDbNodeStatus(Node.SolrApiNodeStatus.UNKNOWN);
            nodeReport.setDbTx(-4L);
        }
        this.checkNodeCommon(nodeReport);
        return nodeReport;
    }

    public List<Node> getFullNodesForDbTransaction(Long txid) {
        try {
            GetNodesParameters gnp = new GetNodesParameters();
            ArrayList<Long> txs = new ArrayList<Long>();
            txs.add(txid);
            gnp.setTransactionIds(txs);
            gnp.setStoreProtocol(this.storeRef.getProtocol());
            gnp.setStoreIdentifier(this.storeRef.getIdentifier());
            return this.client.getNodes(gnp, Integer.MAX_VALUE);
        }
        catch (IOException e) {
            throw new AlfrescoRuntimeException("Failed to get nodes", (Throwable)e);
        }
        catch (JSONException e) {
            throw new AlfrescoRuntimeException("Failed to get nodes", (Throwable)e);
        }
        catch (AuthenticationException e) {
            throw new AlfrescoRuntimeException("Failed to get nodes", (Throwable)e);
        }
    }

    public List<Long> getNodesForDbTransaction(Long txid) {
        try {
            ArrayList<Long> answer = new ArrayList<Long>();
            GetNodesParameters gnp = new GetNodesParameters();
            ArrayList<Long> txs = new ArrayList<Long>();
            txs.add(txid);
            gnp.setTransactionIds(txs);
            gnp.setStoreProtocol(this.storeRef.getProtocol());
            gnp.setStoreIdentifier(this.storeRef.getIdentifier());
            List<Node> nodes = this.client.getNodes(gnp, Integer.MAX_VALUE);
            for (Node node : nodes) {
                answer.add(node.getId());
            }
            return answer;
        }
        catch (IOException e) {
            throw new AlfrescoRuntimeException("Failed to get nodes", (Throwable)e);
        }
        catch (JSONException e) {
            throw new AlfrescoRuntimeException("Failed to get nodes", (Throwable)e);
        }
        catch (AuthenticationException e) {
            throw new AlfrescoRuntimeException("Failed to get nodes", (Throwable)e);
        }
    }

    public List<Long> getAclsForDbAclTransaction(Long acltxid) {
        try {
            ArrayList<Long> answer = new ArrayList<Long>();
            List<AclChangeSet> changeSet = this.client.getAclChangeSets(null, acltxid, null, acltxid + 1L, 1);
            List<Acl> acls = this.client.getAcls(changeSet, null, Integer.MAX_VALUE);
            for (Acl acl : acls) {
                answer.add(acl.getId());
            }
            return answer;
        }
        catch (IOException e) {
            throw new AlfrescoRuntimeException("Failed to get acls", (Throwable)e);
        }
        catch (JSONException e) {
            throw new AlfrescoRuntimeException("Failed to get acls", (Throwable)e);
        }
        catch (AuthenticationException e) {
            throw new AlfrescoRuntimeException("Failed to get acls", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AclReport checkAcl(Long aclid) {
        AclReport aclReport = new AclReport();
        aclReport.setAclId(aclid);
        try {
            List<AclReaders> readers = this.client.getAclReaders(Collections.singletonList(new Acl(0L, aclid)));
            aclReport.setExistsInDb(readers.size() == 1);
        }
        catch (IOException e) {
            aclReport.setExistsInDb(false);
        }
        catch (JSONException e) {
            aclReport.setExistsInDb(false);
        }
        catch (AuthenticationException e) {
            aclReport.setExistsInDb(false);
        }
        try {
            RefCounted refCounted = this.core.getSearcher(false, true, null);
            refCounted = this.core.getSearcher(false, true, null);
            if (refCounted == null) {
                return aclReport;
            }
            try {
                SolrIndexSearcher solrIndexSearcher = (SolrIndexSearcher)refCounted.get();
                SolrIndexReader reader = solrIndexSearcher.getReader();
                String aclIdString = NumericEncoder.encode((long)aclid);
                DocSet docSet = solrIndexSearcher.getDocSet((Query)new TermQuery(new Term("ACLID", aclIdString)));
                DocIterator it = docSet.iterator();
                while (it.hasNext()) {
                    String value;
                    int doc = it.nextDoc();
                    Document document = solrIndexSearcher.doc(doc);
                    Fieldable fieldable = document.getFieldable("ID");
                    if (fieldable == null || (value = fieldable.stringValue()) == null || !value.startsWith("ACL-")) continue;
                    aclReport.setIndexAclDoc(Long.valueOf(doc));
                }
                DocSet txDocSet = solrIndexSearcher.getDocSet((Query)new WildcardQuery(new Term("ACLTXID", "*")));
                DocIterator it2 = txDocSet.iterator();
                while (it2.hasNext()) {
                    int doc = it2.nextDoc();
                    Document document = solrIndexSearcher.doc(doc);
                    Fieldable fieldable = document.getFieldable("ACLTXID");
                    if (fieldable == null || aclReport.getIndexAclDoc() != null && (long)doc >= aclReport.getIndexAclDoc()) continue;
                    String value = fieldable.stringValue();
                    long acltxid = Long.parseLong(value);
                    aclReport.setIndexAclTx(acltxid);
                }
            }
            finally {
                refCounted.decref();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return aclReport;
    }

    private void loadModel(Map<String, M2Model> modelMap, HashSet<String> loadedModels, M2Model model, AlfrescoSolrDataModel dataModel) {
        String modelName = model.getName();
        if (!loadedModels.contains(modelName)) {
            for (M2Namespace importNamespace : model.getImports()) {
                M2Model importedModel = modelMap.get(importNamespace.getUri());
                if (importedModel == null) continue;
                this.loadModel(modelMap, loadedModels, importedModel, dataModel);
            }
            dataModel.putModel(model);
            loadedModels.add(modelName);
            log.info("Loading model " + model.getName());
        }
    }

    private String getModelFileName(M2Model model) {
        return model.getName().replace(":", ".") + "." + model.getChecksum(ModelDefinition.XMLBindingType.DEFAULT) + ".xml";
    }

    public void close(SolrCore core) {
        try {
            this.adminHandler.getScheduler().deleteJob("CoreTracker-" + core.getName(), "Solr");
            this.adminHandler.getTrackers().remove(core.getName());
            if (this.adminHandler.getTrackers().size() == 0 && !this.adminHandler.getScheduler().isShutdown()) {
                this.adminHandler.getScheduler().shutdown();
            }
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BoundedDeque<T>
    implements Iterable<T> {
        private LinkedBlockingDeque<T> deque;
        private int max = 10;

        BoundedDeque(int max) {
            this.max = max;
            this.deque = new LinkedBlockingDeque();
        }

        public int size() {
            return this.deque.size();
        }

        void add(T add) {
            while (this.deque.size() > this.max - 1) {
                this.deque.removeLast();
            }
            this.deque.addFirst(add);
        }

        T getLast() {
            return this.deque.getFirst();
        }

        @Override
        public Iterator<T> iterator() {
            return this.deque.iterator();
        }
    }
}

