/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.abdera.ext;

import java.math.BigDecimal;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.namespace.QName;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.ExtensibleElementWrapper;
import org.apache.chemistry.abdera.ext.CMISProperty;

public class CMISValue
extends ExtensibleElementWrapper {
    public CMISValue(Element internal) {
        super(internal);
    }

    public CMISValue(Factory factory, QName qname) {
        super(factory, qname);
    }

    public Object getNativeValue() {
        CMISProperty parent = (CMISProperty)this.getParentElement();
        String type = parent.getType();
        if (type.equals("string")) {
            return this.getStringValue();
        }
        if (type.equals("integer")) {
            return this.getIntegerValue();
        }
        if (type.equals("datetime")) {
            return this.getDateValue();
        }
        if (type.equals("boolean")) {
            return this.getBooleanValue();
        }
        if (type.equals("decimal")) {
            return this.getDecimalValue();
        }
        return this.getStringValue();
    }

    public String getStringValue() {
        return this.getText();
    }

    public BigDecimal getDecimalValue() {
        return new BigDecimal(this.getStringValue());
    }

    public int getIntegerValue() {
        return new Integer(this.getStringValue());
    }

    public boolean getBooleanValue() {
        return Boolean.valueOf(this.getStringValue());
    }

    public Date getDateValue() {
        try {
            DatatypeFactory df = DatatypeFactory.newInstance();
            GregorianCalendar calendar = df.newXMLGregorianCalendar(this.getStringValue()).toGregorianCalendar();
            return calendar.getTime();
        }
        catch (DatatypeConfigurationException e) {
            return null;
        }
    }
}

