/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.action.CollectionAction;
import org.hibernate.action.EntityAction;
import org.hibernate.action.Executable;
import org.hibernate.engine.SessionImplementor;

public class AmalgamatedCleanupAction
implements Executable,
Serializable {
    private final SessionImplementor session;
    private final Set affectedEntityNames = new HashSet();
    private final Set affectedCollectionRoles = new HashSet();
    private final Set spaces = new HashSet();

    public AmalgamatedCleanupAction(SessionImplementor session) {
        this.session = session;
    }

    public void addExecutable(Executable executable) {
        block4: {
            CollectionAction collectionAction;
            String collectionRole;
            block3: {
                if (!(executable instanceof EntityAction)) break block3;
                EntityAction entityAction = (EntityAction)executable;
                String entityName = entityAction.getEntityName();
                if (this.affectedEntityNames.contains(entityName)) break block4;
                this.affectedEntityNames.add(entityName);
                Serializable[] toAdd = entityAction.getPropertySpaces();
                for (int i = 0; i < toAdd.length; ++i) {
                    this.spaces.add(toAdd[i]);
                }
                break block4;
            }
            if (executable instanceof CollectionAction && !this.affectedCollectionRoles.contains(collectionRole = (collectionAction = (CollectionAction)executable).getCollectionRole())) {
                this.affectedCollectionRoles.add(collectionRole);
                Serializable[] toAdd = collectionAction.getPropertySpaces();
                for (int i = 0; i < toAdd.length; ++i) {
                    this.spaces.add(toAdd[i]);
                }
            }
        }
    }

    public void afterTransactionCompletion(boolean success) throws HibernateException {
        this.evictEntityRegions();
        this.evictCollectionRegions();
    }

    public void beforeExecutions() throws HibernateException {
    }

    public void execute() throws HibernateException {
    }

    public Serializable[] getPropertySpaces() {
        Serializable[] answer = new Serializable[this.spaces.size()];
        int position = 0;
        Iterator it = this.spaces.iterator();
        while (it.hasNext()) {
            Serializable s = (Serializable)it.next();
            answer[position++] = s;
        }
        return answer;
    }

    public boolean hasAfterTransactionCompletion() {
        return true;
    }

    public boolean hasCache() {
        return true;
    }

    public boolean hasPostCommitEventListeners() {
        return false;
    }

    public boolean isBulkAction() {
        return true;
    }

    private void evictEntityRegions() {
        if (this.affectedEntityNames != null) {
            Iterator itr = this.affectedEntityNames.iterator();
            while (itr.hasNext()) {
                String entityName = (String)itr.next();
                this.session.getFactory().evictEntity(entityName);
            }
        }
    }

    private void evictCollectionRegions() {
        if (this.affectedCollectionRoles != null) {
            Iterator itr = this.affectedCollectionRoles.iterator();
            while (itr.hasNext()) {
                String roleName = (String)itr.next();
                this.session.getFactory().evictCollection(roleName);
            }
        }
    }
}

