/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.alfresco.opencmis.EnumLabel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumFactory<E extends Enum<E>> {
    private E defaultEnum;
    private Map<String, E> labelMap = new HashMap<String, E>(10);

    public EnumFactory(Class<E> enumClass) {
        this(enumClass, null, false);
    }

    public EnumFactory(Class<E> enumClass, E defaultEnum) {
        this(enumClass, defaultEnum, false);
    }

    public EnumFactory(Class<E> enumClass, E defaultEnum, boolean caseSensitive) {
        this.defaultEnum = defaultEnum;
        this.labelMap = caseSensitive ? new HashMap(10) : new TreeMap(String.CASE_INSENSITIVE_ORDER);
        EnumSet<Enum> enumSet = EnumSet.allOf(enumClass);
        for (Enum e : enumSet) {
            if (!(e instanceof EnumLabel)) continue;
            this.labelMap.put(((EnumLabel)((Object)e)).getLabel(), e);
        }
    }

    public Enum<E> getDefaultEnum() {
        return this.defaultEnum;
    }

    public String getDefaultLabel() {
        return this.label(this.defaultEnum);
    }

    public String label(E e) {
        if (e instanceof EnumLabel) {
            return ((EnumLabel)e).getLabel();
        }
        return null;
    }

    public boolean validLabel(String label) {
        return this.fromLabel(label) != null;
    }

    public E fromLabel(String label) {
        return (E)((Enum)this.labelMap.get(label));
    }

    public E toEnum(String label) {
        E e;
        E e2 = e = label == null ? null : (E)this.fromLabel(label);
        if (e == null) {
            e = this.defaultEnum;
        }
        return e;
    }
}

