/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis.dictionary;

import org.alfresco.opencmis.CMISUtils;
import org.alfresco.opencmis.dictionary.PropertyAccessorMapping;
import org.alfresco.opencmis.dictionary.PropertyLuceneBuilderMapping;
import org.alfresco.opencmis.dictionary.ShadowTypeDefinitionWrapper;
import org.alfresco.opencmis.mapping.CMISMapping;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ISO9075;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.ContentStreamAllowed;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AbstractTypeDefinition;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.DocumentTypeDefinitionImpl;

public class DocumentTypeDefinitionWrapper
extends ShadowTypeDefinitionWrapper {
    private static final long serialVersionUID = 1L;
    private DocumentTypeDefinitionImpl typeDef;
    private DocumentTypeDefinitionImpl typeDefInclProperties;

    public DocumentTypeDefinitionWrapper(CMISMapping cmisMapping, PropertyAccessorMapping accessorMapping, PropertyLuceneBuilderMapping luceneBuilderMapping, String typeId, ClassDefinition cmisClassDef) {
        this.alfrescoName = cmisClassDef.getName();
        this.alfrescoClass = cmisMapping.getAlfrescoClass(this.alfrescoName);
        this.typeDef = new DocumentTypeDefinitionImpl();
        this.typeDef.setBaseTypeId(BaseTypeId.CMIS_DOCUMENT);
        this.typeDef.setId(typeId);
        this.typeDef.setLocalName(this.alfrescoName.getLocalName());
        this.typeDef.setLocalNamespace(this.alfrescoName.getNamespaceURI());
        if (BaseTypeId.CMIS_DOCUMENT.value().equals(typeId)) {
            this.typeDef.setQueryName(ISO9075.encodeSQL(typeId));
            this.typeDef.setParentTypeId(null);
        } else {
            this.typeDef.setQueryName(ISO9075.encodeSQL(cmisMapping.buildPrefixEncodedString(this.alfrescoName)));
            QName parentQName = cmisMapping.getCmisType(cmisClassDef.getParentName());
            if (cmisMapping.isValidCmisDocument(parentQName)) {
                this.typeDef.setParentTypeId(cmisMapping.getCmisTypeId(BaseTypeId.CMIS_DOCUMENT, parentQName));
            }
        }
        this.typeDef.setDisplayName(cmisClassDef.getTitle() != null ? cmisClassDef.getTitle() : typeId);
        this.typeDef.setDescription(cmisClassDef.getDescription() != null ? cmisClassDef.getDescription() : this.typeDef.getDisplayName());
        this.typeDef.setIsCreatable(Boolean.valueOf(true));
        this.typeDef.setIsQueryable(Boolean.valueOf(true));
        this.typeDef.setIsFulltextIndexed(Boolean.valueOf(true));
        this.typeDef.setIsControllablePolicy(Boolean.valueOf(false));
        this.typeDef.setIsControllableAcl(Boolean.valueOf(true));
        this.typeDef.setIsIncludedInSupertypeQuery(cmisClassDef.getIncludedInSuperTypeQuery());
        this.typeDef.setIsFileable(Boolean.valueOf(true));
        this.typeDef.setContentStreamAllowed(ContentStreamAllowed.ALLOWED);
        this.typeDef.setIsVersionable(Boolean.valueOf(true));
        this.typeDefInclProperties = CMISUtils.copy(this.typeDef);
        this.setTypeDefinition((AbstractTypeDefinition)this.typeDef, (AbstractTypeDefinition)this.typeDefInclProperties);
        this.createOwningPropertyDefinitions(cmisMapping, accessorMapping, luceneBuilderMapping, cmisClassDef);
        this.createActionEvaluators(accessorMapping, BaseTypeId.CMIS_DOCUMENT);
    }
}

