/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis.dictionary;

import java.util.ArrayList;
import java.util.Collections;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.opencmis.CMISUtils;
import org.alfresco.opencmis.dictionary.AbstractTypeDefinitionWrapper;
import org.alfresco.opencmis.dictionary.BasePropertyDefintionWrapper;
import org.alfresco.opencmis.dictionary.CMISAbstractDictionaryService;
import org.alfresco.opencmis.dictionary.PropertyAccessorMapping;
import org.alfresco.opencmis.dictionary.PropertyDefinitionWrapper;
import org.alfresco.opencmis.dictionary.PropertyLuceneBuilderMapping;
import org.alfresco.opencmis.dictionary.TypeDefinitionWrapper;
import org.alfresco.opencmis.mapping.CMISMapping;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.util.ISO9075;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AbstractTypeDefinition;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.RelationshipTypeDefinitionImpl;

public class RelationshipTypeDefintionWrapper
extends AbstractTypeDefinitionWrapper {
    private static final long serialVersionUID = 1L;
    private RelationshipTypeDefinitionImpl typeDef;
    private RelationshipTypeDefinitionImpl typeDefInclProperties;

    public RelationshipTypeDefintionWrapper(CMISMapping cmisMapping, PropertyAccessorMapping accessorMapping, PropertyLuceneBuilderMapping luceneBuilderMapping, String typeId, ClassDefinition cmisClassDef) {
        this.alfrescoName = cmisClassDef.getName();
        this.alfrescoClass = cmisMapping.getAlfrescoClass(this.alfrescoName);
        this.typeDef = new RelationshipTypeDefinitionImpl();
        this.typeDef.setBaseTypeId(BaseTypeId.CMIS_RELATIONSHIP);
        this.typeDef.setId(typeId);
        this.typeDef.setLocalName(this.alfrescoName.getLocalName());
        this.typeDef.setLocalNamespace(this.alfrescoName.getNamespaceURI());
        if (BaseTypeId.CMIS_RELATIONSHIP.value().equals(typeId)) {
            this.typeDef.setQueryName(ISO9075.encodeSQL(typeId));
            this.typeDef.setParentTypeId(null);
            this.typeDef.setIsCreatable(Boolean.valueOf(false));
        } else {
            this.typeDef.setQueryName(ISO9075.encodeSQL(cmisMapping.buildPrefixEncodedString(this.alfrescoName)));
            this.typeDef.setParentTypeId(BaseTypeId.CMIS_RELATIONSHIP.value());
            this.typeDef.setIsCreatable(Boolean.valueOf(true));
        }
        this.typeDef.setDisplayName(cmisClassDef.getTitle() != null ? cmisClassDef.getTitle() : typeId);
        this.typeDef.setDescription(cmisClassDef.getDescription() != null ? cmisClassDef.getDescription() : this.typeDef.getDisplayName());
        this.typeDef.setIsQueryable(Boolean.valueOf(false));
        this.typeDef.setIsFulltextIndexed(Boolean.valueOf(false));
        this.typeDef.setIsControllablePolicy(Boolean.valueOf(false));
        this.typeDef.setIsControllableAcl(Boolean.valueOf(false));
        this.typeDef.setIsIncludedInSupertypeQuery(Boolean.valueOf(true));
        this.typeDef.setIsFileable(Boolean.valueOf(false));
        this.typeDefInclProperties = CMISUtils.copy(this.typeDef);
        this.setTypeDefinition((AbstractTypeDefinition)this.typeDef, (AbstractTypeDefinition)this.typeDefInclProperties);
        this.createOwningPropertyDefinitions(cmisMapping, accessorMapping, luceneBuilderMapping, cmisClassDef);
        this.createActionEvaluators(accessorMapping, BaseTypeId.CMIS_RELATIONSHIP);
    }

    public RelationshipTypeDefintionWrapper(CMISMapping cmisMapping, PropertyAccessorMapping accessorMapping, PropertyLuceneBuilderMapping luceneBuilderMapping, String typeId, AssociationDefinition cmisAssocDef) {
        String targetTypeId;
        this.alfrescoName = cmisAssocDef.getName();
        this.alfrescoClass = cmisMapping.getAlfrescoClass(this.alfrescoName);
        this.typeDef = new RelationshipTypeDefinitionImpl();
        this.typeDef.setBaseTypeId(BaseTypeId.CMIS_RELATIONSHIP);
        this.typeDef.setId(typeId);
        this.typeDef.setLocalName(this.alfrescoName.getLocalName());
        this.typeDef.setLocalNamespace(this.alfrescoName.getNamespaceURI());
        this.typeDef.setQueryName(cmisMapping.buildPrefixEncodedString(this.alfrescoName));
        this.typeDef.setParentTypeId(BaseTypeId.CMIS_RELATIONSHIP.value());
        this.typeDef.setDisplayName(cmisAssocDef.getTitle() != null ? cmisAssocDef.getTitle() : typeId);
        this.typeDef.setDescription(cmisAssocDef.getDescription() != null ? cmisAssocDef.getDescription() : this.typeDef.getDisplayName());
        this.typeDef.setIsCreatable(Boolean.valueOf(true));
        this.typeDef.setIsQueryable(Boolean.valueOf(false));
        this.typeDef.setIsFulltextIndexed(Boolean.valueOf(false));
        this.typeDef.setIsControllablePolicy(Boolean.valueOf(false));
        this.typeDef.setIsControllableAcl(Boolean.valueOf(false));
        this.typeDef.setIsIncludedInSupertypeQuery(Boolean.valueOf(true));
        this.typeDef.setIsFileable(Boolean.valueOf(false));
        String sourceTypeId = cmisMapping.getCmisTypeId(cmisMapping.getCmisType(cmisAssocDef.getSourceClass().getName()));
        if (sourceTypeId != null) {
            this.typeDef.setAllowedSourceTypes(Collections.singletonList(sourceTypeId));
        }
        if ((targetTypeId = cmisMapping.getCmisTypeId(cmisMapping.getCmisType(cmisAssocDef.getTargetClass().getName()))) != null) {
            this.typeDef.setAllowedTargetTypes(Collections.singletonList(targetTypeId));
        }
        this.typeDefInclProperties = CMISUtils.copy(this.typeDef);
        this.setTypeDefinition((AbstractTypeDefinition)this.typeDef, (AbstractTypeDefinition)this.typeDefInclProperties);
        this.createActionEvaluators(accessorMapping, BaseTypeId.CMIS_RELATIONSHIP);
    }

    public void connectParentAndSubTypes(CMISMapping cmisMapping, CMISAbstractDictionaryService.DictionaryRegistry registry, DictionaryService dictionaryService) {
        if (this.typeDef.getParentTypeId() != null) {
            this.parent = registry.typeDefsByTypeId.get(this.typeDef.getParentTypeId());
        } else {
            if (!this.isBaseType()) {
                throw new AlfrescoRuntimeException("Type " + this.typeDef.getId() + " has no parent!");
            }
            this.parent = null;
        }
        this.children = new ArrayList();
        if (this.isBaseType()) {
            for (TypeDefinitionWrapper child : registry.assocDefsByQName.values()) {
                this.children.add(child);
            }
        }
    }

    public void resolveInheritance(CMISMapping cmisMapping, CMISAbstractDictionaryService.DictionaryRegistry registry, DictionaryService dictionaryService) {
        if (this.parent != null) {
            for (PropertyDefinitionWrapper propDef : this.parent.getProperties()) {
                PropertyDefinition alfrescoPropDef = dictionaryService.getProperty(propDef.getOwningType().getAlfrescoName(), propDef.getAlfrescoName());
                org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition<?> propertyDefintion = this.createPropertyDefinition(cmisMapping, propDef.getPropertyId(), alfrescoPropDef.getName(), alfrescoPropDef, true);
                if (propertyDefintion == null) continue;
                this.registerProperty(new BasePropertyDefintionWrapper(propertyDefintion, alfrescoPropDef.getName(), propDef.getOwningType(), propDef.getPropertyAccessor(), propDef.getPropertyLuceneBuilder()));
            }
        }
        for (TypeDefinitionWrapper child : this.children) {
            if (!(child instanceof AbstractTypeDefinitionWrapper)) continue;
            ((AbstractTypeDefinitionWrapper)child).resolveInheritance(cmisMapping, registry, dictionaryService);
        }
    }
}

