/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import java.util.Locale;
import java.util.ResourceBundle;
import org.alfresco.repo.dictionary.M2DataType;
import org.alfresco.repo.dictionary.M2Label;
import org.alfresco.repo.dictionary.ModelQuery;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.alfresco.service.cmr.dictionary.ModelDefinition;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.util.StringUtils;

class M2DataTypeDefinition
implements DataTypeDefinition {
    private ModelDefinition model;
    private QName name;
    private M2DataType dataType;
    private String analyserResourceBundleName;

    M2DataTypeDefinition(ModelDefinition model, M2DataType propertyType, NamespacePrefixResolver resolver) {
        this.model = model;
        this.name = QName.createQName(propertyType.getName(), resolver);
        if (!model.isNamespaceDefined(this.name.getNamespaceURI())) {
            throw new DictionaryException("Cannot define data type " + this.name.toPrefixString() + " as namespace " + this.name.getNamespaceURI() + " is not defined by model " + model.getName().toPrefixString());
        }
        this.dataType = propertyType;
        this.analyserResourceBundleName = this.dataType.getAnalyserResourceBundleName();
    }

    void resolveDependencies(ModelQuery query) {
        String javaClass = this.dataType.getJavaClassName();
        if (javaClass == null) {
            throw new DictionaryException("Java class of data type " + this.name.toPrefixString() + " must be specified");
        }
        try {
            Class.forName(javaClass);
        }
        catch (ClassNotFoundException e) {
            throw new DictionaryException("Java class " + javaClass + " of data type " + this.name.toPrefixString() + " is invalid", e);
        }
    }

    public String toString() {
        return this.getName().toString();
    }

    public ModelDefinition getModel() {
        return this.model;
    }

    public QName getName() {
        return this.name;
    }

    public String getTitle() {
        String value = M2Label.getLabel(this.model, "datatype", this.name, "title");
        if (value == null) {
            value = this.dataType.getTitle();
        }
        return value;
    }

    public String getDescription() {
        String value = M2Label.getLabel(this.model, "datatype", this.name, "description");
        if (value == null) {
            value = this.dataType.getDescription();
        }
        return value;
    }

    public String getDefaultAnalyserClassName() {
        return this.dataType.getDefaultAnalyserClassName();
    }

    public String getJavaClassName() {
        return this.dataType.getJavaClassName();
    }

    public String getAnalyserResourceBundleName() {
        return this.analyserResourceBundleName;
    }

    public String resolveAnalyserClassName() {
        return this.resolveAnalyserClassName(I18NUtil.getLocale());
    }

    public String resolveAnalyserClassName(Locale locale) {
        ResourceBundle bundle;
        String analyserResourceBundleName;
        ResourceBundle bundle2;
        ClassLoader resourceBundleClassLoader = this.getModel().getDictionaryDAO().getResourceClassLoader();
        if (resourceBundleClassLoader == null) {
            resourceBundleClassLoader = this.getClass().getClassLoader();
        }
        StringBuilder keyBuilder = new StringBuilder(64);
        keyBuilder.append(this.getModel().getName().toPrefixString());
        keyBuilder.append(".datatype");
        keyBuilder.append(".").append(this.getName().toPrefixString());
        keyBuilder.append(".analyzer");
        String key = StringUtils.replace((String)keyBuilder.toString(), (String)":", (String)"_");
        String analyserClassName = null;
        String defaultAnalyserResourceBundleName = this.getModel().getDictionaryDAO().getDefaultAnalyserResourceBundleName();
        if (defaultAnalyserResourceBundleName != null && (bundle2 = ResourceBundle.getBundle(defaultAnalyserResourceBundleName, locale, resourceBundleClassLoader)).containsKey(key)) {
            analyserClassName = bundle2.getString(key);
        }
        if (analyserClassName == null && (analyserResourceBundleName = this.dataType.getAnalyserResourceBundleName()) != null && (bundle = ResourceBundle.getBundle(analyserResourceBundleName, locale, resourceBundleClassLoader)).containsKey(key)) {
            analyserClassName = bundle.getString(key);
        }
        if (analyserClassName == null && (analyserResourceBundleName = this.getModel().getAnalyserResourceBundleName()) != null && (bundle = ResourceBundle.getBundle(analyserResourceBundleName, locale, resourceBundleClassLoader)).containsKey(key)) {
            analyserClassName = bundle.getString(key);
        }
        if (analyserClassName == null) {
            analyserClassName = this.dataType.getDefaultAnalyserClassName();
        }
        return analyserClassName;
    }
}

