/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene;

import com.werken.saxpath.XPathReader;
import java.util.List;
import java.util.Locale;
import org.alfresco.repo.dictionary.IndexTokenisationMode;
import org.alfresco.repo.search.MLAnalysisMode;
import org.alfresco.repo.search.impl.lucene.AbstractLuceneQueryParser;
import org.alfresco.repo.search.impl.lucene.AnalysisMode;
import org.alfresco.repo.search.impl.lucene.LuceneFunction;
import org.alfresco.repo.search.impl.lucene.LuceneXPathHandler;
import org.alfresco.repo.search.impl.lucene.query.CaseInsensitiveFieldQuery;
import org.alfresco.repo.search.impl.lucene.query.CaseInsensitiveFieldRangeQuery;
import org.alfresco.repo.search.impl.lucene.query.PathQuery;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.CharStream;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.queryParser.QueryParserTokenManager;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.saxpath.SAXPathException;
import org.saxpath.XPathHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneQueryParser
extends AbstractLuceneQueryParser {
    private static Log s_logger = LogFactory.getLog(LuceneQueryParser.class);

    public static Query parse(String query, String field, Analyzer analyzer, NamespacePrefixResolver namespacePrefixResolver, DictionaryService dictionaryService, TenantService tenantService, QueryParser.Operator defaultOperator, SearchParameters searchParameters, MLAnalysisMode defaultSearchMLAnalysisMode, IndexReader indexReader) throws ParseException {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Using Alfresco Lucene Query Parser for query: " + query));
        }
        LuceneQueryParser parser = new LuceneQueryParser(field, analyzer);
        parser.setDefaultOperator(defaultOperator);
        parser.setNamespacePrefixResolver(namespacePrefixResolver);
        parser.setDictionaryService(dictionaryService);
        parser.setTenantService(tenantService);
        parser.setSearchParameters(searchParameters);
        parser.setDefaultSearchMLAnalysisMode(defaultSearchMLAnalysisMode);
        parser.setIndexReader(indexReader);
        parser.setAllowLeadingWildcard(true);
        Query result = parser.parse(query);
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Query " + query + "                             is\n\t" + result.toString()));
        }
        return result;
    }

    public LuceneQueryParser(String arg0, Analyzer arg1) {
        super(arg0, arg1);
    }

    public LuceneQueryParser(CharStream arg0) {
        super(arg0);
    }

    public LuceneQueryParser(QueryParserTokenManager arg0) {
        super(arg0);
    }

    @Override
    protected Query createAclIdQuery(String queryText) throws ParseException {
        return this.createNoMatchQuery();
    }

    @Override
    protected Query createOwnerQuery(String queryText) throws ParseException {
        return this.createNoMatchQuery();
    }

    @Override
    protected Query createReaderQuery(String queryText) throws ParseException {
        return this.createNoMatchQuery();
    }

    @Override
    protected Query createAuthorityQuery(String queryText) throws ParseException {
        return this.createNoMatchQuery();
    }

    @Override
    protected Query createAssocTypeQNameQuery(String queryText) throws SAXPathException {
        BooleanQuery booleanQuery = new BooleanQuery();
        XPathReader reader = new XPathReader();
        LuceneXPathHandler handler = new LuceneXPathHandler();
        handler.setNamespacePrefixResolver(this.namespacePrefixResolver);
        handler.setDictionaryService(this.dictionaryService);
        reader.setXPathHandler((XPathHandler)handler);
        reader.parse("//" + queryText);
        PathQuery query = handler.getQuery();
        query.setPathField("PATH");
        query.setQnameField("ASSOCTYPEQNAME");
        booleanQuery.add((Query)query, BooleanClause.Occur.SHOULD);
        booleanQuery.add(this.createPrimaryAssocTypeQNameQuery(queryText), BooleanClause.Occur.SHOULD);
        return booleanQuery;
    }

    @Override
    protected Query createPrimaryAssocTypeQNameQuery(String queryText) throws SAXPathException {
        XPathReader reader = new XPathReader();
        LuceneXPathHandler handler = new LuceneXPathHandler();
        handler.setNamespacePrefixResolver(this.namespacePrefixResolver);
        handler.setDictionaryService(this.dictionaryService);
        reader.setXPathHandler((XPathHandler)handler);
        reader.parse("//" + queryText);
        PathQuery query = handler.getQuery();
        query.setPathField("PATH");
        query.setQnameField("PRIMARYASSOCTYPEQNAME");
        return query;
    }

    @Override
    protected Query createQNameQuery(String queryText) throws SAXPathException {
        XPathReader reader = new XPathReader();
        LuceneXPathHandler handler = new LuceneXPathHandler();
        handler.setNamespacePrefixResolver(this.namespacePrefixResolver);
        handler.setDictionaryService(this.dictionaryService);
        reader.setXPathHandler((XPathHandler)handler);
        reader.parse(queryText);
        PathQuery query = handler.getQuery();
        if (query.getPathStructuredFieldPositions().size() == 0 && query.getQNameStructuredFieldPositions().size() == 2 && query.getQNameStructuredFieldPositions().get(0).getTermText().equals("<No Namespace>")) {
            return this.createTermQuery("QNAME", queryText);
        }
        return this.createPathQuery("//" + queryText, false);
    }

    @Override
    protected Query createPathQuery(String queryText, boolean withRepeats) throws SAXPathException {
        XPathReader reader = new XPathReader();
        LuceneXPathHandler handler = new LuceneXPathHandler();
        handler.setNamespacePrefixResolver(this.namespacePrefixResolver);
        handler.setDictionaryService(this.dictionaryService);
        reader.setXPathHandler((XPathHandler)handler);
        reader.parse(queryText);
        PathQuery pathQuery = handler.getQuery();
        pathQuery.setRepeats(withRepeats);
        return pathQuery;
    }

    @Override
    protected void addTextRange(String field, String part1, String part2, boolean includeLower, boolean includeUpper, AnalysisMode analysisMode, String fieldName, PropertyDefinition propertyDef, IndexTokenisationMode tokenisationMode, BooleanQuery booleanQuery, MLAnalysisMode mlAnalysisMode, Locale locale) throws ParseException {
        IndexTokenisationMode tm;
        String textFieldName = fieldName;
        if ((analysisMode == AnalysisMode.IDENTIFIER || analysisMode == AnalysisMode.LIKE) && (tm = propertyDef.getIndexTokenisationMode()) != null && tm == IndexTokenisationMode.BOTH) {
            textFieldName = locale.toString().length() == 0 ? textFieldName + ".no_locale" : textFieldName + "." + locale + ".sort";
        }
        block0 : switch (tokenisationMode) {
            case BOTH: {
                switch (analysisMode) {
                    case DEFAULT: 
                    case TOKENISE: {
                        this.addLocaleSpecificTokenisedTextRange(part1, part2, includeLower, includeUpper, analysisMode, fieldName, booleanQuery, locale, textFieldName);
                        break block0;
                    }
                    case IDENTIFIER: {
                        this.addLocaleSpecificUntokenisedTextRange(field, part1, part2, includeLower, includeUpper, booleanQuery, mlAnalysisMode, locale, textFieldName);
                        break block0;
                    }
                }
                throw new UnsupportedOperationException();
            }
            case FALSE: {
                this.addLocaleSpecificUntokenisedTextRange(field, part1, part2, includeLower, includeUpper, booleanQuery, mlAnalysisMode, locale, textFieldName);
                break;
            }
            case TRUE: {
                this.addLocaleSpecificTokenisedTextRange(part1, part2, includeLower, includeUpper, analysisMode, fieldName, booleanQuery, locale, textFieldName);
                break;
            }
        }
    }

    @Override
    protected void addLocaleSpecificUntokenisedTextRangeFunction(String expandedFieldName, String lower, String upper, boolean includeLower, boolean includeUpper, LuceneFunction luceneFunction, BooleanQuery booleanQuery, MLAnalysisMode mlAnalysisMode, Locale locale, IndexTokenisationMode tokenisationMode) {
        if (locale.toString().length() == 0) {
            return;
        }
        String textFieldName = expandedFieldName;
        if (tokenisationMode == IndexTokenisationMode.BOTH) {
            textFieldName = textFieldName + "." + locale + ".sort";
        }
        String lowerTermText = lower;
        if (locale.toString().length() > 0) {
            lowerTermText = "{" + locale + "}" + lower;
        }
        String upperTermText = upper;
        if (locale.toString().length() > 0) {
            upperTermText = "{" + locale + "}" + upper;
        }
        Query subQuery = this.buildRangeFunctionQuery(textFieldName, lowerTermText, upperTermText, includeLower, includeUpper, luceneFunction);
        booleanQuery.add(subQuery, BooleanClause.Occur.SHOULD);
        if (booleanQuery.getClauses().length == 0) {
            booleanQuery.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
        }
    }

    private Query buildRangeFunctionQuery(String expandedFieldName, String lowerTermText, String upperTermText, boolean includeLower, boolean includeUpper, LuceneFunction luceneFunction) {
        String testUpperTermText;
        String testLowerTermText = lowerTermText;
        if (testLowerTermText.startsWith("{")) {
            int index = lowerTermText.indexOf("}");
            testLowerTermText = lowerTermText.substring(index + 1);
        }
        if ((testUpperTermText = upperTermText).startsWith("{")) {
            int index = upperTermText.indexOf("}");
            testUpperTermText = upperTermText.substring(index + 1);
        }
        switch (luceneFunction) {
            case LOWER: {
                if (testLowerTermText.equals(testLowerTermText.toLowerCase()) && testUpperTermText.equals(testUpperTermText.toLowerCase())) {
                    return new CaseInsensitiveFieldRangeQuery(expandedFieldName, lowerTermText, upperTermText, includeLower, includeUpper);
                }
                return this.createNoMatchQuery();
            }
            case UPPER: {
                if (testLowerTermText.equals(testLowerTermText.toUpperCase()) && testUpperTermText.equals(testUpperTermText.toUpperCase())) {
                    return new CaseInsensitiveFieldRangeQuery(expandedFieldName, lowerTermText, upperTermText, includeLower, includeUpper);
                }
                return this.createNoMatchQuery();
            }
        }
        throw new UnsupportedOperationException("Unsupported Lucene Function " + (Object)((Object)luceneFunction));
    }

    private void addLocaleSpecificTokenisedTextRange(String part1, String part2, boolean includeLower, boolean includeUpper, AnalysisMode analysisMode, String fieldName, BooleanQuery booleanQuery, Locale locale, String textFieldName) throws ParseException {
        StringBuilder builder = new StringBuilder();
        builder.append("\u0000").append(locale.toString()).append("\u0000").append(part1);
        String first = this.getToken(fieldName, builder.toString(), analysisMode);
        builder = new StringBuilder();
        builder.append("\u0000").append(locale.toString()).append("\u0000").append(part2);
        String last = this.getToken(fieldName, builder.toString(), analysisMode);
        ConstantScoreRangeQuery query = new ConstantScoreRangeQuery(textFieldName, first, last, includeLower, includeUpper);
        booleanQuery.add((Query)query, BooleanClause.Occur.SHOULD);
    }

    private void addLocaleSpecificUntokenisedTextRange(String field, String part1, String part2, boolean includeLower, boolean includeUpper, BooleanQuery booleanQuery, MLAnalysisMode mlAnalysisMode, Locale locale, String textFieldName) {
        if (locale.toString().length() > 0) {
            String lower = "{" + locale + "}" + part1;
            String upper = "{" + locale + "}" + part2;
            ConstantScoreRangeQuery subQuery = new ConstantScoreRangeQuery(textFieldName, lower, upper, includeLower, includeUpper);
            booleanQuery.add((Query)subQuery, BooleanClause.Occur.SHOULD);
            if (booleanQuery.getClauses().length == 0) {
                booleanQuery.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
            }
        } else if (part1.compareTo("{") > 0 || part2.compareTo("{") < 0) {
            ConstantScoreRangeQuery subQuery = new ConstantScoreRangeQuery(textFieldName, part1, part2, includeLower, includeUpper);
            booleanQuery.add((Query)subQuery, BooleanClause.Occur.SHOULD);
            if (booleanQuery.getClauses().length == 0) {
                booleanQuery.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
            }
        } else {
            BooleanQuery splitQuery = new BooleanQuery();
            ConstantScoreRangeQuery lowerQuery = new ConstantScoreRangeQuery(textFieldName, part1, "{", includeLower, false);
            ConstantScoreRangeQuery upperQuery = new ConstantScoreRangeQuery(textFieldName, "|", part2, true, includeUpper);
            splitQuery.add((Query)lowerQuery, BooleanClause.Occur.SHOULD);
            splitQuery.add((Query)upperQuery, BooleanClause.Occur.SHOULD);
            booleanQuery.add((Query)splitQuery, BooleanClause.Occur.SHOULD);
            if (booleanQuery.getClauses().length == 0) {
                booleanQuery.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
            }
        }
    }

    @Override
    protected void addLocaleSpecificUntokenisedMLOrTextFunction(String expandedFieldName, String queryText, LuceneFunction luceneFunction, BooleanQuery booleanQuery, MLAnalysisMode mlAnalysisMode, Locale locale, IndexTokenisationMode tokenisationMode) {
        String textFieldName = expandedFieldName;
        if (tokenisationMode == IndexTokenisationMode.BOTH) {
            textFieldName = locale.toString().length() == 0 ? textFieldName + ".no_locale" : textFieldName + "." + locale + ".sort";
        }
        String termText = queryText;
        if (locale.toString().length() > 0) {
            termText = "{" + locale + "}" + queryText;
        }
        Query subQuery = this.buildFunctionQuery(textFieldName, termText, luceneFunction);
        booleanQuery.add(subQuery, BooleanClause.Occur.SHOULD);
        if (booleanQuery.getClauses().length == 0) {
            booleanQuery.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
        }
    }

    private void addLocaleSpecificUntokenisedMLOrTextAttribute(String sourceField, String queryText, AbstractLuceneQueryParser.SubQuery subQueryBuilder, AnalysisMode analysisMode, LuceneFunction luceneFunction, BooleanQuery booleanQuery, MLAnalysisMode mlAnalysisMode, Locale locale, String actualField) throws ParseException {
        String termText = queryText;
        if (locale.toString().length() > 0) {
            termText = "{" + locale + "}" + queryText;
        }
        Query subQuery = subQueryBuilder.getQuery(actualField, termText, analysisMode, luceneFunction);
        booleanQuery.add(subQuery, BooleanClause.Occur.SHOULD);
        if (booleanQuery.getClauses().length == 0) {
            booleanQuery.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
        }
    }

    private void addLocaleSpecificTokenisedMLOrTextAttribute(String queryText, AbstractLuceneQueryParser.SubQuery subQueryBuilder, AnalysisMode analysisMode, LuceneFunction luceneFunction, BooleanQuery booleanQuery, Locale locale, String actualField) throws ParseException {
        StringBuilder builder = new StringBuilder(queryText.length() + 10);
        builder.append("\u0000").append(locale.toString()).append("\u0000").append(queryText);
        Query subQuery = subQueryBuilder.getQuery(actualField, builder.toString(), analysisMode, luceneFunction);
        if (subQuery != null) {
            booleanQuery.add(subQuery, BooleanClause.Occur.SHOULD);
        } else {
            booleanQuery.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
        }
    }

    private Query buildFunctionQuery(String expandedFieldName, String termText, LuceneFunction luceneFunction) {
        String testText = termText;
        if (termText.startsWith("{")) {
            int index = termText.indexOf("}");
            testText = termText.substring(index + 1);
        }
        switch (luceneFunction) {
            case LOWER: {
                if (testText.equals(testText.toLowerCase())) {
                    return new CaseInsensitiveFieldQuery(new Term(expandedFieldName, termText));
                }
                return this.createNoMatchQuery();
            }
            case UPPER: {
                if (testText.equals(testText.toUpperCase())) {
                    return new CaseInsensitiveFieldQuery(new Term(expandedFieldName, termText));
                }
                return this.createNoMatchQuery();
            }
        }
        throw new UnsupportedOperationException("Unsupported Lucene Function " + (Object)((Object)luceneFunction));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void addMLTextAttributeQuery(String field, String queryText, AbstractLuceneQueryParser.SubQuery subQueryBuilder, AnalysisMode analysisMode, LuceneFunction luceneFunction, String expandedFieldName, PropertyDefinition propertyDef, IndexTokenisationMode tokenisationMode, BooleanQuery booleanQuery, MLAnalysisMode mlAnalysisMode, Locale locale) throws ParseException {
        IndexTokenisationMode tm;
        String mlFieldName = expandedFieldName;
        if (tokenisationMode == IndexTokenisationMode.BOTH && (analysisMode == AnalysisMode.IDENTIFIER || analysisMode == AnalysisMode.LIKE) && (tm = propertyDef.getIndexTokenisationMode()) != null && tm == IndexTokenisationMode.BOTH) {
            mlFieldName = locale.toString().length() == 0 ? mlFieldName + ".no_locale" : mlFieldName + "." + locale + ".sort";
        }
        boolean lowercaseExpandedTerms = this.getLowercaseExpandedTerms();
        try {
            switch (tokenisationMode) {
                case BOTH: {
                    switch (analysisMode) {
                        default: {
                            this.addLocaleSpecificTokenisedMLOrTextAttribute(queryText, subQueryBuilder, analysisMode, luceneFunction, booleanQuery, locale, expandedFieldName);
                            return;
                        }
                        case IDENTIFIER: 
                        case WILD: 
                        case LIKE: 
                        case PREFIX: 
                        case FUZZY: 
                    }
                    this.setLowercaseExpandedTerms(false);
                    this.addLocaleSpecificUntokenisedMLOrTextAttribute(field, queryText, subQueryBuilder, analysisMode, luceneFunction, booleanQuery, mlAnalysisMode, locale, mlFieldName);
                    return;
                }
                case FALSE: {
                    this.setLowercaseExpandedTerms(false);
                    this.addLocaleSpecificUntokenisedMLOrTextAttribute(field, queryText, subQueryBuilder, analysisMode, luceneFunction, booleanQuery, mlAnalysisMode, locale, mlFieldName);
                    return;
                }
                default: {
                    switch (analysisMode) {
                        default: {
                            this.addLocaleSpecificTokenisedMLOrTextAttribute(queryText, subQueryBuilder, analysisMode, luceneFunction, booleanQuery, locale, expandedFieldName);
                            return;
                        }
                        case WILD: 
                        case LIKE: 
                        case PREFIX: 
                        case FUZZY: 
                    }
                    this.addLocaleSpecificUntokenisedMLOrTextAttribute(field, queryText, subQueryBuilder, analysisMode, luceneFunction, booleanQuery, mlAnalysisMode, locale, mlFieldName);
                    return;
                }
            }
        }
        finally {
            this.setLowercaseExpandedTerms(lowercaseExpandedTerms);
        }
    }

    @Override
    protected Query addContentAttributeQuery(String queryText, AbstractLuceneQueryParser.SubQuery subQueryBuilder, AnalysisMode analysisMode, LuceneFunction luceneFunction, String expandedFieldName, List<Locale> expandedLocales, MLAnalysisMode mlAnalysisMode) throws ParseException {
        if (mlAnalysisMode.includesAll()) {
            return subQueryBuilder.getQuery(expandedFieldName, queryText, analysisMode, luceneFunction);
        }
        if (expandedLocales.size() > 0) {
            BooleanQuery booleanQuery = new BooleanQuery();
            Query contentQuery = subQueryBuilder.getQuery(expandedFieldName, queryText, analysisMode, luceneFunction);
            if (contentQuery != null) {
                booleanQuery.add(contentQuery, BooleanClause.Occur.MUST);
                BooleanQuery subQuery = new BooleanQuery();
                for (Locale locale : expandedLocales) {
                    Query localeQuery;
                    StringBuilder builder = new StringBuilder();
                    builder.append(expandedFieldName).append(".locale");
                    String localeString = locale.toString();
                    if (localeString.indexOf("*") == -1) {
                        localeQuery = this.getFieldQuery(builder.toString(), localeString);
                        if (localeQuery != null) {
                            subQuery.add(localeQuery, BooleanClause.Occur.SHOULD);
                            continue;
                        }
                        subQuery.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
                        continue;
                    }
                    localeQuery = this.getWildcardQuery(builder.toString(), localeString);
                    if (localeQuery != null) {
                        subQuery.add(localeQuery, BooleanClause.Occur.SHOULD);
                        continue;
                    }
                    subQuery.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
                }
                booleanQuery.add((Query)subQuery, BooleanClause.Occur.MUST);
            }
            return booleanQuery;
        }
        Query query = subQueryBuilder.getQuery(expandedFieldName, queryText, analysisMode, luceneFunction);
        if (query != null) {
            return query;
        }
        return this.createNoMatchQuery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void addTextAttributeQuery(String field, String queryText, AbstractLuceneQueryParser.SubQuery subQueryBuilder, AnalysisMode analysisMode, LuceneFunction luceneFunction, String expandedFieldName, IndexTokenisationMode tokenisationMode, BooleanQuery booleanQuery, MLAnalysisMode mlAnalysisMode, Locale locale) throws ParseException {
        String textFieldName = expandedFieldName;
        if (tokenisationMode == IndexTokenisationMode.BOTH && (analysisMode == AnalysisMode.IDENTIFIER || analysisMode == AnalysisMode.LIKE)) {
            textFieldName = null != locale && 0 == locale.toString().length() ? textFieldName + ".no_locale" : textFieldName + "." + locale + ".sort";
        }
        boolean lowercaseExpandedTerms = this.getLowercaseExpandedTerms();
        try {
            switch (tokenisationMode) {
                case BOTH: {
                    switch (analysisMode) {
                        default: {
                            this.addLocaleSpecificTokenisedMLOrTextAttribute(queryText, subQueryBuilder, analysisMode, luceneFunction, booleanQuery, locale, textFieldName);
                            return;
                        }
                        case IDENTIFIER: 
                        case WILD: 
                        case LIKE: 
                        case PREFIX: 
                        case FUZZY: 
                    }
                    this.setLowercaseExpandedTerms(false);
                    this.addLocaleSpecificUntokenisedMLOrTextAttribute(field, queryText, subQueryBuilder, analysisMode, luceneFunction, booleanQuery, mlAnalysisMode, locale, textFieldName);
                    return;
                }
                case FALSE: {
                    this.setLowercaseExpandedTerms(false);
                    this.addLocaleSpecificUntokenisedMLOrTextAttribute(field, queryText, subQueryBuilder, analysisMode, luceneFunction, booleanQuery, mlAnalysisMode, locale, textFieldName);
                    return;
                }
            }
            switch (analysisMode) {
                case DEFAULT: 
                case TOKENISE: 
                case IDENTIFIER: {
                    this.addLocaleSpecificTokenisedMLOrTextAttribute(queryText, subQueryBuilder, analysisMode, luceneFunction, booleanQuery, locale, expandedFieldName);
                    return;
                }
                case WILD: 
                case LIKE: 
                case PREFIX: 
                case FUZZY: {
                    this.addLocaleSpecificUntokenisedMLOrTextAttribute(field, queryText, subQueryBuilder, analysisMode, luceneFunction, booleanQuery, mlAnalysisMode, locale, textFieldName);
                    return;
                }
            }
            return;
        }
        finally {
            this.setLowercaseExpandedTerms(lowercaseExpandedTerms);
        }
    }

    @Override
    protected boolean isLucene() {
        return true;
    }

    @Override
    protected void addTextSpanQuery(String field, String first, String last, int slop, boolean inOrder, String expandedFieldName, IndexTokenisationMode tokenisationMode, BooleanQuery booleanQuery, MLAnalysisMode mlAnalysisMode, Locale locale) {
        SpanTermQuery firstTerm = new SpanTermQuery(new Term(field, first));
        SpanTermQuery lastTerm = new SpanTermQuery(new Term(field, last));
        SpanNearQuery result = new SpanNearQuery(new SpanQuery[]{firstTerm, lastTerm}, slop, inOrder);
        booleanQuery.add((Query)result, BooleanClause.Occur.SHOULD);
    }

    @Override
    protected Query addContentSpanQuery(String field, String first, String last, int slop, boolean inOrder, String expandedFieldName, List<Locale> expandedLocales, MLAnalysisMode mlAnalysisMode) {
        SpanTermQuery firstTerm = new SpanTermQuery(new Term(field, first));
        SpanTermQuery lastTerm = new SpanTermQuery(new Term(field, last));
        SpanNearQuery result = new SpanNearQuery(new SpanQuery[]{firstTerm, lastTerm}, slop, inOrder);
        return result;
    }

    @Override
    protected void addMLTextSpanQuery(String field, String first, String last, int slop, boolean inOrder, String expandedFieldName, PropertyDefinition propertyDef, IndexTokenisationMode tokenisationMode, BooleanQuery booleanQuery, MLAnalysisMode mlAnalysisMode, Locale locale) {
        SpanTermQuery firstTerm = new SpanTermQuery(new Term(field, first));
        SpanTermQuery lastTerm = new SpanTermQuery(new Term(field, last));
        SpanNearQuery result = new SpanNearQuery(new SpanQuery[]{firstTerm, lastTerm}, slop, inOrder);
        booleanQuery.add((Query)result, BooleanClause.Occur.SHOULD);
    }
}

