/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.querymodel.impl.functions;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.alfresco.repo.search.impl.querymodel.Argument;
import org.alfresco.repo.search.impl.querymodel.ArgumentDefinition;
import org.alfresco.repo.search.impl.querymodel.FunctionEvaluationContext;
import org.alfresco.repo.search.impl.querymodel.Multiplicity;
import org.alfresco.repo.search.impl.querymodel.impl.BaseArgumentDefinition;
import org.alfresco.repo.search.impl.querymodel.impl.BaseFunction;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Child
extends BaseFunction {
    public static final String NAME = "Child";
    public static final String ARG_PARENT = "Parent";
    public static final String ARG_SELECTOR = "Selector";
    public static LinkedHashMap<String, ArgumentDefinition> args = new LinkedHashMap();

    public Child() {
        super(NAME, DataTypeDefinition.BOOLEAN, args);
    }

    @Override
    public Serializable getValue(Map<String, Argument> args, FunctionEvaluationContext context) {
        Argument selectorArgument = args.get(ARG_SELECTOR);
        String selectorName = DefaultTypeConverter.INSTANCE.convert(String.class, (Object)selectorArgument.getValue(context));
        Argument parentArgument = args.get(ARG_PARENT);
        NodeRef parent = DefaultTypeConverter.INSTANCE.convert(NodeRef.class, (Object)parentArgument.getValue(context));
        NodeRef child = context.getNodeRefs().get(selectorName);
        for (ChildAssociationRef car : context.getNodeService().getParentAssocs(child)) {
            if (!car.getParentRef().equals(parent)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    static {
        args.put(ARG_PARENT, new BaseArgumentDefinition(Multiplicity.SINGLE_VALUED, ARG_PARENT, DataTypeDefinition.TEXT, true));
        args.put(ARG_SELECTOR, new BaseArgumentDefinition(Multiplicity.SINGLE_VALUED, ARG_SELECTOR, DataTypeDefinition.TEXT, false));
    }
}

