/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.querymodel.impl.lucene.functions;

import java.util.Map;
import java.util.Set;
import org.alfresco.repo.search.impl.lucene.AbstractLuceneQueryParser;
import org.alfresco.repo.search.impl.querymodel.Argument;
import org.alfresco.repo.search.impl.querymodel.FunctionEvaluationContext;
import org.alfresco.repo.search.impl.querymodel.PropertyArgument;
import org.alfresco.repo.search.impl.querymodel.impl.functions.FTSFuzzyTerm;
import org.alfresco.repo.search.impl.querymodel.impl.lucene.LuceneQueryBuilderComponent;
import org.alfresco.repo.search.impl.querymodel.impl.lucene.LuceneQueryBuilderContext;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneFTSFuzzyTerm
extends FTSFuzzyTerm
implements LuceneQueryBuilderComponent {
    @Override
    public Query addComponent(Set<String> selectors, Map<String, Argument> functionArgs, LuceneQueryBuilderContext luceneContext, FunctionEvaluationContext functionContext) throws ParseException {
        Query query;
        AbstractLuceneQueryParser lqp = luceneContext.getLuceneQueryParser();
        Argument argument = functionArgs.get("Term");
        String term = (String)((Object)argument.getValue(functionContext));
        argument = functionArgs.get("MinSimilarity");
        Float minSimilarity = (Float)argument.getValue(functionContext);
        PropertyArgument propArg = (PropertyArgument)functionArgs.get("Property");
        if (propArg != null) {
            String prop = propArg.getPropertyName();
            query = lqp.getFuzzyQuery(functionContext.getLuceneFieldName(prop), term, minSimilarity.floatValue());
        } else {
            query = lqp.getFuzzyQuery(lqp.getField(), term, minSimilarity.floatValue());
        }
        return query;
    }
}

