/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.security;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermissionContext {
    private QName type;
    private HashSet<QName> aspects = new HashSet();
    private Map<QName, Serializable> properties = new HashMap<QName, Serializable>();
    private Map<String, Set<String>> dynamicAuthorityAssignment = new HashMap<String, Set<String>>();
    private Map<String, Object> additionalContext = new HashMap<String, Object>();
    private Long storeAcl = null;

    public PermissionContext(QName type) {
        this.type = type;
    }

    public HashSet<QName> getAspects() {
        return this.aspects;
    }

    public Map<String, Set<String>> getDynamicAuthorityAssignment() {
        return this.dynamicAuthorityAssignment;
    }

    public void addDynamicAuthorityAssignment(String user, String dynamicAuthority) {
        Set<String> dynamicAuthorities = this.dynamicAuthorityAssignment.get(user);
        if (dynamicAuthorities == null) {
            dynamicAuthorities = new HashSet<String>();
            this.dynamicAuthorityAssignment.put(user, dynamicAuthorities);
        }
        dynamicAuthorities.add(dynamicAuthority);
    }

    public Map<String, Object> getAdditionalContext() {
        return this.additionalContext;
    }

    public Map<QName, Serializable> getProperties() {
        return this.properties;
    }

    public QName getType() {
        return this.type;
    }

    public Long getStoreAcl() {
        return this.storeAcl;
    }

    public void setStoreAcl(Long storeAcl) {
        this.storeAcl = storeAcl;
    }
}

