/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.springframework.extensions.surf.ModelObject;
import org.springframework.extensions.surf.ModelObjectService;
import org.springframework.extensions.surf.exception.ModelObjectPersisterException;
import org.springframework.extensions.surf.exception.PlatformRuntimeException;
import org.springframework.extensions.surf.types.Component;
import org.springframework.extensions.surf.types.Page;
import org.springframework.extensions.surf.util.XMLUtil;
import org.springframework.extensions.webscripts.SearchPath;
import org.springframework.extensions.webscripts.Store;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PresetsManager {
    private SearchPath searchPath;
    private List<String> files;
    private Document[] documents;
    private ModelObjectService modelObjectService;

    public void setModelObjectService(ModelObjectService modelObjectService) {
        this.modelObjectService = modelObjectService;
    }

    public void setSearchPath(SearchPath searchPath) {
        this.searchPath = searchPath;
    }

    public void setFiles(List<String> files) {
        this.files = files;
    }

    private void init() {
        if (this.searchPath == null || this.files == null) {
            throw new IllegalArgumentException("SearchPath and Files list are mandatory.");
        }
        ArrayList<Document> docs = new ArrayList<Document>(4);
        for (Store store : this.searchPath.getStores()) {
            for (String file : this.files) {
                try {
                    if (!store.hasDocument(file)) continue;
                    docs.add(XMLUtil.parse(store.getDocument(file)));
                }
                catch (IOException ioe) {
                    throw new PlatformRuntimeException("Error loading presets XML file: " + file + " in store: " + store.toString(), (Throwable)ioe);
                }
                catch (DocumentException de) {
                    de.printStackTrace();
                    throw new PlatformRuntimeException("Error processing presets XML file: " + file + " in store: " + store.toString(), (Throwable)de);
                }
            }
        }
        this.documents = docs.toArray(new Document[docs.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void constructPreset(String id, Map<String, String> tokens) {
        if (id == null) {
            throw new IllegalArgumentException("Preset ID is mandatory.");
        }
        PresetsManager presetsManager = this;
        synchronized (presetsManager) {
            if (this.documents == null) {
                this.init();
            }
        }
        boolean foundPreset = false;
        block9: for (int i = 0; !foundPreset && i < this.documents.length; ++i) {
            Iterator presets = this.documents[i].getRootElement().elements("preset").iterator();
            while (!foundPreset && presets.hasNext()) {
                Element templates;
                Object template;
                Element pages;
                Element preset = (Element)presets.next();
                if (!id.equals(preset.attributeValue("id"))) continue;
                foundPreset = true;
                Element components = preset.element("components");
                if (components != null) {
                    for (Element c : components.elements("component")) {
                        String title = PresetsManager.replace(c.elementTextTrim("title"), tokens);
                        String titleId = PresetsManager.replace(c.elementTextTrim("title-id"), tokens);
                        String description = PresetsManager.replace(c.elementTextTrim("description"), tokens);
                        String descriptionId = PresetsManager.replace(c.elementTextTrim("description-id"), tokens);
                        String typeId = PresetsManager.replace(c.elementTextTrim("component-type-id"), tokens);
                        String scope = PresetsManager.replace(c.elementTextTrim("scope"), tokens);
                        String regionId = PresetsManager.replace(c.elementTextTrim("region-id"), tokens);
                        String sourceId = PresetsManager.replace(c.elementTextTrim("source-id"), tokens);
                        String url = PresetsManager.replace(c.elementTextTrim("url"), tokens);
                        String uri = PresetsManager.replace(c.elementTextTrim("uri"), tokens);
                        String chrome = PresetsManager.replace(c.elementTextTrim("chrome"), tokens);
                        if (scope == null || scope.length() == 0) {
                            throw new IllegalArgumentException("Scope is a mandatory property for a component preset.");
                        }
                        if (regionId == null || regionId.length() == 0) {
                            throw new IllegalArgumentException("RegionID is a mandatory property for a component preset.");
                        }
                        if (sourceId == null || sourceId.length() == 0) {
                            throw new IllegalArgumentException("SourceID is a mandatory property for a component preset.");
                        }
                        Component component = this.modelObjectService.newComponent(scope, regionId, sourceId);
                        component.setComponentTypeId(typeId);
                        component.setTitle(title);
                        component.setTitleId(titleId);
                        component.setDescription(description);
                        component.setDescriptionId(descriptionId);
                        component.setURL(url);
                        component.setURI(uri);
                        component.setChrome(chrome);
                        if (c.element("properties") != null) {
                            for (Element prop : c.element("properties").elements()) {
                                String propName = PresetsManager.replace(prop.getName(), tokens);
                                String propValue = PresetsManager.replace(prop.getTextTrim(), tokens);
                                component.setCustomProperty(propName, propValue);
                            }
                        }
                        try {
                            this.modelObjectService.saveObject(component);
                        }
                        catch (ModelObjectPersisterException e) {
                            e.printStackTrace();
                        }
                    }
                }
                if ((pages = preset.element("pages")) != null) {
                    for (Element p : pages.elements("page")) {
                        String pageId = PresetsManager.replace(p.attributeValue("id"), tokens);
                        String title = PresetsManager.replace(p.elementTextTrim("title"), tokens);
                        String titleId = PresetsManager.replace(p.elementTextTrim("title-id"), tokens);
                        String description = PresetsManager.replace(p.elementTextTrim("description"), tokens);
                        String descriptionId = PresetsManager.replace(p.elementTextTrim("description-id"), tokens);
                        String typeId = PresetsManager.replace(p.elementTextTrim("page-type-id"), tokens);
                        String auth = PresetsManager.replace(p.elementTextTrim("authentication"), tokens);
                        template = PresetsManager.replace(p.elementTextTrim("template-instance"), tokens);
                        if (pageId == null || pageId.length() == 0) {
                            throw new IllegalArgumentException("ID is a mandatory attribute for a page preset.");
                        }
                        if (template == null || ((String)template).length() == 0) {
                            throw new IllegalArgumentException("Template is a mandatory property for a page preset.");
                        }
                        Page page = this.modelObjectService.newPage(pageId);
                        page.setPageTypeId(typeId);
                        page.setTitle(title);
                        page.setTitleId(titleId);
                        page.setDescription(description);
                        page.setDescriptionId(descriptionId);
                        page.setAuthentication(auth);
                        page.setTemplateId((String)template);
                        if (p.element("properties") != null) {
                            for (Element prop : p.element("properties").elements()) {
                                String propName = PresetsManager.replace(prop.getName(), tokens);
                                String propValue = PresetsManager.replace(prop.getTextTrim(), tokens);
                                page.setCustomProperty(propName, propValue);
                            }
                        }
                        try {
                            this.modelObjectService.saveObject(page);
                        }
                        catch (ModelObjectPersisterException e) {
                            e.printStackTrace();
                        }
                    }
                }
                if ((templates = preset.element("template-instances")) == null) continue block9;
                for (Element t : templates.elements("template-instance")) {
                    String templateId = PresetsManager.replace(t.attributeValue("id"), tokens);
                    String title = PresetsManager.replace(t.elementTextTrim("title"), tokens);
                    String titleId = PresetsManager.replace(t.elementTextTrim("title-id"), tokens);
                    String description = PresetsManager.replace(t.elementTextTrim("description"), tokens);
                    String descriptionId = PresetsManager.replace(t.elementTextTrim("description-id"), tokens);
                    String templateType = PresetsManager.replace(t.elementTextTrim("template-type"), tokens);
                    if (templateId == null || templateId.length() == 0) {
                        throw new IllegalArgumentException("ID is a mandatory attribute for a template-instance preset.");
                    }
                    if (templateType == null || templateType.length() == 0) {
                        throw new IllegalArgumentException("Template is a mandatory property for a page preset.");
                    }
                    template = this.modelObjectService.newTemplate(templateId);
                    template.setTitle(title);
                    template.setTitleId(titleId);
                    template.setDescription(description);
                    template.setDescriptionId(descriptionId);
                    template.setTemplateTypeId(templateType);
                    if (t.element("properties") != null) {
                        for (Element prop : t.element("properties").elements()) {
                            String propName = PresetsManager.replace(prop.getName(), tokens);
                            String propValue = PresetsManager.replace(prop.getTextTrim(), tokens);
                            template.setCustomProperty(propName, propValue);
                        }
                    }
                    try {
                        this.modelObjectService.saveObject((ModelObject)template);
                    }
                    catch (ModelObjectPersisterException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private static String replace(String s, Map<String, String> tokens) {
        if (s != null && tokens != null) {
            for (Map.Entry<String, String> entry : tokens.entrySet()) {
                String key = "${" + entry.getKey() + "}";
                String value = entry.getValue();
                if (s.indexOf(key) == -1 || value == null) continue;
                s = s.replace(key, value);
            }
        }
        return s;
    }
}

