/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public class ServletUtil {
    public static final String VIEW_REQUEST_ATTRIBUTE_NAME = "surfViewHttpServletRequest";

    public static void setRequest(HttpServletRequest request) {
        RequestAttributes attributes = RequestContextHolder.getRequestAttributes();
        if (attributes != null) {
            attributes.setAttribute(VIEW_REQUEST_ATTRIBUTE_NAME, (Object)request, 0);
        }
    }

    public static HttpServletRequest getRequest() {
        Object tmp;
        HttpServletRequest request = null;
        RequestAttributes attributes = RequestContextHolder.getRequestAttributes();
        if (attributes != null && (tmp = attributes.getAttribute(VIEW_REQUEST_ATTRIBUTE_NAME, 0)) instanceof HttpServletRequest) {
            request = (HttpServletRequest)tmp;
        }
        return request;
    }

    public static HttpSession getSession() {
        return ServletUtil.getSession(true);
    }

    public static HttpSession getSession(boolean create) {
        HttpSession session = null;
        HttpServletRequest request = ServletUtil.getRequest();
        if (request != null) {
            session = request.getSession(create);
        }
        return session;
    }
}

