/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.extensibility.impl;

import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import org.springframework.extensions.surf.extensibility.ExtensibilityDirective;
import org.springframework.extensions.surf.extensibility.ExtensibilityDirectiveData;
import org.springframework.extensions.surf.extensibility.ExtensibilityModel;
import org.springframework.extensions.surf.extensibility.impl.DefaultExtensibilityDirectiveData;
import org.springframework.extensions.webscripts.AbstractFreeMarkerDirective;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExtensibilityDirective
extends AbstractFreeMarkerDirective
implements ExtensibilityDirective {
    public static final String DIRECTIVE_ID = "id";
    public static final String TARGET = "target";
    public static final String ACTION = "action";
    public static final String ACTION_MERGE = "merge";
    public static final String ACTION_REPLACE = "replace";
    public static final String ACTION_REMOVE = "remove";
    public static final String ACTION_MODIFY = "modify";
    public static final String ACTION_BEFORE = "before";
    public static final String ACTION_AFTER = "after";
    private ExtensibilityModel model;
    private String id;

    public String getId() {
        return this.id;
    }

    public ExtensibilityModel getModel() {
        return this.model;
    }

    public AbstractExtensibilityDirective(String directiveName, ExtensibilityModel model) {
        super(directiveName);
        this.model = model;
    }

    public ExtensibilityDirectiveData createExtensibilityDirectiveData(String id, String action, String target, Map params, TemplateDirectiveBody body, Environment env) throws TemplateException {
        return new DefaultExtensibilityDirectiveData(id, action, target, this.getDirectiveName(), body, env);
    }

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        this.id = this.getStringProperty(params, DIRECTIVE_ID, false);
        if (this.id == null) {
            this.id = UUID.randomUUID().toString();
        }
        String action = this.getStringProperty(params, ACTION, false);
        String target = this.getStringProperty(params, TARGET, false);
        ExtensibilityDirectiveData directiveData = this.createExtensibilityDirectiveData(this.id, action, target, params, body, env);
        if (action == null || action.equals(ACTION_MERGE)) {
            this.merge(directiveData, params);
        } else if (action.equals(ACTION_BEFORE)) {
            this.before(directiveData);
        } else if (action.equals(ACTION_AFTER)) {
            this.after(directiveData);
        } else if (action.equals(ACTION_REMOVE)) {
            this.remove(directiveData);
        } else if (action.equals(ACTION_REPLACE)) {
            this.replace(directiveData);
        }
    }

    public void merge(ExtensibilityDirectiveData directiveData, Map<String, Object> params) throws TemplateException, IOException {
        this.model.merge(directiveData);
    }

    public void before(ExtensibilityDirectiveData directiveData) throws TemplateException, IOException {
        this.model.before(directiveData);
    }

    public void after(ExtensibilityDirectiveData directiveData) throws TemplateException, IOException {
        this.model.after(directiveData);
    }

    public void remove(ExtensibilityDirectiveData directiveData) throws TemplateException, IOException {
        this.model.remove(directiveData);
    }

    public void replace(ExtensibilityDirectiveData directiveData) throws TemplateException, IOException {
        this.model.replace(directiveData);
    }
}

