/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.extensibility.impl;

import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.extensibility.ContentModelElement;
import org.springframework.extensions.surf.extensibility.ExtensibilityDirectiveData;
import org.springframework.extensions.surf.extensibility.ExtensibilityModel;
import org.springframework.extensions.surf.extensibility.impl.AbstractExtensibilityDirective;
import org.springframework.extensions.surf.extensibility.impl.JavaScriptContentModelElement;
import org.springframework.extensions.surf.extensibility.impl.JavaScriptDirectiveData;
import org.springframework.extensions.surf.extensibility.impl.ModelWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaScriptDirective
extends AbstractExtensibilityDirective {
    private static final Log logger = LogFactory.getLog(JavaScriptDirective.class);
    public static final String JAVASCRIPT_TYPE = "type";
    private String javaScriptType = null;

    public JavaScriptDirective(String directiveName, ExtensibilityModel extModel) {
        super(directiveName, extModel);
    }

    @Override
    public ExtensibilityDirectiveData createExtensibilityDirectiveData(String id, String action, String target, Map params, TemplateDirectiveBody body, Environment env) {
        return new JavaScriptDirectiveData(id, action, target, body, env);
    }

    @Override
    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        this.javaScriptType = this.getStringProperty(params, JAVASCRIPT_TYPE, false);
        super.execute(env, params, loopVars, body);
    }

    private JavaScriptContentModelElement findContentInModel(String id) {
        JavaScriptContentModelElement targetContent = null;
        ExtensibilityModel model = this.getModel();
        ContentModelElement content = model.findContentModelElement(id);
        if (content != null && content instanceof JavaScriptContentModelElement) {
            targetContent = (JavaScriptContentModelElement)content;
        }
        return targetContent;
    }

    @Override
    public void merge(ExtensibilityDirectiveData directiveData, Map<String, Object> params) throws TemplateException, IOException {
        super.merge(directiveData, params);
        JavaScriptContentModelElement content = this.findContentInModel(directiveData.getId());
        if (content != null) {
            if (this.javaScriptType != null) {
                content.setJavaScriptType(this.javaScriptType);
            } else if (logger.isErrorEnabled()) {
                logger.error((Object)("No 'type' provided for: " + directiveData));
            }
        }
    }

    public void modify(ExtensibilityDirectiveData directiveData) throws TemplateException, IOException {
        ExtensibilityModel model = this.getModel();
        if (model.isExtensionProcessing()) {
            JavaScriptContentModelElement content = this.findContentInModel(directiveData.getId());
            if (content != null) {
                ModelWriter modelWriter = model.getWriter();
                modelWriter.setCurrentBufferElement(content.getNextContentBufferElement());
                directiveData.getBody().render((Writer)modelWriter);
                if (this.javaScriptType != null) {
                    content.setJavaScriptType(this.javaScriptType);
                }
            }
        } else if (logger.isErrorEnabled()) {
            logger.error((Object)"It is not possible to modify content in base directives, only in extensions to those directives");
        }
    }
}

