/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.extensibility.impl;

import freemarker.core.Environment;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateModelException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.extensibility.impl.BasicExtensibilityModuleHandler;
import org.springframework.extensions.surf.extensibility.impl.JSONMergingContentModelElement;

public class WidgetContentModelElement
extends JSONMergingContentModelElement {
    private static final Log logger = LogFactory.getLog(BasicExtensibilityModuleHandler.class);
    public static final String TYPE = "WIDGET_CONTENT";
    private Environment env = null;
    private String widgetType = null;

    public WidgetContentModelElement(String id, String directiveName, Environment env) {
        super(id, directiveName);
        this.env = env;
    }

    public String getWidgetType() {
        return this.widgetType;
    }

    public void setWidgetType(String widgetType) {
        this.widgetType = widgetType;
    }

    public String flushContent() {
        String htmlId;
        block4: {
            htmlId = "";
            try {
                htmlId = ((SimpleScalar)this.env.getDataModel().get("htmlid")).toString();
            }
            catch (NullPointerException e) {
                if (logger.isErrorEnabled()) {
                    logger.error((Object)("The following error occurred flushing the content from Widget directive: " + this.getId()), (Throwable)e);
                }
            }
            catch (TemplateModelException e) {
                if (!logger.isErrorEnabled()) break block4;
                logger.error((Object)("The following error occurred flushing the content from Widget directive: " + this.getId()), (Throwable)e);
            }
        }
        StringBuilder toFlush = new StringBuilder();
        toFlush.append("<script type=\"text/javascript\">\n");
        toFlush.append("   var _widgetConfig = " + this.jsonMerge() + ";\n");
        toFlush.append("   var _widget = new " + this.getWidgetType() + "(\"" + this.getId() + "\", \"" + htmlId + "\").init(_widgetConfig);\n");
        toFlush.append("   document.write(_widget.render())\n");
        toFlush.append("   _widget.start();\n");
        toFlush.append("</script>\n\n");
        return toFlush.toString();
    }

    public String getType() {
        return TYPE;
    }
}

