/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.extensibility.impl;

import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.extensibility.ContentModelElement;
import org.springframework.extensions.surf.extensibility.ExtensibilityDirectiveData;
import org.springframework.extensions.surf.extensibility.ExtensibilityModel;
import org.springframework.extensions.surf.extensibility.impl.AbstractExtensibilityDirective;
import org.springframework.extensions.surf.extensibility.impl.ModelWriter;
import org.springframework.extensions.surf.extensibility.impl.WidgetContentModelElement;
import org.springframework.extensions.surf.extensibility.impl.WidgetDirectiveData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WidgetDirective
extends AbstractExtensibilityDirective {
    private static final Log logger = LogFactory.getLog(WidgetDirective.class);
    public static final String WIDGET_TYPE = "type";
    private String widgetType = null;

    public WidgetDirective(String directiveName, ExtensibilityModel model) {
        super(directiveName, model);
    }

    @Override
    public ExtensibilityDirectiveData createExtensibilityDirectiveData(String id, String action, String target, Map params, TemplateDirectiveBody body, Environment env) {
        return new WidgetDirectiveData(id, action, target, body, env);
    }

    @Override
    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        this.widgetType = this.getStringProperty(params, WIDGET_TYPE, false);
        super.execute(env, params, loopVars, body);
    }

    private WidgetContentModelElement findContentInModel(String id) {
        WidgetContentModelElement targetContent = null;
        ExtensibilityModel model = this.getModel();
        ContentModelElement content = model.findContentModelElement(id);
        if (content != null && content instanceof WidgetContentModelElement) {
            targetContent = (WidgetContentModelElement)content;
        }
        return targetContent;
    }

    @Override
    public void merge(ExtensibilityDirectiveData directiveData, Map<String, Object> params) throws TemplateException, IOException {
        super.merge(directiveData, params);
        WidgetContentModelElement content = this.findContentInModel(directiveData.getId());
        if (content != null) {
            if (this.widgetType != null) {
                content.setWidgetType(this.widgetType);
            } else if (logger.isErrorEnabled()) {
                logger.error((Object)("No 'type' provided for: " + directiveData));
            }
        }
    }

    public void modify(ExtensibilityDirectiveData directiveData) throws TemplateException, IOException {
        ExtensibilityModel model = this.getModel();
        if (model.isExtensionProcessing()) {
            WidgetContentModelElement content = this.findContentInModel(directiveData.getId());
            if (content != null) {
                ModelWriter modelWriter = model.getWriter();
                modelWriter.setCurrentBufferElement(content.getNextContentBufferElement());
                directiveData.getBody().render((Writer)modelWriter);
                if (this.widgetType != null) {
                    content.setWidgetType(this.widgetType);
                }
            }
        } else if (logger.isErrorEnabled()) {
            logger.error((Object)"It is not possible to modify content in base directives, only in extensions to those directives");
        }
    }
}

