/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.render;

import java.io.IOException;
import java.io.Serializable;
import javax.servlet.http.HttpServletResponse;
import org.springframework.extensions.surf.ModelObject;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.exception.RendererExecutionException;
import org.springframework.extensions.surf.extensibility.ExtensibilityModel;
import org.springframework.extensions.surf.extensibility.impl.ExtensibilityHttpResponse;
import org.springframework.extensions.surf.render.RenderFocus;
import org.springframework.extensions.surf.render.RenderService;
import org.springframework.extensions.surf.render.Renderer;

public abstract class AbstractRenderer
implements Renderer {
    private RenderService renderService;

    public void setRenderService(RenderService renderService) {
        this.renderService = renderService;
    }

    public RenderService getRenderService() {
        return this.renderService;
    }

    public void render(RequestContext context, ModelObject object, RenderFocus focus) throws RendererExecutionException {
        context.setValue("currentRenderer", (Serializable)((Object)this.getClass().getName()));
        if (focus == null || focus == RenderFocus.BODY) {
            this.body(context, object);
        } else if (focus == RenderFocus.ALL) {
            this.all(context, object);
        } else if (focus == RenderFocus.HEADER) {
            this.header(context, object);
        }
    }

    public void all(RequestContext context, ModelObject object) throws RendererExecutionException {
        this.header(context, object);
        this.body(context, object);
    }

    public void header(RequestContext context, ModelObject object) throws RendererExecutionException {
    }

    public abstract void body(RequestContext var1, ModelObject var2) throws RendererExecutionException;

    protected void print(HttpServletResponse response, String str) throws RendererExecutionException {
        try {
            response.getWriter().print(str);
        }
        catch (IOException ex) {
            throw new RendererExecutionException("Unable to print string to response: " + str, ex);
        }
    }

    protected static void print(RequestContext context, String str) throws RendererExecutionException {
        try {
            Object response = null;
            ExtensibilityModel extModel = context.getCurrentExtensibilityModel();
            response = extModel == null ? context.getResponse() : new ExtensibilityHttpResponse(context.getResponse(), extModel);
            response.getWriter().print(str);
        }
        catch (IOException ex) {
            throw new RendererExecutionException("Unable to output string to response: " + str, ex);
        }
    }
}

