/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.render.bean;

import java.io.Serializable;
import org.springframework.extensions.surf.ModelObject;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.exception.RendererExecutionException;
import org.springframework.extensions.surf.render.AbstractRenderer;
import org.springframework.extensions.surf.render.RenderFocus;
import org.springframework.extensions.surf.render.Renderable;
import org.springframework.extensions.surf.render.bean.ComponentRenderer;
import org.springframework.extensions.surf.render.bean.RegionRenderer;
import org.springframework.extensions.surf.types.Chrome;

public class ChromeRenderer
extends AbstractRenderer {
    public void render(RequestContext context, ModelObject object, RenderFocus focus) throws RendererExecutionException {
        Serializable value = context.getValue("currentRenderer");
        if (value != null && value instanceof String) {
            String currentRenderer = (String)((Object)value);
            if (currentRenderer.equals(ComponentRenderer.class.getName())) {
                context.setValue("tagLibRenderType", (Serializable)((Object)"tagLibComponentRendering"));
            } else if (currentRenderer.equals(RegionRenderer.class.getName())) {
                context.setValue("tagLibRenderType", (Serializable)((Object)"tagLibRegionRendering"));
            } else if (currentRenderer.equals("tagLibSubComponentRendering")) {
                context.setValue("tagLibRenderType", (Serializable)((Object)"tagLibSubComponentRendering"));
            } else {
                throw new RendererExecutionException("The current context has not been provided with a current renderer value");
            }
        }
        super.render(context, object, focus);
    }

    public void body(RequestContext context, ModelObject object) throws RendererExecutionException {
        Chrome chrome = (Chrome)object;
        this.getRenderService().processRenderable(context, RenderFocus.BODY, object, (Renderable)((Object)chrome));
    }
}

