/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.support;

import java.util.Map;
import org.springframework.extensions.config.WebFrameworkConfigElement;
import org.springframework.extensions.surf.ModelObjectService;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.WebFrameworkServiceRegistry;
import org.springframework.extensions.surf.resource.ResourceService;
import org.springframework.extensions.surf.support.AbstractLinkBuilder;
import org.springframework.extensions.surf.util.URLEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestParameterLinkBuilder
extends AbstractLinkBuilder {
    protected RequestParameterLinkBuilder(WebFrameworkServiceRegistry serviceRegistry) {
        super(serviceRegistry);
    }

    public RequestParameterLinkBuilder(WebFrameworkConfigElement webFrameworkConfigElement, ModelObjectService modelObjectService, ResourceService resourceService) {
        super(webFrameworkConfigElement, modelObjectService, resourceService);
    }

    @Override
    public String page(RequestContext context, String pageId, String formatId, String objectId, Map<String, String> params) {
        if (pageId == null) {
            throw new IllegalArgumentException("PageId is mandatory.");
        }
        StringBuilder buffer = new StringBuilder(64);
        buffer.append(context.getContextPath());
        if (formatId != null) {
            buffer.append("?f=" + formatId);
        }
        buffer.append("&p=" + pageId);
        if (objectId != null && objectId.length() != 0) {
            buffer.append("&o=" + objectId);
        }
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                buffer.append("&" + key + "=" + URLEncoder.encode((String)value));
            }
        }
        return buffer.toString();
    }

    @Override
    public String pageType(RequestContext context, String pageTypeId, String formatId, String objectId, Map<String, String> params) {
        if (pageTypeId == null) {
            throw new IllegalArgumentException("PageTypeId is mandatory.");
        }
        StringBuilder buffer = new StringBuilder(64);
        buffer.append(context.getContextPath());
        if (formatId != null) {
            buffer.append("?f=" + formatId);
        }
        buffer.append("&pt=" + pageTypeId);
        if (objectId != null && objectId.length() != 0) {
            buffer.append("&o=" + objectId);
        }
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                buffer.append("&" + key + "=" + URLEncoder.encode((String)value));
            }
        }
        return buffer.toString();
    }

    @Override
    public String object(RequestContext context, String objectId, String formatId, Map<String, String> params) {
        if (objectId == null) {
            throw new IllegalArgumentException("ObjectId is mandatory.");
        }
        StringBuilder buffer = new StringBuilder(64);
        buffer.append(context.getContextPath());
        if (formatId != null) {
            buffer.append("?f=" + formatId);
        }
        buffer.append("&o=" + objectId);
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                buffer.append("&" + key + "=" + URLEncoder.encode((String)value));
            }
        }
        return buffer.toString();
    }

    @Override
    public String resource(RequestContext context, String uri) {
        StringBuilder buffer = new StringBuilder(64);
        buffer.append(context.getContextPath());
        buffer.append(uri);
        return buffer.toString();
    }
}

