/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.support;

import java.util.HashMap;
import java.util.Map;
import org.springframework.extensions.config.WebFrameworkConfigElement;
import org.springframework.extensions.surf.ModelObjectService;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.WebFrameworkServiceRegistry;
import org.springframework.extensions.surf.resource.ResourceService;
import org.springframework.extensions.surf.support.RequestParameterLinkBuilder;
import org.springframework.extensions.surf.util.URLEncoder;
import org.springframework.extensions.surf.util.WebUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletLinkBuilder
extends RequestParameterLinkBuilder {
    protected String pageUri = "/";
    protected String pageTypeUri = "/type/";
    protected String objectUri = "/obj/";

    protected ServletLinkBuilder(WebFrameworkServiceRegistry serviceRegistry) {
        super(serviceRegistry);
    }

    public ServletLinkBuilder(WebFrameworkConfigElement webFrameworkConfigElement, ModelObjectService modelObjectService, ResourceService resourceService) {
        super(webFrameworkConfigElement, modelObjectService, resourceService);
    }

    public void setPageUri(String pageUri) {
        this.pageUri = pageUri;
    }

    public void setPageTypeUri(String pageTypeUri) {
        this.pageTypeUri = pageTypeUri;
    }

    public void setObjectUri(String objectUri) {
        this.objectUri = objectUri;
    }

    @Override
    public String page(RequestContext context, String pageId, String formatId, String objectId, Map<String, String> params) {
        String qs;
        if (pageId == null) {
            throw new IllegalArgumentException("PageId is mandatory.");
        }
        StringBuilder buffer = new StringBuilder(64);
        buffer.append(context.getContextPath());
        buffer.append(this.pageUri);
        buffer.append(pageId);
        HashMap<String, String> qsMap = new HashMap<String, String>(8);
        if (formatId != null) {
            qsMap.put("f", formatId);
        }
        if (objectId != null && objectId.length() != 0) {
            qsMap.put("o", objectId);
        }
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                qsMap.put(key, URLEncoder.encode((String)value));
            }
        }
        if ((qs = WebUtil.getQueryStringForMap(qsMap)) != null && qs.length() > 0) {
            buffer.append("?");
            buffer.append(qs);
        }
        return buffer.toString();
    }

    @Override
    public String pageType(RequestContext context, String pageTypeId, String formatId, String objectId, Map<String, String> params) {
        String qs;
        if (pageTypeId == null) {
            throw new IllegalArgumentException("PageTypeId is mandatory.");
        }
        StringBuilder buffer = new StringBuilder(64);
        buffer.append(context.getContextPath());
        buffer.append(this.pageTypeUri);
        buffer.append(pageTypeId);
        HashMap<String, String> qsMap = new HashMap<String, String>(8);
        if (formatId != null) {
            qsMap.put("f", formatId);
        }
        if (objectId != null && objectId.length() != 0) {
            qsMap.put("o", objectId);
        }
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                qsMap.put(key, URLEncoder.encode((String)value));
            }
        }
        if ((qs = WebUtil.getQueryStringForMap(qsMap)) != null && qs.length() > 0) {
            buffer.append("?");
            buffer.append(qs);
        }
        return buffer.toString();
    }

    @Override
    public String object(RequestContext context, String resourceId, String formatId, Map<String, String> params) {
        String qs;
        if (resourceId == null) {
            throw new IllegalArgumentException("ObjectId is mandatory.");
        }
        StringBuilder buffer = new StringBuilder(64);
        buffer.append(context.getContextPath());
        buffer.append(this.objectUri);
        HashMap<String, String> qsMap = new HashMap<String, String>(8);
        if (formatId != null) {
            qsMap.put("f", formatId);
        }
        if (resourceId != null) {
            qsMap.put("o", resourceId);
        }
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                qsMap.put(key, URLEncoder.encode((String)value));
            }
        }
        if ((qs = WebUtil.getQueryStringForMap(qsMap)) != null && qs.length() > 0) {
            buffer.append("?");
            buffer.append(qs);
        }
        return buffer.toString();
    }

    @Override
    public String resource(RequestContext context, String uri) {
        StringBuilder buffer = new StringBuilder(16 + uri.length());
        buffer.append(context.getContextPath());
        buffer.append("/res");
        if (!uri.startsWith("/")) {
            buffer.append('/').append(uri);
        } else {
            buffer.append(uri);
        }
        return buffer.toString();
    }
}

