/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.types;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLHelper {
    private static final Log logger = LogFactory.getLog(XMLHelper.class);

    public static String getStringData(String elementName, Element element, boolean required) {
        String str = null;
        Element el = element.element(elementName);
        if (el != null) {
            str = el.getTextTrim();
        } else if (required && logger.isErrorEnabled()) {
            logger.error((Object)("The required element <" + elementName + "> was not found in element <" + element.getName() + ">"));
        }
        return str;
    }

    public static Map<String, String> getProperties(String elementName, Element sourceElement) {
        HashMap<String, String> props = new HashMap<String, String>();
        Element el = sourceElement.element(elementName);
        if (el != null) {
            List elementList = el.elements();
            for (Element element : elementList) {
                props.put(element.getName(), element.getTextTrim());
            }
        }
        return props;
    }

    public static boolean getBooleanAttribute(String attributeName, Element element, boolean defaultValue) {
        String booleanStr;
        boolean value = defaultValue;
        if (element != null && (booleanStr = element.attributeValue(attributeName)) != null) {
            value = Boolean.parseBoolean(booleanStr);
        }
        return value;
    }
}

