/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DataUtil {
    private static int BUFFER_SIZE = 1024;

    public static void copyStream(InputStream input, OutputStream output) throws IOException {
        DataUtil.copyStream(input, output, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copyStream(InputStream in, OutputStream out, boolean closeStreams) throws IOException {
        try {
            int byteCount = 0;
            byte[] buffer = new byte[BUFFER_SIZE];
            int bytesRead = -1;
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
                byteCount += bytesRead;
            }
            out.flush();
            int n = byteCount;
            return n;
        }
        finally {
            if (closeStreams) {
                try {
                    in.close();
                }
                catch (IOException ex) {}
                try {
                    out.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        return DataUtil.toByteArray(input, true);
    }

    public static byte[] toByteArray(InputStream input, boolean closeStream) throws IOException {
        return DataUtil.copyToByteArray(input, closeStream).toByteArray();
    }

    public static ByteArrayOutputStream copyToByteArray(InputStream input, boolean closeInputStream) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(BUFFER_SIZE);
        DataUtil.copyStream(input, buffer, closeInputStream);
        return buffer;
    }

    public static String copyToString(InputStream input, String encoding, boolean closeInputStream) throws IOException {
        ByteArrayOutputStream baos = DataUtil.copyToByteArray(input, closeInputStream);
        return encoding != null ? new String(baos.toByteArray(), encoding) : new String(baos.toByteArray());
    }
}

