/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObjectGUID {
    private static Log logger = LogFactory.getLog(ObjectGUID.class);
    public String valueBeforeMD5 = "";
    public String valueAfterMD5 = "";
    private static Random myRand;
    private static SecureRandom mySecureRand;
    private static String s_id;

    public ObjectGUID() {
        this.getRandomGUID(false);
    }

    public ObjectGUID(boolean secure) {
        this.getRandomGUID(secure);
    }

    private void getRandomGUID(boolean secure) {
        MessageDigest md5 = null;
        StringBuilder sbValueBeforeMD5 = new StringBuilder();
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            logger.fatal((Object)e);
        }
        try {
            long time = System.currentTimeMillis();
            long rand = 0L;
            rand = secure ? mySecureRand.nextLong() : myRand.nextLong();
            sbValueBeforeMD5.append(s_id);
            sbValueBeforeMD5.append(":");
            sbValueBeforeMD5.append(Long.toString(time));
            sbValueBeforeMD5.append(":");
            sbValueBeforeMD5.append(Long.toString(rand));
            this.valueBeforeMD5 = sbValueBeforeMD5.toString();
            md5.update(this.valueBeforeMD5.getBytes());
            byte[] array = md5.digest();
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j < array.length; ++j) {
                int b = array[j] & 0xFF;
                if (b < 16) {
                    sb.append('0');
                }
                sb.append(Integer.toHexString(b));
            }
            this.valueAfterMD5 = sb.toString();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public String toString() {
        String raw = this.valueAfterMD5.toLowerCase();
        StringBuilder sb = new StringBuilder(10);
        sb.append(raw.substring(0, 6));
        sb.append(raw.substring(8, 12));
        return sb.toString();
    }

    static {
        mySecureRand = new SecureRandom();
        long secureInitializer = mySecureRand.nextLong();
        myRand = new Random(secureInitializer);
        try {
            s_id = InetAddress.getLocalHost().toString();
        }
        catch (UnknownHostException e) {
            logger.fatal((Object)e);
        }
    }
}

