/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.runtime;

import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Relationship;
import org.apache.chemistry.opencmis.client.api.TransientCmisObject;
import org.apache.chemistry.opencmis.client.api.TransientRelationship;
import org.apache.chemistry.opencmis.client.runtime.AbstractCmisObject;
import org.apache.chemistry.opencmis.client.runtime.SessionImpl;
import org.apache.chemistry.opencmis.client.runtime.TransientRelationshipImpl;
import org.apache.chemistry.opencmis.commons.data.ObjectData;

public class RelationshipImpl
extends AbstractCmisObject
implements Relationship {
    private static final long serialVersionUID = 1L;

    public RelationshipImpl(SessionImpl session, ObjectType objectType, ObjectData objectData, OperationContext context) {
        this.initialize(session, objectType, objectData, context);
    }

    protected TransientCmisObject createTransientCmisObject() {
        TransientRelationshipImpl tr = new TransientRelationshipImpl();
        tr.initialize(this.getSession(), this);
        return tr;
    }

    public TransientRelationship getTransientRelationship() {
        return (TransientRelationship)this.getTransientObject();
    }

    public CmisObject getSource() {
        return this.getSource(this.getSession().getDefaultContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmisObject getSource(OperationContext context) {
        this.readLock();
        try {
            ObjectId sourceId = this.getSourceId();
            if (sourceId == null) {
                CmisObject cmisObject = null;
                return cmisObject;
            }
            CmisObject cmisObject = this.getSession().getObject(sourceId, context);
            return cmisObject;
        }
        finally {
            this.readUnlock();
        }
    }

    public ObjectId getSourceId() {
        String sourceId = (String)this.getPropertyValue("cmis:sourceId");
        if (sourceId == null || sourceId.length() == 0) {
            return null;
        }
        return this.getSession().createObjectId(sourceId);
    }

    public CmisObject getTarget() {
        return this.getTarget(this.getSession().getDefaultContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmisObject getTarget(OperationContext context) {
        this.readLock();
        try {
            ObjectId targetId = this.getTargetId();
            if (targetId == null) {
                CmisObject cmisObject = null;
                return cmisObject;
            }
            CmisObject cmisObject = this.getSession().getObject(targetId, context);
            return cmisObject;
        }
        finally {
            this.readUnlock();
        }
    }

    public ObjectId getTargetId() {
        String targetId = (String)this.getPropertyValue("cmis:targetId");
        if (targetId == null || targetId.length() == 0) {
            return null;
        }
        return this.getSession().createObjectId(targetId);
    }
}

