/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.runtime;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.chemistry.opencmis.client.api.ChangeEvents;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.ExtensionHandler;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectFactory;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Policy;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.apache.chemistry.opencmis.client.api.QueryStatement;
import org.apache.chemistry.opencmis.client.api.Relationship;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.api.Tree;
import org.apache.chemistry.opencmis.client.runtime.CmisBindingHelper;
import org.apache.chemistry.opencmis.client.runtime.ObjectIdImpl;
import org.apache.chemistry.opencmis.client.runtime.OperationContextImpl;
import org.apache.chemistry.opencmis.client.runtime.QueryStatementImpl;
import org.apache.chemistry.opencmis.client.runtime.cache.Cache;
import org.apache.chemistry.opencmis.client.runtime.cache.CacheImpl;
import org.apache.chemistry.opencmis.client.runtime.repository.ObjectFactoryImpl;
import org.apache.chemistry.opencmis.client.runtime.util.AbstractPageFetcher;
import org.apache.chemistry.opencmis.client.runtime.util.CollectionIterable;
import org.apache.chemistry.opencmis.client.runtime.util.TreeImpl;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionList;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.RelationshipDirection;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.spi.AuthenticationProvider;
import org.apache.chemistry.opencmis.commons.spi.CmisBinding;
import org.apache.chemistry.opencmis.commons.spi.DiscoveryService;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.apache.chemistry.opencmis.commons.spi.NavigationService;
import org.apache.chemistry.opencmis.commons.spi.RelationshipService;
import org.apache.chemistry.opencmis.commons.spi.RepositoryService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionImpl
implements Session {
    private static final OperationContext DEFAULT_CONTEXT = new OperationContextImpl(null, false, true, false, IncludeRelationships.NONE, null, true, null, true, 100);
    private static final Set<Updatability> CREATE_UPDATABILITY = new HashSet<Updatability>();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private OperationContext context = DEFAULT_CONTEXT;
    private Map<String, String> parameters;
    private CmisBinding binding;
    private Locale locale;
    private final ObjectFactory objectFactory;
    private final AuthenticationProvider authenticationProvider;
    private Cache cache;
    private final boolean cachePathOmit;
    private RepositoryInfo repositoryInfo;
    private static final long serialVersionUID = 1L;

    public SessionImpl(Map<String, String> parameters, ObjectFactory objectFactory, AuthenticationProvider authenticationProvider, Cache cache) {
        if (parameters == null) {
            throw new IllegalArgumentException("No parameters provided!");
        }
        this.parameters = parameters;
        this.locale = SessionImpl.determineLocale(parameters);
        this.objectFactory = objectFactory == null ? this.createObjectFactory() : objectFactory;
        this.authenticationProvider = authenticationProvider;
        this.cache = cache == null ? this.createCache() : cache;
        this.cachePathOmit = Boolean.parseBoolean(parameters.get("org.apache.chemistry.opencmis.cache.path.omit"));
    }

    private static Locale determineLocale(Map<String, String> parameters) {
        Locale locale = null;
        String language = parameters.get("org.apache.chemistry.opencmis.locale.iso639");
        String country = parameters.get("org.apache.chemistry.opencmis.locale.iso3166");
        String variant = parameters.get("org.apache.chemistry.opencmis.locale.variant");
        locale = variant != null ? new Locale(language, country, variant) : (country != null ? new Locale(language, country) : (language != null ? new Locale(language) : Locale.getDefault()));
        return locale;
    }

    private ObjectFactory createObjectFactory() {
        try {
            String classname = this.parameters.get("org.apache.chemistry.opencmis.objectfactory.classname");
            Class objectFactoryClass = classname == null ? ObjectFactoryImpl.class : Class.forName(classname);
            Object of = objectFactoryClass.newInstance();
            if (!(of instanceof ObjectFactory)) {
                throw new Exception("Class does not implement ObjectFactory!");
            }
            ((ObjectFactory)of).initialize((Session)this, this.parameters);
            return (ObjectFactory)of;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to create object factory: " + e, e);
        }
    }

    private Cache createCache() {
        try {
            String classname = this.parameters.get("org.apache.chemistry.opencmis.cache.classname");
            Class cacheClass = classname == null ? CacheImpl.class : Class.forName(classname);
            Object of = cacheClass.newInstance();
            if (!(of instanceof Cache)) {
                throw new Exception("Class does not implement Cache!");
            }
            ((Cache)of).initialize(this, this.parameters);
            return (Cache)of;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to create cache: " + e, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.cache = this.createCache();
            this.getBinding().clearAllCaches();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public ObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    public ItemIterable<Document> getCheckedOutDocs() {
        return this.getCheckedOutDocs(this.getDefaultContext());
    }

    public ItemIterable<Document> getCheckedOutDocs(OperationContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Operation context must be set!");
        }
        final NavigationService navigationService = this.getBinding().getNavigationService();
        final ObjectFactory objectFactory = this.getObjectFactory();
        final OperationContextImpl ctxt = new OperationContextImpl(context);
        return new CollectionIterable<Document>(new AbstractPageFetcher<Document>((long)ctxt.getMaxItemsPerPage()){

            @Override
            protected AbstractPageFetcher.Page<Document> fetchPage(long skipCount) {
                ObjectList checkedOutDocs = navigationService.getCheckedOutDocs(SessionImpl.this.getRepositoryId(), null, ctxt.getFilterString(), ctxt.getOrderBy(), Boolean.valueOf(ctxt.isIncludeAllowableActions()), ctxt.getIncludeRelationships(), ctxt.getRenditionFilterString(), BigInteger.valueOf(this.maxNumItems), BigInteger.valueOf(skipCount), null);
                ArrayList<Document> page = new ArrayList<Document>();
                if (checkedOutDocs.getObjects() != null) {
                    for (ObjectData objectData : checkedOutDocs.getObjects()) {
                        CmisObject doc = objectFactory.convertObject(objectData, ctxt);
                        if (!(doc instanceof Document)) continue;
                        page.add((Document)doc);
                    }
                }
                return new AbstractPageFetcher.Page<Document>(page, checkedOutDocs.getNumItems(), checkedOutDocs.hasMoreItems());
            }
        });
    }

    public ChangeEvents getContentChanges(String changeLogToken, boolean includeProperties, long maxNumItems) {
        return this.getContentChanges(changeLogToken, includeProperties, maxNumItems, this.getDefaultContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangeEvents getContentChanges(String changeLogToken, boolean includeProperties, long maxNumItems, OperationContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Operation context must be set!");
        }
        this.lock.readLock().lock();
        try {
            Holder changeLogTokenHolder = new Holder((Object)changeLogToken);
            ObjectList objectList = this.getBinding().getDiscoveryService().getContentChanges(this.getRepositoryInfo().getId(), changeLogTokenHolder, Boolean.valueOf(includeProperties), context.getFilterString(), Boolean.valueOf(context.isIncludePolicies()), Boolean.valueOf(context.isIncludeAcls()), BigInteger.valueOf(maxNumItems), null);
            ChangeEvents changeEvents = this.objectFactory.convertChangeEvents((String)changeLogTokenHolder.getValue(), objectList);
            return changeEvents;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationContext getDefaultContext() {
        this.lock.readLock().lock();
        try {
            OperationContext operationContext = this.context;
            return operationContext;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultContext(OperationContext context) {
        this.lock.writeLock().lock();
        try {
            this.context = context == null ? DEFAULT_CONTEXT : context;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public OperationContext createOperationContext(Set<String> filter, boolean includeAcls, boolean includeAllowableActions, boolean includePolicies, IncludeRelationships includeRelationships, Set<String> renditionFilter, boolean includePathSegments, String orderBy, boolean cacheEnabled, int maxItemsPerPage) {
        return new OperationContextImpl(filter, includeAcls, includeAllowableActions, includePolicies, includeRelationships, renditionFilter, includePathSegments, orderBy, cacheEnabled, maxItemsPerPage);
    }

    public OperationContext createOperationContext() {
        return new OperationContextImpl();
    }

    public ObjectId createObjectId(String id) {
        return new ObjectIdImpl(id);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public CmisObject getObject(ObjectId objectId) {
        return this.getObject(objectId, this.getDefaultContext());
    }

    public CmisObject getObject(ObjectId objectId, OperationContext context) {
        if (objectId == null || objectId.getId() == null) {
            throw new IllegalArgumentException("Object Id must be set!");
        }
        return this.getObject(objectId.getId(), context);
    }

    public CmisObject getObject(String objectId) {
        return this.getObject(objectId, this.getDefaultContext());
    }

    public CmisObject getObject(String objectId, OperationContext context) {
        if (objectId == null) {
            throw new IllegalArgumentException("Object Id must be set!");
        }
        if (context == null) {
            throw new IllegalArgumentException("Operation context must be set!");
        }
        CmisObject result = null;
        if (context.isCacheEnabled() && (result = this.cache.getById(objectId, context.getCacheKey())) != null) {
            return result;
        }
        ObjectData objectData = this.binding.getObjectService().getObject(this.getRepositoryId(), objectId, context.getFilterString(), Boolean.valueOf(context.isIncludeAllowableActions()), context.getIncludeRelationships(), context.getRenditionFilterString(), Boolean.valueOf(context.isIncludePolicies()), Boolean.valueOf(context.isIncludeAcls()), null);
        result = this.getObjectFactory().convertObject(objectData, context);
        if (context.isCacheEnabled()) {
            this.cache.put(result, context.getCacheKey());
        }
        return result;
    }

    public CmisObject getObjectByPath(String path) {
        return this.getObjectByPath(path, this.getDefaultContext());
    }

    public CmisObject getObjectByPath(String path, OperationContext context) {
        if (path == null) {
            throw new IllegalArgumentException("Path must be set!");
        }
        if (context == null) {
            throw new IllegalArgumentException("Operation context must be set!");
        }
        CmisObject result = null;
        if (context.isCacheEnabled() && !this.cachePathOmit && (result = this.cache.getByPath(path, context.getCacheKey())) != null) {
            return result;
        }
        ObjectData objectData = this.binding.getObjectService().getObjectByPath(this.getRepositoryId(), path, context.getFilterString(), Boolean.valueOf(context.isIncludeAllowableActions()), context.getIncludeRelationships(), context.getRenditionFilterString(), Boolean.valueOf(context.isIncludePolicies()), Boolean.valueOf(context.isIncludeAcls()), null);
        result = this.getObjectFactory().convertObject(objectData, context);
        if (context.isCacheEnabled()) {
            this.cache.putPath(path, result, context.getCacheKey());
        }
        return result;
    }

    public void removeObjectFromCache(ObjectId objectId) {
        if (objectId == null || objectId.getId() == null) {
            return;
        }
        this.removeObjectFromCache(objectId.getId());
    }

    public void removeObjectFromCache(String objectId) {
        this.cache.remove(objectId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryInfo getRepositoryInfo() {
        this.lock.readLock().lock();
        try {
            RepositoryInfo repositoryInfo = this.repositoryInfo;
            return repositoryInfo;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Folder getRootFolder() {
        return this.getRootFolder(this.getDefaultContext());
    }

    public Folder getRootFolder(OperationContext context) {
        String rootFolderId = this.getRepositoryInfo().getRootFolderId();
        CmisObject rootFolder = this.getObject(this.createObjectId(rootFolderId), context);
        if (!(rootFolder instanceof Folder)) {
            throw new CmisRuntimeException("Root folder object is not a folder!");
        }
        return (Folder)rootFolder;
    }

    public ItemIterable<ObjectType> getTypeChildren(final String typeId, final boolean includePropertyDefinitions) {
        final RepositoryService repositoryService = this.getBinding().getRepositoryService();
        final ObjectFactory objectFactory = this.getObjectFactory();
        return new CollectionIterable<ObjectType>(new AbstractPageFetcher<ObjectType>((long)this.getDefaultContext().getMaxItemsPerPage()){

            @Override
            protected AbstractPageFetcher.Page<ObjectType> fetchPage(long skipCount) {
                TypeDefinitionList tdl = repositoryService.getTypeChildren(SessionImpl.this.getRepositoryId(), typeId, Boolean.valueOf(includePropertyDefinitions), BigInteger.valueOf(this.maxNumItems), BigInteger.valueOf(skipCount), null);
                ArrayList<ObjectType> page = new ArrayList<ObjectType>(tdl.getList().size());
                for (TypeDefinition typeDefinition : tdl.getList()) {
                    page.add(objectFactory.convertTypeDefinition(typeDefinition));
                }
                return new AbstractPageFetcher.Page<ObjectType>(page, tdl.getNumItems(), tdl.hasMoreItems()){};
            }
        });
    }

    public ObjectType getTypeDefinition(String typeId) {
        TypeDefinition typeDefinition = this.getBinding().getRepositoryService().getTypeDefinition(this.getRepositoryId(), typeId, null);
        return this.objectFactory.convertTypeDefinition(typeDefinition);
    }

    public List<Tree<ObjectType>> getTypeDescendants(String typeId, int depth, boolean includePropertyDefinitions) {
        List descendants = this.getBinding().getRepositoryService().getTypeDescendants(this.getRepositoryId(), typeId, BigInteger.valueOf(depth), Boolean.valueOf(includePropertyDefinitions), null);
        return this.convertTypeDescendants(descendants);
    }

    private List<Tree<ObjectType>> convertTypeDescendants(List<TypeDefinitionContainer> descendantsList) {
        ArrayList<Tree<ObjectType>> result = new ArrayList<Tree<ObjectType>>();
        for (TypeDefinitionContainer container : descendantsList) {
            ObjectType objectType = this.objectFactory.convertTypeDefinition(container.getTypeDefinition());
            List children = this.convertTypeDescendants(container.getChildren());
            result.add(new TreeImpl<ObjectType>(objectType, children));
        }
        return result;
    }

    public ItemIterable<QueryResult> query(String statement, boolean searchAllVersions) {
        return this.query(statement, searchAllVersions, this.getDefaultContext());
    }

    public ItemIterable<QueryResult> query(final String statement, final boolean searchAllVersions, OperationContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Operation context must be set!");
        }
        final DiscoveryService discoveryService = this.getBinding().getDiscoveryService();
        final ObjectFactory objectFactory = this.getObjectFactory();
        final OperationContextImpl ctxt = new OperationContextImpl(context);
        return new CollectionIterable<QueryResult>(new AbstractPageFetcher<QueryResult>((long)ctxt.getMaxItemsPerPage()){

            @Override
            protected AbstractPageFetcher.Page<QueryResult> fetchPage(long skipCount) {
                ObjectList resultList = discoveryService.query(SessionImpl.this.getRepositoryId(), statement, Boolean.valueOf(searchAllVersions), Boolean.valueOf(ctxt.isIncludeAllowableActions()), ctxt.getIncludeRelationships(), ctxt.getRenditionFilterString(), BigInteger.valueOf(this.maxNumItems), BigInteger.valueOf(skipCount), null);
                ArrayList<QueryResult> page = new ArrayList<QueryResult>();
                if (resultList.getObjects() != null) {
                    for (ObjectData objectData : resultList.getObjects()) {
                        if (objectData == null) continue;
                        page.add(objectFactory.convertQueryResult(objectData));
                    }
                }
                return new AbstractPageFetcher.Page<QueryResult>(page, resultList.getNumItems(), resultList.hasMoreItems());
            }
        });
    }

    public ItemIterable<CmisObject> queryObjects(String typeId, String where, final boolean searchAllVersions, OperationContext context) {
        String orderBy;
        if (typeId == null || typeId.trim().length() == 0) {
            throw new IllegalArgumentException("Type id must be set!");
        }
        if (context == null) {
            throw new IllegalArgumentException("Operation context must be set!");
        }
        final DiscoveryService discoveryService = this.getBinding().getDiscoveryService();
        final ObjectFactory objectFactory = this.getObjectFactory();
        final OperationContextImpl ctxt = new OperationContextImpl(context);
        final StringBuilder statement = new StringBuilder("SELECT ");
        String select = ctxt.getFilterString();
        if (select == null) {
            statement.append("*");
        } else {
            statement.append(select);
        }
        ObjectType type = this.getTypeDefinition(typeId);
        statement.append(" FROM ");
        statement.append(type.getQueryName());
        if (where != null && where.trim().length() > 0) {
            statement.append(" WHERE ");
            statement.append(where);
        }
        if ((orderBy = ctxt.getOrderBy()) != null && orderBy.trim().length() > 0) {
            statement.append(" ORDER BY ");
            statement.append(orderBy);
        }
        return new CollectionIterable<CmisObject>(new AbstractPageFetcher<CmisObject>((long)ctxt.getMaxItemsPerPage()){

            @Override
            protected AbstractPageFetcher.Page<CmisObject> fetchPage(long skipCount) {
                ObjectList resultList = discoveryService.query(SessionImpl.this.getRepositoryId(), statement.toString(), Boolean.valueOf(searchAllVersions), Boolean.valueOf(ctxt.isIncludeAllowableActions()), ctxt.getIncludeRelationships(), ctxt.getRenditionFilterString(), BigInteger.valueOf(this.maxNumItems), BigInteger.valueOf(skipCount), null);
                ArrayList<CmisObject> page = new ArrayList<CmisObject>();
                if (resultList.getObjects() != null) {
                    for (ObjectData objectData : resultList.getObjects()) {
                        if (objectData == null) continue;
                        page.add(objectFactory.convertObject(objectData, ctxt));
                    }
                }
                return new AbstractPageFetcher.Page<CmisObject>(page, resultList.getNumItems(), resultList.hasMoreItems());
            }
        });
    }

    public QueryStatement createQueryStatement(String statement) {
        return new QueryStatementImpl(this, statement);
    }

    public String setExtensionContext(String context) {
        throw new CmisRuntimeException("not implemented");
    }

    public ExtensionHandler setExtensionHandler(String context, ExtensionHandler extensionHandler) {
        throw new CmisRuntimeException("not implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() {
        this.lock.writeLock().lock();
        try {
            this.binding = CmisBindingHelper.createBinding(this.parameters, this.authenticationProvider);
            String repositoryId = this.parameters.get("org.apache.chemistry.opencmis.session.repository.id");
            if (repositoryId == null) {
                throw new IllegalStateException("Repository Id is not set!");
            }
            this.repositoryInfo = this.objectFactory.convertRepositoryInfo(this.getBinding().getRepositoryService().getRepositoryInfo(repositoryId, null));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmisBinding getBinding() {
        this.lock.readLock().lock();
        try {
            CmisBinding cmisBinding = this.binding;
            return cmisBinding;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache getCache() {
        this.lock.readLock().lock();
        try {
            Cache cache = this.cache;
            return cache;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public String getRepositoryId() {
        return this.getRepositoryInfo().getId();
    }

    public ObjectId createDocument(Map<String, ?> properties, ObjectId folderId, ContentStream contentStream, VersioningState versioningState, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces) {
        if (properties == null || properties.isEmpty()) {
            throw new IllegalArgumentException("Properties must not be empty!");
        }
        String newId = this.getBinding().getObjectService().createDocument(this.getRepositoryId(), this.objectFactory.convertProperties(properties, null, CREATE_UPDATABILITY), folderId == null ? null : folderId.getId(), this.objectFactory.convertContentStream(contentStream), versioningState, this.objectFactory.convertPolicies(policies), this.objectFactory.convertAces(addAces), this.objectFactory.convertAces(removeAces), null);
        if (newId == null) {
            return null;
        }
        return this.createObjectId(newId);
    }

    public ObjectId createDocumentFromSource(ObjectId source, Map<String, ?> properties, ObjectId folderId, VersioningState versioningState, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces) {
        if (source == null || source.getId() == null) {
            throw new IllegalArgumentException("Source must be set!");
        }
        ObjectType type = null;
        if (source instanceof CmisObject) {
            type = ((CmisObject)source).getType();
        } else {
            CmisObject sourceObj = this.getObject(source);
            type = sourceObj.getType();
        }
        if (type.getBaseTypeId() != BaseTypeId.CMIS_DOCUMENT) {
            throw new IllegalArgumentException("Source object must be a document!");
        }
        String newId = this.getBinding().getObjectService().createDocumentFromSource(this.getRepositoryId(), source.getId(), this.objectFactory.convertProperties(properties, type, CREATE_UPDATABILITY), folderId == null ? null : folderId.getId(), versioningState, this.objectFactory.convertPolicies(policies), this.objectFactory.convertAces(addAces), this.objectFactory.convertAces(removeAces), null);
        if (newId == null) {
            return null;
        }
        return this.createObjectId(newId);
    }

    public ObjectId createFolder(Map<String, ?> properties, ObjectId folderId, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces) {
        if (folderId == null || folderId.getId() == null) {
            throw new IllegalArgumentException("Folder Id must be set!");
        }
        if (properties == null || properties.isEmpty()) {
            throw new IllegalArgumentException("Properties must not be empty!");
        }
        String newId = this.getBinding().getObjectService().createFolder(this.getRepositoryId(), this.objectFactory.convertProperties(properties, null, CREATE_UPDATABILITY), folderId.getId(), this.objectFactory.convertPolicies(policies), this.objectFactory.convertAces(addAces), this.objectFactory.convertAces(removeAces), null);
        if (newId == null) {
            return null;
        }
        return this.createObjectId(newId);
    }

    public ObjectId createPolicy(Map<String, ?> properties, ObjectId folderId, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces) {
        if (properties == null || properties.isEmpty()) {
            throw new IllegalArgumentException("Properties must not be empty!");
        }
        String newId = this.getBinding().getObjectService().createPolicy(this.getRepositoryId(), this.objectFactory.convertProperties(properties, null, CREATE_UPDATABILITY), folderId == null ? null : folderId.getId(), this.objectFactory.convertPolicies(policies), this.objectFactory.convertAces(addAces), this.objectFactory.convertAces(removeAces), null);
        if (newId == null) {
            return null;
        }
        return this.createObjectId(newId);
    }

    public ObjectId createRelationship(Map<String, ?> properties, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces) {
        if (properties == null || properties.isEmpty()) {
            throw new IllegalArgumentException("Properties must not be empty!");
        }
        String newId = this.getBinding().getObjectService().createRelationship(this.getRepositoryId(), this.objectFactory.convertProperties(properties, null, CREATE_UPDATABILITY), this.objectFactory.convertPolicies(policies), this.objectFactory.convertAces(addAces), this.objectFactory.convertAces(removeAces), null);
        if (newId == null) {
            return null;
        }
        return this.createObjectId(newId);
    }

    public ObjectId createDocument(Map<String, ?> properties, ObjectId folderId, ContentStream contentStream, VersioningState versioningState) {
        return this.createDocument(properties, folderId, contentStream, versioningState, null, null, null);
    }

    public ObjectId createDocumentFromSource(ObjectId source, Map<String, ?> properties, ObjectId folderId, VersioningState versioningState) {
        return this.createDocumentFromSource(source, properties, folderId, versioningState, null, null, null);
    }

    public ObjectId createFolder(Map<String, ?> properties, ObjectId folderId) {
        return this.createFolder(properties, folderId, null, null, null);
    }

    public ObjectId createPolicy(Map<String, ?> properties, ObjectId folderId) {
        return this.createPolicy(properties, folderId, null, null, null);
    }

    public ObjectId createRelationship(Map<String, ?> properties) {
        return this.createRelationship(properties, null, null, null);
    }

    public ItemIterable<Relationship> getRelationships(ObjectId objectId, final boolean includeSubRelationshipTypes, final RelationshipDirection relationshipDirection, ObjectType type, OperationContext context) {
        if (objectId == null || objectId.getId() == null) {
            throw new IllegalArgumentException("Invalid object id!");
        }
        if (context == null) {
            throw new IllegalArgumentException("Operation context must be set!");
        }
        final String id = objectId.getId();
        final String typeId = type == null ? null : type.getId();
        final RelationshipService relationshipService = this.getBinding().getRelationshipService();
        final OperationContextImpl ctxt = new OperationContextImpl(context);
        return new CollectionIterable<Relationship>(new AbstractPageFetcher<Relationship>((long)ctxt.getMaxItemsPerPage()){

            @Override
            protected AbstractPageFetcher.Page<Relationship> fetchPage(long skipCount) {
                ObjectList relList = relationshipService.getObjectRelationships(SessionImpl.this.getRepositoryId(), id, Boolean.valueOf(includeSubRelationshipTypes), relationshipDirection, typeId, ctxt.getFilterString(), Boolean.valueOf(ctxt.isIncludeAllowableActions()), BigInteger.valueOf(this.maxNumItems), BigInteger.valueOf(skipCount), null);
                ArrayList<Relationship> page = new ArrayList<Relationship>();
                if (relList.getObjects() != null) {
                    for (ObjectData rod : relList.getObjects()) {
                        CmisObject relationship = SessionImpl.this.getObject(SessionImpl.this.createObjectId(rod.getId()), ctxt);
                        if (!(relationship instanceof Relationship)) {
                            throw new CmisRuntimeException("Repository returned an object that is not a relationship!");
                        }
                        page.add((Relationship)relationship);
                    }
                }
                return new AbstractPageFetcher.Page<Relationship>(page, relList.getNumItems(), relList.hasMoreItems());
            }
        });
    }

    public Acl getAcl(ObjectId objectId, boolean onlyBasicPermissions) {
        if (objectId == null || objectId.getId() == null) {
            throw new IllegalArgumentException("Invalid object id!");
        }
        String id = objectId.getId();
        return this.getBinding().getAclService().getAcl(this.getRepositoryId(), id, Boolean.valueOf(onlyBasicPermissions), null);
    }

    public Acl applyAcl(ObjectId objectId, List<Ace> addAces, List<Ace> removeAces, AclPropagation aclPropagation) {
        if (objectId == null || objectId.getId() == null) {
            throw new IllegalArgumentException("Invalid object id!");
        }
        ObjectFactory of = this.getObjectFactory();
        return this.getBinding().getAclService().applyAcl(this.getRepositoryId(), objectId.getId(), of.convertAces(addAces), of.convertAces(removeAces), aclPropagation, null);
    }

    public void applyPolicy(ObjectId objectId, ObjectId ... policyIds) {
        if (objectId == null || objectId.getId() == null) {
            throw new IllegalArgumentException("Invalid object id!");
        }
        if (policyIds == null || policyIds.length == 0) {
            throw new IllegalArgumentException("No Policies provided!");
        }
        String[] ids = new String[policyIds.length];
        for (int i = 0; i < policyIds.length; ++i) {
            if (policyIds[i] == null || policyIds[i].getId() == null) {
                throw new IllegalArgumentException("A Policy Id is not set!");
            }
            ids[i] = policyIds[i].getId();
        }
        for (String id : ids) {
            this.getBinding().getPolicyService().applyPolicy(this.getRepositoryId(), id, objectId.getId(), null);
        }
    }

    public void removePolicy(ObjectId objectId, ObjectId ... policyIds) {
        if (objectId == null || objectId.getId() == null) {
            throw new IllegalArgumentException("Invalid object id!");
        }
        if (policyIds == null || policyIds.length == 0) {
            throw new IllegalArgumentException("No Policies provided!");
        }
        String[] ids = new String[policyIds.length];
        for (int i = 0; i < policyIds.length; ++i) {
            if (policyIds[i] == null || policyIds[i].getId() == null) {
                throw new IllegalArgumentException("A Policy Id is not set!");
            }
            ids[i] = policyIds[i].getId();
        }
        for (String id : ids) {
            this.getBinding().getPolicyService().removePolicy(this.getRepositoryId(), id, objectId.getId(), null);
        }
    }

    static {
        CREATE_UPDATABILITY.add(Updatability.ONCREATE);
        CREATE_UPDATABILITY.add(Updatability.READWRITE);
    }
}

