/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.atompub;

import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.Converter;
import org.apache.chemistry.opencmis.commons.impl.JaxBHelper;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisAccessControlListType;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.server.impl.atompub.AclDocument;
import org.apache.chemistry.opencmis.server.shared.HttpUtils;

public class AclService {
    private AclService() {
    }

    public static void getAcl(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Boolean onlyBasicPermissions;
        String objectId = HttpUtils.getStringParameter(request, "id");
        Acl acl = service.getAcl(repositoryId, objectId, onlyBasicPermissions = HttpUtils.getBooleanParameter(request, "onlyBasicPermissions"), null);
        if (acl == null) {
            throw new CmisRuntimeException("ACL is null!");
        }
        response.setStatus(200);
        response.setContentType("application/cmisacl+xml");
        AclDocument aclDocument = new AclDocument();
        aclDocument.writeAcl(acl, (OutputStream)response.getOutputStream());
    }

    public static void applyAcl(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String objectId = HttpUtils.getStringParameter(request, "id");
        AclPropagation aclPropagation = HttpUtils.getEnumParameter(request, "ACLPropagation", AclPropagation.class);
        Object aclRequest = null;
        try {
            Unmarshaller u = JaxBHelper.createUnmarshaller();
            aclRequest = u.unmarshal((InputStream)request.getInputStream());
        }
        catch (Exception e) {
            throw new CmisInvalidArgumentException("Invalid ACL request: " + e, (Throwable)e);
        }
        if (!(aclRequest instanceof JAXBElement)) {
            throw new CmisInvalidArgumentException("Not an ACL document!");
        }
        if (!(((JAXBElement)aclRequest).getValue() instanceof CmisAccessControlListType)) {
            throw new CmisInvalidArgumentException("Not an ACL document!");
        }
        Acl aces = Converter.convert((CmisAccessControlListType)((CmisAccessControlListType)((JAXBElement)aclRequest).getValue()), null);
        Acl acl = service.applyAcl(repositoryId, objectId, aces, aclPropagation);
        response.setStatus(201);
        response.setContentType("application/cmisacl+xml");
        AclDocument aclDocument = new AclDocument();
        aclDocument.writeAcl(acl, (OutputStream)response.getOutputStream());
    }
}

