/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.webservices;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.jws.WebService;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.soap.MTOM;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderContainer;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderList;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.data.ObjectParentData;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.impl.Converter;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisException;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisExtensionType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisObjectInFolderContainerType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisObjectInFolderListType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisObjectListType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisObjectParentsType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisObjectType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumIncludeRelationships;
import org.apache.chemistry.opencmis.commons.impl.jaxb.NavigationServicePort;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.server.impl.webservices.AbstractService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MTOM
@WebService(endpointInterface="org.apache.chemistry.opencmis.commons.impl.jaxb.NavigationServicePort")
public class NavigationService
extends AbstractService
implements NavigationServicePort {
    @Resource
    public WebServiceContext wsContext;

    public CmisObjectListType getCheckedOutDocs(String repositoryId, String folderId, String filter, String orderBy, Boolean includeAllowableActions, EnumIncludeRelationships includeRelationships, String renditionFilter, BigInteger maxItems, BigInteger skipCount, CmisExtensionType extension) throws CmisException {
        CmisObjectListType cmisObjectListType;
        CmisService service = null;
        try {
            service = this.getService(this.wsContext, repositoryId);
            cmisObjectListType = Converter.convert((ObjectList)service.getCheckedOutDocs(repositoryId, folderId, filter, orderBy, includeAllowableActions, (IncludeRelationships)Converter.convert(IncludeRelationships.class, (Enum)includeRelationships), renditionFilter, maxItems, skipCount, Converter.convert((CmisExtensionType)extension)));
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
        return cmisObjectListType;
    }

    public CmisObjectInFolderListType getChildren(String repositoryId, String folderId, String filter, String orderBy, Boolean includeAllowableActions, EnumIncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, BigInteger maxItems, BigInteger skipCount, CmisExtensionType extension) throws CmisException {
        CmisObjectInFolderListType cmisObjectInFolderListType;
        CmisService service = null;
        try {
            service = this.getService(this.wsContext, repositoryId);
            cmisObjectInFolderListType = Converter.convert((ObjectInFolderList)service.getChildren(repositoryId, folderId, filter, orderBy, includeAllowableActions, (IncludeRelationships)Converter.convert(IncludeRelationships.class, (Enum)includeRelationships), renditionFilter, includePathSegment, maxItems, skipCount, Converter.convert((CmisExtensionType)extension)));
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
        return cmisObjectInFolderListType;
    }

    public List<CmisObjectInFolderContainerType> getDescendants(String repositoryId, String folderId, BigInteger depth, String filter, Boolean includeAllowableActions, EnumIncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, CmisExtensionType extension) throws CmisException {
        ArrayList<CmisObjectInFolderContainerType> arrayList;
        CmisService service = null;
        try {
            service = this.getService(this.wsContext, repositoryId);
            ArrayList<CmisObjectInFolderContainerType> result = new ArrayList<CmisObjectInFolderContainerType>();
            List serviceResult = service.getDescendants(repositoryId, folderId, depth, filter, includeAllowableActions, (IncludeRelationships)Converter.convert(IncludeRelationships.class, (Enum)includeRelationships), renditionFilter, includePathSegment, Converter.convert((CmisExtensionType)extension));
            if (serviceResult != null) {
                for (ObjectInFolderContainer container : serviceResult) {
                    result.add(Converter.convert((ObjectInFolderContainer)container));
                }
            }
            arrayList = result;
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
        return arrayList;
    }

    public CmisObjectType getFolderParent(String repositoryId, String folderId, String filter, CmisExtensionType extension) throws CmisException {
        CmisObjectType cmisObjectType;
        CmisService service = null;
        try {
            service = this.getService(this.wsContext, repositoryId);
            cmisObjectType = Converter.convert((ObjectData)service.getFolderParent(repositoryId, folderId, filter, Converter.convert((CmisExtensionType)extension)));
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
        return cmisObjectType;
    }

    public List<CmisObjectInFolderContainerType> getFolderTree(String repositoryId, String folderId, BigInteger depth, String filter, Boolean includeAllowableActions, EnumIncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, CmisExtensionType extension) throws CmisException {
        ArrayList<CmisObjectInFolderContainerType> arrayList;
        CmisService service = null;
        try {
            service = this.getService(this.wsContext, repositoryId);
            ArrayList<CmisObjectInFolderContainerType> result = new ArrayList<CmisObjectInFolderContainerType>();
            List serviceResult = service.getFolderTree(repositoryId, folderId, depth, filter, includeAllowableActions, (IncludeRelationships)Converter.convert(IncludeRelationships.class, (Enum)includeRelationships), renditionFilter, includePathSegment, Converter.convert((CmisExtensionType)extension));
            if (serviceResult != null) {
                for (ObjectInFolderContainer container : serviceResult) {
                    result.add(Converter.convert((ObjectInFolderContainer)container));
                }
            }
            arrayList = result;
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
        return arrayList;
    }

    public List<CmisObjectParentsType> getObjectParents(String repositoryId, String objectId, String filter, Boolean includeAllowableActions, EnumIncludeRelationships includeRelationships, String renditionFilter, Boolean includeRelativePathSegment, CmisExtensionType extension) throws CmisException {
        ArrayList<CmisObjectParentsType> arrayList;
        CmisService service = null;
        try {
            service = this.getService(this.wsContext, repositoryId);
            ArrayList<CmisObjectParentsType> result = new ArrayList<CmisObjectParentsType>();
            List serviceResult = service.getObjectParents(repositoryId, objectId, filter, includeAllowableActions, (IncludeRelationships)Converter.convert(IncludeRelationships.class, (Enum)includeRelationships), renditionFilter, includeRelativePathSegment, Converter.convert((CmisExtensionType)extension));
            if (serviceResult != null) {
                for (ObjectParentData parent : serviceResult) {
                    result.add(Converter.convert((ObjectParentData)parent));
                }
            }
            arrayList = result;
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
        return arrayList;
    }
}

