/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.taglibs.authz;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.UserDetails;
import net.sf.acegisecurity.context.ContextHolder;
import net.sf.acegisecurity.context.security.SecureContext;

public class AuthenticationTag
extends TagSupport {
    public static final String OPERATION_PRINCIPAL = "principal";
    private String operation = "";

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getOperation() {
        return this.operation;
    }

    public int doStartTag() throws JspException {
        if (null == this.operation || "".equals(this.operation)) {
            return 0;
        }
        if (!OPERATION_PRINCIPAL.equalsIgnoreCase(this.operation)) {
            throw new JspException("Unsupported use of auth:authentication tag");
        }
        if (ContextHolder.getContext() == null || !(ContextHolder.getContext() instanceof SecureContext) || ((SecureContext)ContextHolder.getContext()).getAuthentication() == null) {
            return 0;
        }
        Authentication auth = ((SecureContext)ContextHolder.getContext()).getAuthentication();
        if (auth.getPrincipal() == null) {
            return 0;
        }
        if (auth.getPrincipal() instanceof UserDetails) {
            this.writeMessage(((UserDetails)auth.getPrincipal()).getUsername());
            return 0;
        }
        this.writeMessage(auth.getPrincipal().toString());
        return 0;
    }

    protected void writeMessage(String msg) throws JspException {
        try {
            this.pageContext.getOut().write(String.valueOf(msg));
        }
        catch (IOException ioe) {
            throw new JspException((Throwable)ioe);
        }
    }
}

