/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.ui;

import java.io.IOException;
import java.util.Properties;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.AuthenticationException;
import net.sf.acegisecurity.AuthenticationManager;
import net.sf.acegisecurity.context.ContextHolder;
import net.sf.acegisecurity.context.security.SecureContext;
import net.sf.acegisecurity.context.security.SecureContextUtils;
import net.sf.acegisecurity.ui.rememberme.NullRememberMeServices;
import net.sf.acegisecurity.ui.rememberme.RememberMeServices;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public abstract class AbstractProcessingFilter
implements Filter,
InitializingBean {
    public static final String ACEGI_SECURITY_TARGET_URL_KEY = "ACEGI_SECURITY_TARGET_URL";
    public static final String ACEGI_SECURITY_LAST_EXCEPTION_KEY = "ACEGI_SECURITY_LAST_EXCEPTION";
    protected static final Log logger = LogFactory.getLog((Class)(class$net$sf$acegisecurity$ui$AbstractProcessingFilter == null ? (class$net$sf$acegisecurity$ui$AbstractProcessingFilter = AbstractProcessingFilter.class$("net.sf.acegisecurity.ui.AbstractProcessingFilter")) : class$net$sf$acegisecurity$ui$AbstractProcessingFilter));
    private AuthenticationManager authenticationManager;
    private Properties exceptionMappings = new Properties();
    private RememberMeServices rememberMeServices = new NullRememberMeServices();
    private String authenticationFailureUrl;
    private String defaultTargetUrl;
    private String filterProcessesUrl = this.getDefaultFilterProcessesUrl();
    private boolean alwaysUseDefaultTargetUrl = false;
    private boolean continueChainBeforeSuccessfulAuthentication = false;
    static /* synthetic */ Class class$net$sf$acegisecurity$ui$AbstractProcessingFilter;

    public void setAlwaysUseDefaultTargetUrl(boolean alwaysUseDefaultTargetUrl) {
        this.alwaysUseDefaultTargetUrl = alwaysUseDefaultTargetUrl;
    }

    public boolean isAlwaysUseDefaultTargetUrl() {
        return this.alwaysUseDefaultTargetUrl;
    }

    public void setContinueChainBeforeSuccessfulAuthentication(boolean continueChainBeforeSuccessfulAuthentication) {
        this.continueChainBeforeSuccessfulAuthentication = continueChainBeforeSuccessfulAuthentication;
    }

    public boolean isContinueChainBeforeSuccessfulAuthentication() {
        return this.continueChainBeforeSuccessfulAuthentication;
    }

    public abstract String getDefaultFilterProcessesUrl();

    public void setExceptionMappings(Properties exceptionMappings) {
        this.exceptionMappings = exceptionMappings;
    }

    public Properties getExceptionMappings() {
        return new Properties(this.exceptionMappings);
    }

    public void setRememberMeServices(RememberMeServices rememberMeServices) {
        this.rememberMeServices = rememberMeServices;
    }

    public RememberMeServices getRememberMeServices() {
        return this.rememberMeServices;
    }

    public abstract Authentication attemptAuthentication(HttpServletRequest var1) throws AuthenticationException;

    public void setAuthenticationFailureUrl(String authenticationFailureUrl) {
        this.authenticationFailureUrl = authenticationFailureUrl;
    }

    public String getAuthenticationFailureUrl() {
        return this.authenticationFailureUrl;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    public void setDefaultTargetUrl(String defaultTargetUrl) {
        this.defaultTargetUrl = defaultTargetUrl;
    }

    public String getDefaultTargetUrl() {
        return this.defaultTargetUrl;
    }

    public void setFilterProcessesUrl(String filterProcessesUrl) {
        this.filterProcessesUrl = filterProcessesUrl;
    }

    public String getFilterProcessesUrl() {
        return this.filterProcessesUrl;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.hasLength((String)this.filterProcessesUrl, (String)"filterProcessesUrl must be specified");
        Assert.hasLength((String)this.defaultTargetUrl, (String)"defaultTargetUrl must be specified");
        Assert.hasLength((String)this.authenticationFailureUrl, (String)"authenticationFailureUrl must be specified");
        Assert.notNull((Object)this.authenticationManager, (String)"authenticationManager must be specified");
        Assert.notNull((Object)this.rememberMeServices);
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest)) {
            throw new ServletException("Can only process HttpServletRequest");
        }
        if (!(response instanceof HttpServletResponse)) {
            throw new ServletException("Can only process HttpServletResponse");
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (this.requiresAuthentication(httpRequest, httpResponse)) {
            Authentication authResult;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Request is to process authentication");
            }
            this.onPreAuthentication(httpRequest, httpResponse);
            try {
                authResult = this.attemptAuthentication(httpRequest);
            }
            catch (AuthenticationException failed) {
                this.unsuccessfulAuthentication(httpRequest, httpResponse, failed);
                return;
            }
            if (this.continueChainBeforeSuccessfulAuthentication) {
                chain.doFilter(request, response);
            }
            this.successfulAuthentication(httpRequest, httpResponse, authResult);
            return;
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig arg0) throws ServletException {
    }

    protected void onPreAuthentication(HttpServletRequest request, HttpServletResponse response) throws IOException {
    }

    protected void onSuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, Authentication authResult) throws IOException {
    }

    protected void onUnsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response) throws IOException {
    }

    protected boolean requiresAuthentication(HttpServletRequest request, HttpServletResponse response) {
        String uri = request.getRequestURI();
        int pathParamIndex = uri.indexOf(59);
        if (pathParamIndex > 0) {
            uri = uri.substring(0, pathParamIndex);
        }
        return uri.endsWith(request.getContextPath() + this.filterProcessesUrl);
    }

    protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, Authentication authResult) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Authentication success: " + authResult.toString()));
        }
        SecureContext sc = SecureContextUtils.getSecureContext();
        sc.setAuthentication(authResult);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Updated ContextHolder to contain the following Authentication: '" + authResult + "'"));
        }
        String targetUrl = (String)request.getSession().getAttribute(ACEGI_SECURITY_TARGET_URL_KEY);
        request.getSession().removeAttribute(ACEGI_SECURITY_TARGET_URL_KEY);
        if (this.alwaysUseDefaultTargetUrl) {
            targetUrl = null;
        }
        if (targetUrl == null) {
            targetUrl = request.getContextPath() + this.defaultTargetUrl;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Redirecting to target URL from HTTP Session (or default): " + targetUrl));
        }
        this.onSuccessfulAuthentication(request, response, authResult);
        this.rememberMeServices.loginSuccess(request, response, authResult);
        response.sendRedirect(response.encodeRedirectURL(targetUrl));
    }

    protected void unsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) throws IOException {
        SecureContext sc = SecureContextUtils.getSecureContext();
        sc.setAuthentication(null);
        ContextHolder.setContext(sc);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Updated ContextHolder to contain null Authentication");
        }
        String failureUrl = this.exceptionMappings.getProperty(((Object)((Object)failed)).getClass().getName(), this.authenticationFailureUrl);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Authentication request failed: " + failed.toString()));
        }
        request.getSession().setAttribute(ACEGI_SECURITY_LAST_EXCEPTION_KEY, (Object)failed);
        this.onUnsuccessfulAuthentication(request, response);
        this.rememberMeServices.loginFail(request, response);
        response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + failureUrl));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

