/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModelPersistenceContext {
    public static String REPO_STOREID = "REPO_STOREID";
    public static String REPO_WEBAPPID = "REPO_WEBAPPID";
    private final String userId;
    private final Map<String, Object> values;

    public ModelPersistenceContext(String userId) {
        this.userId = userId;
        this.values = new HashMap<String, Object>(2, 1.0f);
    }

    public String getUserId() {
        return this.userId;
    }

    public Object getValue(String key) {
        return this.values.get(key);
    }

    public void putValue(String key, Object value) {
        this.values.put(key, value);
    }

    public Set<String> keys() {
        return this.values.keySet();
    }

    public Collection<Object> values() {
        return this.values.values();
    }

    public void setStoreId(String storeId) {
        this.putValue(REPO_STOREID, storeId);
    }

    public String getStoreId() {
        return (String)this.getValue(REPO_STOREID);
    }

    public void setWebappId(String webappId) {
        this.putValue(REPO_WEBAPPID, webappId);
    }

    public String getWebappId() {
        return (String)this.getValue(REPO_WEBAPPID);
    }

    public String toString() {
        return "ModelPersistenceContext-" + this.userId + "-" + this.values.toString();
    }
}

