/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.extensibility.impl;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.element.GenericConfigElement;
import org.springframework.extensions.surf.ModelObjectService;
import org.springframework.extensions.surf.ModuleDeploymentService;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.extensibility.ExtensibilityModuleHandler;
import org.springframework.extensions.surf.extensibility.ExtensionModuleEvaluator;
import org.springframework.extensions.surf.types.Customization;
import org.springframework.extensions.surf.types.ExtensionModule;
import org.springframework.extensions.surf.types.ModuleDeployment;
import org.springframework.extensions.webscripts.ScriptConfigModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicExtensibilityModuleHandler
implements ExtensibilityModuleHandler,
ApplicationContextAware {
    private static final Log logger = LogFactory.getLog(BasicExtensibilityModuleHandler.class);
    private ScriptConfigModel scriptConfigModel;
    private ModuleDeploymentService moduleDeploymentService;
    private ModelObjectService modelObjectService;
    private ExtensionModuleEvaluator defaultModuleEvaluator = null;
    private ApplicationContext applicationContext = null;

    public void setScriptConfigModel(ScriptConfigModel scriptConfigModel) {
        this.scriptConfigModel = scriptConfigModel;
    }

    public void setModuleDeploymentService(ModuleDeploymentService moduleDeploymentService) {
        this.moduleDeploymentService = moduleDeploymentService;
    }

    public ModelObjectService getModelObjectService() {
        return this.modelObjectService;
    }

    public void setModelObjectService(ModelObjectService modelObjectService) {
        this.modelObjectService = modelObjectService;
    }

    public void setDefaultModuleEvaluator(ExtensionModuleEvaluator defaultModuleEvaluator) {
        this.defaultModuleEvaluator = defaultModuleEvaluator;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public List<String> getExtendingModuleFiles(ExtensionModule module, String path) {
        ArrayList<String> customizationPaths = new ArrayList<String>();
        for (Customization customization : module.getCustomizations()) {
            String targetPackage;
            if (customization.getTargetPackageName() == null || customization.getSourcePackageName() == null || !path.startsWith(targetPackage = customization.getTargetPackageName().replace(".", "/"))) continue;
            String packageSubPath = path.substring(targetPackage.length());
            String customizationPath = customization.getSourcePackageName().replace(".", "/");
            customizationPath = !customizationPath.endsWith("/") && !packageSubPath.startsWith("/") ? customizationPath + "/" + packageSubPath : customizationPath + packageSubPath;
            if (customizationPath.equals(path)) continue;
            customizationPaths.add(customizationPath);
        }
        return customizationPaths;
    }

    @Override
    public String getExtendingModuleDependencies(ExtensionModule module, String path, String appContext) {
        StringBuilder dependencies = new StringBuilder();
        LinkedHashSet<String> allCSSDependencies = new LinkedHashSet<String>();
        LinkedHashSet<String> allJSDependencies = new LinkedHashSet<String>();
        for (Customization customization : module.getCustomizations()) {
            String targetPackage;
            if (customization.getTargetPackageName() == null || !path.startsWith(targetPackage = customization.getTargetPackageName().replace(".", "/"))) continue;
            allCSSDependencies.addAll(customization.getCssDependencies());
            allJSDependencies.addAll(customization.getJsDependencies());
        }
        if (!allCSSDependencies.isEmpty()) {
            ConfigElement clientDebugElement;
            boolean isInDebugMode = true;
            Object flags = this.scriptConfigModel.getGlobal().get("flags");
            if (flags instanceof GenericConfigElement && (clientDebugElement = ((GenericConfigElement)flags).getChild("client-debug")) != null) {
                isInDebugMode = Boolean.getBoolean(clientDebugElement.getValue());
            }
            for (String jsLib : allJSDependencies) {
                if (!isInDebugMode) {
                    jsLib = jsLib.replace(".js", "-min.js");
                }
                dependencies.append("<script type=\"text/javascript\" src=\"" + appContext + jsLib + "\"></script>");
            }
            dependencies.append("<style type=\"text/css\" media=\"screen\">\n");
            for (String cssImport : allCSSDependencies) {
                dependencies.append("   @import \"" + appContext + cssImport + "\";\n");
            }
            dependencies.append("</style>\n");
        }
        return dependencies.toString();
    }

    @Override
    public List<ExtensionModule> evaluateModules(RequestContext context) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Evaluating modules for request: " + context.getUri()));
        }
        ArrayList<ExtensionModule> modules = new ArrayList<ExtensionModule>();
        if (this.moduleDeploymentService != null) {
            for (ModuleDeployment module : this.moduleDeploymentService.getDeployedModules()) {
                if (!this.applyModule(module, context)) continue;
                modules.add(module.getExtensionModule());
            }
        } else if (logger.isWarnEnabled()) {
            logger.warn((Object)"No module deployment service has been configured in the application context, applicable modules cannot be discovered");
        }
        return modules;
    }

    protected boolean applyModule(ModuleDeployment module, RequestContext context) {
        boolean apply = false;
        ExtensionModuleEvaluator moduleEvaluator = null;
        if (module.getEvaluator() != null) {
            try {
                moduleEvaluator = (ExtensionModuleEvaluator)this.applicationContext.getBean(module.getEvaluator(), ExtensionModuleEvaluator.class);
            }
            catch (NoSuchBeanDefinitionException e) {
                if (logger.isErrorEnabled()) {
                    logger.error((Object)("The following exception occurred retrieving evaluator: " + module.getEvaluator()), (Throwable)e);
                }
            }
        } else if (this.defaultModuleEvaluator != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Using default module evaluator on module '" + module.getId() + "'"));
            }
            moduleEvaluator = this.defaultModuleEvaluator;
        } else if (logger.isWarnEnabled()) {
            logger.warn((Object)("No evaluator defined for module: '" + (module != null ? module.getId() : null) + "' and no default configured - module will not be applied"));
        }
        if (moduleEvaluator != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Evaluating module : '" + (module != null ? module.getId() : null) + "' using evaluator '" + moduleEvaluator.getClass() + "'"));
            }
            apply = moduleEvaluator.applyModule(context, module.getEvaluatorProperties());
        }
        return apply;
    }
}

