/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.persister;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.springframework.extensions.surf.ModelObject;
import org.springframework.extensions.surf.ModelPersistenceContext;
import org.springframework.extensions.surf.ModelPersisterInfo;
import org.springframework.extensions.surf.cache.ContentCache;
import org.springframework.extensions.surf.cache.ModelObjectCache;
import org.springframework.extensions.surf.exception.ModelObjectPersisterException;
import org.springframework.extensions.surf.persister.ReadOnlyStoreObjectPersister;
import org.springframework.extensions.surf.util.ReflectionHelper;
import org.springframework.extensions.surf.util.XMLUtil;
import org.springframework.extensions.webscripts.ui.common.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStoreObjectPersister
extends ReadOnlyStoreObjectPersister {
    private static Log logger = LogFactory.getLog(AbstractStoreObjectPersister.class);
    protected static final String XML_EXT = ".xml";
    private static final String OBJECT_TYPE_IDS = "${objectTypeIds}";
    private static final String OBJECT_TYPE_ID = "${objectTypeId}";
    private static final String OBJECT_ID = "${objectId}";
    private static final String PLURAL_S = "s";
    private static final String CHROME = "chrome";

    @Override
    protected String generatePath(String objectTypeId, String objectId) {
        String path = null;
        String prefix = this.getPathPrefix(objectTypeId, objectId);
        path = prefix == null ? new StringBuilder(objectId.length() + 4).append(objectId).append(XML_EXT).toString() : new StringBuilder(prefix.length() + objectId.length() + 5).append(prefix).append('/').append(objectId).append(XML_EXT).toString();
        return path;
    }

    public String getPathPrefix(String objectTypeId, String objectId) {
        String prefix = null;
        if (this.pathPrefix != null) {
            prefix = this.pathPrefix;
            if (prefix.indexOf(OBJECT_TYPE_ID) != -1) {
                prefix = StringUtils.replace((String)prefix, (String)OBJECT_TYPE_ID, (String)objectTypeId);
            } else if (prefix.indexOf(OBJECT_ID) != -1) {
                prefix = StringUtils.replace((String)prefix, (String)OBJECT_ID, (String)objectId);
            } else if (prefix.indexOf(OBJECT_TYPE_IDS) != -1) {
                String p = objectTypeId + PLURAL_S;
                if (CHROME.equals(objectTypeId)) {
                    p = objectTypeId;
                }
                prefix = StringUtils.replace((String)prefix, (String)OBJECT_TYPE_IDS, (String)p);
            }
            if (prefix.endsWith("/")) {
                prefix = prefix.substring(0, prefix.length() - 1);
            }
        }
        return prefix;
    }

    @Override
    public boolean removeObject(ModelPersistenceContext context, String objectTypeId, String objectId) throws ModelObjectPersisterException {
        if (!this.isEnabled()) {
            return false;
        }
        boolean removed = false;
        String path = this.generatePath(objectTypeId, objectId);
        try {
            if (this.store.hasDocument(path)) {
                removed = this.store.removeDocument(path);
                this.cacheRemove(context, objectTypeId, objectId);
            }
        }
        catch (IOException ex) {
            throw new ModelObjectPersisterException("Unable to remove object for path: " + path);
        }
        return removed;
    }

    @Override
    public boolean hasObject(ModelPersistenceContext context, String objectTypeId, String objectId) throws ModelObjectPersisterException {
        if (!this.isEnabled()) {
            return false;
        }
        String path = this.generatePath(objectTypeId, objectId);
        try {
            return this.store.hasDocument(path);
        }
        catch (IOException ioe) {
            throw new ModelObjectPersisterException("Unable to test object at path: " + path, ioe);
        }
    }

    @Override
    public ModelObject newObject(ModelPersistenceContext context, String objectTypeId, String objectId) throws ModelObjectPersisterException {
        return this.newObject(context, objectTypeId, objectId, true);
    }

    protected ModelObject newObject(ModelPersistenceContext context, String objectTypeId, String objectId, boolean addToCache) throws ModelObjectPersisterException {
        ModelObject obj;
        block5: {
            if (objectId == null) {
                throw new ModelObjectPersisterException("Cannot create object with null object id");
            }
            String xml = "<" + objectTypeId + "></" + objectTypeId + ">";
            obj = null;
            try {
                Document document = XMLUtil.parse(xml);
                String path = this.generatePath(objectTypeId, objectId);
                ModelPersisterInfo info = new ModelPersisterInfo(this.getId(), path, false);
                String implClassName = this.getWebFrameworkConfiguration().getTypeDescriptor(objectTypeId).getImplementationClass();
                obj = (ModelObject)ReflectionHelper.newObject((String)implClassName, (Class[])MODELOBJECT_CLASSES, (Object[])new Object[]{objectId, info, document});
                if (obj != null) {
                    obj.touch();
                    if (addToCache) {
                        this.cachePut(context, obj);
                    }
                    break block5;
                }
                throw new ModelObjectPersisterException("Unable to construct object of class: " + implClassName + " for path: " + path);
            }
            catch (DocumentException de) {
                throw new ModelObjectPersisterException("Failed to load objectId: " + objectId, (Exception)((Object)de));
            }
        }
        return obj;
    }

    @Override
    public long getTimestamp(ModelPersistenceContext context, String objectTypeId, String objectId) throws ModelObjectPersisterException {
        if (!this.isEnabled()) {
            return -1L;
        }
        String path = this.generatePath(objectTypeId, objectId);
        long timestamp = -1L;
        try {
            timestamp = this.store.lastModified(path);
        }
        catch (IOException ioe) {
            throw new ModelObjectPersisterException("Unable to check timestamp for object path: " + path, ioe);
        }
        return timestamp;
    }

    @Override
    public Map<String, ModelObject> getAllObjects(ModelPersistenceContext context, String objectTypeId) throws ModelObjectPersisterException {
        String[] docPaths = this.store.getAllDocumentPaths();
        return this.getObjectsFromPaths(context, objectTypeId, docPaths);
    }

    @Override
    public Map<String, ModelObject> getAllObjectsByFilter(ModelPersistenceContext context, String objectTypeId, String objectIdFilter) throws ModelObjectPersisterException {
        if (!this.isEnabled()) {
            return new HashMap<String, ModelObject>();
        }
        String path = this.generatePath(objectTypeId, objectIdFilter);
        try {
            String[] docPaths = this.store.getDocumentPaths("", true, path);
            ArrayList<String> array = new ArrayList<String>(docPaths.length);
            for (String docPath : docPaths) {
                if (docPath.endsWith(".desc.xml")) continue;
                array.add(docPath);
            }
            String[] newDocPaths = array.toArray(new String[array.size()]);
            return this.getObjectsFromPaths(context, objectTypeId, newDocPaths);
        }
        catch (IOException e) {
            throw new ModelObjectPersisterException("Failed to get objects by filter: " + objectIdFilter, e);
        }
    }

    protected Map<String, ModelObject> getObjectsFromPaths(ModelPersistenceContext context, String objectTypeId, String[] docPaths) throws ModelObjectPersisterException {
        HashMap<String, ModelObject> objects = new HashMap<String, ModelObject>(docPaths.length, 1.0f);
        for (int i = 0; i < docPaths.length; ++i) {
            try {
                ModelObject object = this.getObjectByPath(context, docPaths[i]);
                if (object == null || !object.getTypeId().equals(objectTypeId)) continue;
                objects.put(object.getId(), object);
                continue;
            }
            catch (ModelObjectPersisterException err) {
                logger.warn((Object)("Failure to load model object for path: " + docPaths[i]), (Throwable)err);
            }
        }
        return objects;
    }

    @Override
    protected ContentCache<ModelObject> createCache() {
        return new ModelObjectCache(this.store, this.cacheDelay);
    }
}

