/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.render;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.dom4j.Document;
import org.dom4j.Element;
import org.springframework.extensions.surf.ModelPersisterInfo;
import org.springframework.extensions.surf.render.RenderMode;
import org.springframework.extensions.surf.render.Renderable;
import org.springframework.extensions.surf.types.AbstractModelObject;
import org.springframework.extensions.surf.util.XMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRenderableModelObject
extends AbstractModelObject
implements Renderable {
    private static final long serialVersionUID = 1708829571287199085L;
    private static final String PROP_PROCESSOR_ID = "id";
    public static String PROP_PROCESSOR = "processor";
    public static String ATTR_RENDER_MODE = "mode";
    private final Map<RenderMode, HashMap<String, String>> processorPropertyCache = new ConcurrentHashMap<RenderMode, HashMap<String, String>>(8);
    private final RenderMode[] renderModes;

    public AbstractRenderableModelObject(String id, ModelPersisterInfo info, Document document) {
        super(id, info, document);
        Document doc = this.getDocument();
        if (doc != null) {
            List processorElements = this.getDocument().getRootElement().elements(PROP_PROCESSOR);
            this.renderModes = new RenderMode[processorElements.size()];
            for (int i = 0; i < processorElements.size(); ++i) {
                Element processorElement = (Element)processorElements.get(i);
                this.renderModes[i] = RenderMode.valueOf(processorElement.attributeValue(ATTR_RENDER_MODE).toUpperCase());
                HashMap<String, String> props = new HashMap<String, String>(4);
                List children = XMLUtil.getChildren(processorElement);
                for (int n = 0; n < children.size(); ++n) {
                    Element child = (Element)children.get(n);
                    String name = child.getName();
                    String value = XMLUtil.getChildValue(processorElement, name);
                    props.put(name, value);
                }
                this.processorPropertyCache.put(this.renderModes[i], props);
            }
        } else {
            this.renderModes = new RenderMode[0];
        }
    }

    @Override
    public String getProcessorId() {
        return this.getProcessorId(null);
    }

    @Override
    public String getProcessorId(RenderMode mode) {
        return this.getProcessorProperty(mode, PROP_PROCESSOR_ID);
    }

    @Override
    public String getProcessorProperty(String propertyName) {
        return this.getProcessorProperty(null, propertyName);
    }

    @Override
    public String getProcessorProperty(RenderMode mode, String propertyName) {
        HashMap<String, String> modeData;
        String processorProperty = null;
        if (mode == null) {
            mode = RenderMode.VIEW;
        }
        if ((modeData = this.processorPropertyCache.get((Object)mode)) != null) {
            processorProperty = modeData.get(propertyName);
        }
        return processorProperty;
    }

    @Override
    public Map<String, String> getProcessorProperties() {
        return this.getProcessorProperties(null);
    }

    @Override
    public Map<String, String> getProcessorProperties(RenderMode renderMode) {
        if (renderMode == null) {
            renderMode = RenderMode.VIEW;
        }
        return (Map)this.processorPropertyCache.get((Object)renderMode).clone();
    }

    @Override
    public void setProcessorProperty(String propertyName, String propertyValue) {
        this.setProcessorProperty(null, propertyName, propertyValue);
    }

    @Override
    public void setProcessorProperty(RenderMode renderMode, String propertyName, String propertyValue) {
        Element processorElement;
        if (renderMode == null) {
            renderMode = RenderMode.VIEW;
        }
        if ((processorElement = this.getProcessorElement(renderMode)) == null) {
            processorElement = this.getDocument().getRootElement().addElement(PROP_PROCESSOR);
            processorElement.addAttribute(ATTR_RENDER_MODE, renderMode.toString());
        }
        XMLUtil.setChildValue(processorElement, propertyName, propertyValue);
        this.processorPropertyCache.get((Object)renderMode).put(propertyName, propertyValue);
    }

    @Override
    public void removeProcessor() {
        this.removeProcessor(RenderMode.VIEW);
    }

    @Override
    public void removeProcessor(RenderMode renderMode) {
        Element processorElement;
        if (renderMode == null) {
            renderMode = RenderMode.VIEW;
        }
        if ((processorElement = this.getProcessorElement(renderMode)) != null) {
            processorElement.getParent().remove(processorElement);
        }
    }

    @Override
    public RenderMode[] getRenderModes() {
        return this.renderModes;
    }

    private Element getProcessorElement(RenderMode renderMode) {
        if (renderMode == null) {
            renderMode = RenderMode.VIEW;
        }
        Element result = null;
        List processorElements = this.getDocument().getRootElement().elements(PROP_PROCESSOR);
        for (int i = 0; i < processorElements.size(); ++i) {
            Element processorElement = (Element)processorElements.get(i);
            String _renderMode = processorElement.attributeValue(ATTR_RENDER_MODE);
            if (!renderMode.toString().equals(_renderMode)) continue;
            result = processorElement;
            break;
        }
        return result;
    }
}

