/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.support;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.FrameworkBean;
import org.springframework.extensions.surf.FrameworkUtil;
import org.springframework.extensions.surf.LinkBuilder;
import org.springframework.extensions.surf.ModelObject;
import org.springframework.extensions.surf.ModelObjectService;
import org.springframework.extensions.surf.WebFrameworkServiceRegistry;
import org.springframework.extensions.surf.extensibility.ExtensibilityModel;
import org.springframework.extensions.surf.extensibility.ExtensibilityModuleHandler;
import org.springframework.extensions.surf.extensibility.HandlesExtensibility;
import org.springframework.extensions.surf.extensibility.impl.ExtensibilityModelImpl;
import org.springframework.extensions.surf.render.RenderMode;
import org.springframework.extensions.surf.resource.Resource;
import org.springframework.extensions.surf.site.SiteUtil;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.surf.types.Component;
import org.springframework.extensions.surf.types.Configuration;
import org.springframework.extensions.surf.types.ExtensionModule;
import org.springframework.extensions.surf.types.Page;
import org.springframework.extensions.surf.types.SubComponent;
import org.springframework.extensions.surf.types.TemplateInstance;
import org.springframework.extensions.surf.types.Theme;
import org.springframework.extensions.surf.util.Content;
import org.springframework.extensions.surf.util.FakeHttpServletResponse;
import org.springframework.extensions.webscripts.connector.CredentialVault;
import org.springframework.extensions.webscripts.connector.User;
import org.springframework.web.context.request.WebRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRequestContext
extends ThreadLocalRequestContext
implements HandlesExtensibility {
    private static final Log logger = LogFactory.getLog(AbstractRequestContext.class);
    private static final long serialVersionUID = -3714605386235121796L;
    public static final String VALUE_HEAD_TAGS = "headTags";
    protected static AtomicLong counter = new AtomicLong();
    protected Map<String, Serializable> valuesMap;
    protected Map<String, String> parametersMap;
    protected Map<String, Serializable> attributesMap;
    protected Map<String, String> headersMap;
    protected Map<String, String> uriTokens = Collections.emptyMap();
    protected Page rootPage;
    protected Configuration siteConfiguration;
    protected Page currentPage;
    protected TemplateInstance currentTemplate;
    protected Resource currentResource;
    protected String currentFormatId;
    protected String storeId;
    protected User user;
    protected String id;
    protected String uri;
    protected String viewName;
    protected Theme theme;
    protected Map<String, Component> components = null;
    protected Map<String, Object> model;
    protected String method;
    protected String contextPath;
    private FrameworkBean frameworkUtil;
    private ModelObject object;
    private WebRequest request;
    private HttpServletResponse response;
    private RenderMode mode = RenderMode.VIEW;
    private String renderId = null;
    private boolean passiveMode = false;
    private FakeHttpServletResponse fakeResponse;
    private String servletContextPath = null;
    private ExtensibilityModel extensibilityModel;
    private StringBuilder extensionDependencies = new StringBuilder();
    private Map<String, Serializable> evaluatedProperties = new HashMap<String, Serializable>();
    private ExtensibilityModuleHandler extensibilityModuleHandler = null;
    private List<ExtensionModule> evaluatedModules = null;
    private String fileBeingProcessed = null;
    private Map<String, SubComponent.RenderData> subComponentDebugData = new HashMap<String, SubComponent.RenderData>();

    protected AbstractRequestContext(WebFrameworkServiceRegistry serviceRegistry, FrameworkBean frameworkUtil) {
        super(serviceRegistry);
        this.frameworkUtil = frameworkUtil;
        this.valuesMap = new HashMap<String, Serializable>(4, 1.0f);
        this.parametersMap = new HashMap<String, String>(4, 1.0f);
        this.attributesMap = new HashMap<String, Serializable>(4, 1.0f);
        this.headersMap = new HashMap<String, String>(16, 1.0f);
        this.components = new LinkedHashMap<String, Component>(16, 1.0f);
        this.model = new HashMap<String, Object>(16);
    }

    protected AbstractRequestContext(WebFrameworkServiceRegistry serviceRegistry) {
        this(serviceRegistry, null);
    }

    @Override
    public String getId() {
        if (this.id == null) {
            this.id = Long.toString(counter.incrementAndGet());
        }
        return this.id;
    }

    @Override
    public Configuration getSiteConfiguration() {
        if (this.siteConfiguration == null) {
            this.siteConfiguration = SiteUtil.getSiteConfiguration(this);
        }
        return this.siteConfiguration;
    }

    @Override
    public String getWebsiteTitle() {
        String title = "Web Application";
        if (this.getSiteConfiguration() != null) {
            title = this.getSiteConfiguration().getTitle();
        }
        return title;
    }

    @Override
    public String getPageTitle() {
        String title = "Default Page";
        if (this.getPage() != null) {
            title = this.getPage().getTitle();
        }
        return title;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public void setUri(String uri) {
        this.uri = uri;
    }

    @Override
    public String getViewName() {
        return this.viewName;
    }

    @Override
    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    @Override
    public Page getPage() {
        return this.currentPage;
    }

    @Override
    public void setPage(Page page) {
        this.currentPage = page;
        this.currentTemplate = null;
    }

    @Override
    public String getPageId() {
        if (this.getPage() != null) {
            return this.getPage().getId();
        }
        return null;
    }

    @Override
    public abstract LinkBuilder getLinkBuilder();

    @Override
    public Page getRootPage() {
        if (this.rootPage == null) {
            this.rootPage = SiteUtil.getRootPage(this);
        }
        return this.rootPage;
    }

    @Override
    public TemplateInstance getTemplate() {
        if (this.currentTemplate == null && this.getPage() != null) {
            this.currentTemplate = this.getPage().getTemplate(this);
        }
        return this.currentTemplate;
    }

    @Override
    public void setTemplate(TemplateInstance currentTemplate) {
        this.currentTemplate = currentTemplate;
    }

    @Override
    public String getTemplateId() {
        if (this.getTemplate() != null) {
            return this.getTemplate().getId();
        }
        return null;
    }

    @Override
    public String getCurrentObjectId() {
        String id = null;
        if (this.getCurrentObject() != null) {
            id = this.getCurrentObject().getObjectId();
        }
        return id;
    }

    @Override
    public void setCurrentObject(Resource resource) {
        this.currentResource = resource;
    }

    @Override
    public Resource getCurrentObject() {
        return this.currentResource;
    }

    @Override
    public String getFormatId() {
        return this.currentFormatId;
    }

    @Override
    public void setFormatId(String formatId) {
        this.currentFormatId = formatId;
    }

    @Override
    public void setUser(User user) {
        this.user = user;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    @Override
    public String getUserId() {
        return this.getUser() != null ? this.getUser().getId() : null;
    }

    @Override
    public CredentialVault getCredentialVault() {
        CredentialVault credentialVault = this.frameworkUtil == null ? FrameworkUtil.getCredentialVault(this, this.getUserId()) : this.frameworkUtil.getCredentialVault(this, this.getUserId());
        return credentialVault;
    }

    @Override
    public void setValue(String key, Serializable value) {
        this.valuesMap.put(key, value);
    }

    @Override
    public Serializable getValue(String key) {
        return this.valuesMap.get(key);
    }

    @Override
    public void removeValue(String key) {
        this.valuesMap.remove(key);
    }

    @Override
    public boolean hasValue(String key) {
        return this.valuesMap.get(key) != null;
    }

    @Override
    public Map<String, Serializable> getValuesMap() {
        return this.valuesMap;
    }

    @Override
    public String getParameter(String key) {
        return this.parametersMap.get(key);
    }

    @Override
    public boolean hasParameter(String key) {
        return this.parametersMap.get(key) != null;
    }

    @Override
    public Map<String, String> getParameters() {
        return this.parametersMap;
    }

    @Override
    public Component[] getRenderingComponents() {
        if (this.components.size() == 0) {
            return null;
        }
        return this.components.values().toArray(new Component[this.components.size()]);
    }

    @Override
    public void setRenderingComponent(Component component) {
        this.components.put(component.getId(), component);
    }

    @Override
    public Theme getTheme() {
        return this.theme;
    }

    @Override
    public void setTheme(Theme theme) {
        this.theme = theme;
    }

    @Override
    public String getThemeId() {
        String themeId = null;
        if (this.getTheme() != null) {
            themeId = this.getTheme().getId();
        }
        return themeId;
    }

    @Override
    public String getRequestMethod() {
        return this.method;
    }

    @Override
    public ModelObjectService getObjectService() {
        return this.getServiceRegistry().getModelObjectService();
    }

    public String toString() {
        return "RequestContext-" + this.getId();
    }

    @Override
    public void setModel(Map<String, Object> model) {
        this.model = model;
    }

    @Override
    public Map<String, Object> getModel() {
        return this.model;
    }

    @Override
    public String getContextPath() {
        return this.contextPath;
    }

    @Override
    public Serializable getAttribute(String key) {
        return this.attributesMap.get(key);
    }

    @Override
    public boolean hasAttribute(String key) {
        return this.attributesMap.get(key) != null;
    }

    @Override
    public Map<String, Serializable> getAttributes() {
        return this.attributesMap;
    }

    @Override
    public String getHeader(String key) {
        return this.headersMap.get(key);
    }

    @Override
    public boolean hasHeader(String key) {
        return this.headersMap.get(key) != null;
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headersMap;
    }

    @Override
    public void setUriTokens(Map<String, String> _uriTokens) {
        this.uriTokens = _uriTokens != null ? _uriTokens : Collections.emptyMap();
    }

    @Override
    public Map<String, String> getUriTokens() {
        return this.uriTokens;
    }

    @Override
    public synchronized Content getRequestContent() {
        return null;
    }

    @Override
    public final RenderMode getRenderMode() {
        return this.mode;
    }

    @Override
    public final void setRenderMode(RenderMode mode) {
        this.mode = mode;
    }

    public final WebRequest getRequest() {
        return this.request;
    }

    public final void setRequest(WebRequest request) {
        this.request = request;
    }

    @Override
    public final HttpServletResponse getResponse() {
        FakeHttpServletResponse responseToReturn = null;
        responseToReturn = this.passiveMode ? this.fakeResponse : this.response;
        return responseToReturn;
    }

    @Override
    public String getContentAsString() throws UnsupportedEncodingException {
        return this.fakeResponse.getContentAsString();
    }

    @Override
    public final void setResponse(HttpServletResponse response) {
        this.response = response;
        this.fakeResponse = new FakeHttpServletResponse(response);
    }

    public ModelObject getObject() {
        return this.object;
    }

    public void setObject(ModelObject object) {
        this.object = object;
    }

    @Override
    public final void setPassiveMode(boolean passiveMode) {
        this.passiveMode = passiveMode;
        if (passiveMode) {
            this.fakeResponse = new FakeHttpServletResponse(this.response);
        }
    }

    @Override
    public final boolean isPassiveMode() {
        return this.passiveMode;
    }

    @Override
    public String getServletContextPath() {
        return this.servletContextPath;
    }

    @Override
    public void setServletContextPath(String path) {
        this.servletContextPath = path;
    }

    public ExtensibilityModel openExtensibilityModel() {
        this.extensibilityModel = new ExtensibilityModelImpl(this.extensibilityModel, (HandlesExtensibility)this);
        return this.extensibilityModel;
    }

    public void closeExtensibilityModel(ExtensibilityModel model, Writer out) {
        model.flushModel(out);
        this.extensibilityModel = model.getParentModel();
        if (this.extensibilityModel != null) {
            this.extensibilityModel.setChildDebugData(model.getDebugData());
        }
    }

    public ExtensibilityModel getCurrentExtensibilityModel() {
        return this.extensibilityModel;
    }

    @Override
    public void appendExtensionDependencies(String dependencies) {
        this.extensionDependencies.append(dependencies);
    }

    @Override
    public String getExtensionDependencies() {
        return this.extensionDependencies.toString();
    }

    @Override
    public void setEvaluatedProperties(Map<String, Serializable> properties) {
        this.evaluatedProperties.clear();
        this.evaluatedProperties.putAll(properties);
    }

    @Override
    public Map<String, Serializable> getEvaluatedProperties() {
        return this.evaluatedProperties;
    }

    @Override
    public void setExtensibilityModuleHandler(ExtensibilityModuleHandler extensibilityModuleHandler) {
        this.extensibilityModuleHandler = extensibilityModuleHandler;
    }

    @Override
    public List<ExtensionModule> getEvaluatedModules() {
        if (this.evaluatedModules == null) {
            if (this.extensibilityModuleHandler == null) {
                if (logger.isErrorEnabled()) {
                    logger.error((Object)"No 'extensibilityModuleHandler' has been configured for this request context. Extensions cannot be processed");
                }
                this.evaluatedModules = new ArrayList<ExtensionModule>();
            }
            this.evaluatedModules = this.extensibilityModuleHandler.evaluateModules(this);
        }
        return this.evaluatedModules;
    }

    public String getExtendingModuleDependencies(String path, Map<String, Object> model) {
        StringBuilder dependencies = new StringBuilder();
        for (ExtensionModule module : this.getEvaluatedModules()) {
            dependencies.append(this.extensibilityModuleHandler.getExtendingModuleDependencies(module, path, this.getContextPath()));
        }
        return dependencies.toString();
    }

    public List<String> getExtendingModuleFiles(String pathBeingProcessed) {
        ArrayList<String> extendingModuleFiles = new ArrayList<String>();
        for (ExtensionModule module : this.getEvaluatedModules()) {
            extendingModuleFiles.addAll(this.extensibilityModuleHandler.getExtendingModuleFiles(module, pathBeingProcessed));
        }
        return extendingModuleFiles;
    }

    public String getFileBeingProcessed() {
        return this.fileBeingProcessed;
    }

    public void setFileBeingProcessed(String file) {
        this.fileBeingProcessed = file;
    }

    @Override
    public SubComponent.RenderData getSubComponentDebugData(String id) {
        SubComponent.RenderData data = this.subComponentDebugData.get(id);
        return data;
    }

    @Override
    public void addSubComponentDebugData(String id, SubComponent.RenderData data) {
        this.subComponentDebugData.put(id, data);
    }
}

