/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.support;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.UserFactory;
import org.springframework.extensions.surf.exception.UserFactoryException;
import org.springframework.extensions.surf.support.BaseFactory;
import org.springframework.extensions.webscripts.connector.User;

public abstract class AbstractUserFactory
extends BaseFactory
implements UserFactory {
    private User guestUser = null;

    protected User getGuestUser(RequestContext context) throws UserFactoryException {
        if (this.guestUser == null) {
            HashMap<String, Boolean> capabilities = new HashMap<String, Boolean>(4);
            capabilities.put("isAdmin", false);
            capabilities.put("isGuest", true);
            capabilities.put("isMutable", false);
            User user = new User("guest", capabilities);
            user.setFirstName("Guest");
            this.guestUser = user;
        }
        return this.guestUser;
    }

    public User initialiseUser(RequestContext context, HttpServletRequest request) throws UserFactoryException {
        return this.initialiseUser(context, request, false);
    }

    public User initialiseUser(RequestContext context, HttpServletRequest request, String endpoint) throws UserFactoryException {
        return this.initialiseUser(context, request, endpoint, false);
    }

    public User initialiseUser(RequestContext context, HttpServletRequest request, boolean force) throws UserFactoryException {
        return this.initialiseUser(context, request, null, force);
    }

    public User initialiseUser(RequestContext context, HttpServletRequest request, String endpoint, boolean force) throws UserFactoryException {
        User user = null;
        HttpSession session = request.getSession(false);
        if (force && session != null) {
            session.removeAttribute("_alf_USER_OBJECT");
        }
        String userId = null;
        if (session != null) {
            userId = (String)session.getAttribute("_alf_USER_ID");
        }
        boolean externalAuth = false;
        if (userId == null) {
            userId = request.getRemoteUser();
            boolean bl = externalAuth = userId != null;
        }
        if (userId != null) {
            try {
                if (session == null) {
                    session = request.getSession();
                }
                if ((user = (User)session.getAttribute("_alf_USER_OBJECT")) == null) {
                    user = this.loadUser(context, userId, endpoint);
                    if (user != null) {
                        session.setAttribute("_alf_USER_OBJECT", (Object)user);
                        session.setAttribute("_alf_USER_ID", (Object)user.getId());
                    } else {
                        session.removeAttribute("_alf_USER_OBJECT");
                    }
                }
            }
            catch (UserFactoryException e) {
                if (externalAuth) {
                    userId = null;
                }
                throw e;
            }
        }
        if (user == null) {
            user = this.getGuestUser(context);
        }
        return user;
    }

    public abstract User loadUser(RequestContext var1, String var2) throws UserFactoryException;

    public abstract User loadUser(RequestContext var1, String var2, String var3) throws UserFactoryException;

    public abstract boolean authenticate(HttpServletRequest var1, String var2, String var3);
}

