/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.support;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.ServletUtil;
import org.springframework.extensions.surf.exception.UserFactoryException;
import org.springframework.extensions.surf.site.AlfrescoUser;
import org.springframework.extensions.surf.support.AbstractUserFactory;
import org.springframework.extensions.surf.util.URLEncoder;
import org.springframework.extensions.webscripts.connector.AuthenticatingConnector;
import org.springframework.extensions.webscripts.connector.Connector;
import org.springframework.extensions.webscripts.connector.ConnectorService;
import org.springframework.extensions.webscripts.connector.CredentialVault;
import org.springframework.extensions.webscripts.connector.Credentials;
import org.springframework.extensions.webscripts.connector.Response;
import org.springframework.extensions.webscripts.connector.User;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlfrescoUserFactory
extends AbstractUserFactory {
    public static final String DEFAULT_USER_URL_PREFIX = "/webframework/content/metadata?user=";
    private static final String JSON_RESPONSE_CODE_VALUE_OK = "OK";
    private static final String JSON_RESPONSE_CODE = "code";
    private static Log logger = LogFactory.getLog(AlfrescoUserFactory.class);
    public static final String CM_AVATAR = "{http://www.alfresco.org/model/content/1.0}avatar";
    public static final String CM_COMPANYEMAIL = "{http://www.alfresco.org/model/content/1.0}companyemail";
    public static final String CM_COMPANYFAX = "{http://www.alfresco.org/model/content/1.0}companyfax";
    public static final String CM_COMPANYTELEPHONE = "{http://www.alfresco.org/model/content/1.0}companytelephone";
    public static final String CM_COMPANYPOSTCODE = "{http://www.alfresco.org/model/content/1.0}companypostcode";
    public static final String CM_COMPANYADDRESS3 = "{http://www.alfresco.org/model/content/1.0}companyaddress3";
    public static final String CM_COMPANYADDRESS2 = "{http://www.alfresco.org/model/content/1.0}companyaddress2";
    public static final String CM_COMPANYADDRESS1 = "{http://www.alfresco.org/model/content/1.0}companyaddress1";
    public static final String CM_INSTANTMSG = "{http://www.alfresco.org/model/content/1.0}instantmsg";
    public static final String CM_GOOGLEUSERNAME = "{http://www.alfresco.org/model/content/1.0}googleusername";
    public static final String CM_SKYPE = "{http://www.alfresco.org/model/content/1.0}skype";
    public static final String CM_MOBILE = "{http://www.alfresco.org/model/content/1.0}mobile";
    public static final String CM_TELEPHONE = "{http://www.alfresco.org/model/content/1.0}telephone";
    public static final String CM_PERSONDESCRIPTION = "{http://www.alfresco.org/model/content/1.0}persondescription";
    public static final String CM_EMAIL = "{http://www.alfresco.org/model/content/1.0}email";
    public static final String CM_LOCATION = "{http://www.alfresco.org/model/content/1.0}location";
    public static final String CM_ORGANIZATION = "{http://www.alfresco.org/model/content/1.0}organization";
    public static final String CM_JOBTITLE = "{http://www.alfresco.org/model/content/1.0}jobtitle";
    public static final String CM_LASTNAME = "{http://www.alfresco.org/model/content/1.0}lastName";
    public static final String CM_FIRSTNAME = "{http://www.alfresco.org/model/content/1.0}firstName";
    public static final String CM_USERNAME = "{http://www.alfresco.org/model/content/1.0}userName";
    public static final String ALFRESCO_ENDPOINT_ID = "alfresco";

    @Override
    public boolean authenticate(HttpServletRequest request, String username, String password) {
        boolean authenticated;
        block4: {
            authenticated = false;
            try {
                AuthenticatingConnector authenticatingConnector;
                CredentialVault vault = this.frameworkUtils.getCredentialVault(request.getSession(), username);
                Credentials credentials = vault.newCredentials(ALFRESCO_ENDPOINT_ID);
                credentials.setProperty("cleartextUsername", (Object)username);
                credentials.setProperty("cleartextPassword", (Object)password);
                Connector connector = this.frameworkUtils.getConnector(request.getSession(), username, ALFRESCO_ENDPOINT_ID);
                if (connector instanceof AuthenticatingConnector) {
                    authenticatingConnector = (AuthenticatingConnector)connector;
                } else {
                    ConnectorService cs = (ConnectorService)this.getApplicationContext().getBean("connector.service");
                    authenticatingConnector = new AuthenticatingConnector(connector, cs.getAuthenticator("alfresco-ticket"));
                }
                authenticated = authenticatingConnector.handshake();
            }
            catch (Throwable ex) {
                if (!logger.isInfoEnabled()) break block4;
                logger.info((Object)"Exception in AlfrescoUserFactory.authenticate()", ex);
            }
        }
        return authenticated;
    }

    @Override
    public User loadUser(RequestContext context, String userId) throws UserFactoryException {
        return this.loadUser(context, userId, null);
    }

    @Override
    public User loadUser(RequestContext context, String requestedUserId, String endpointId) throws UserFactoryException {
        if (endpointId == null) {
            endpointId = ALFRESCO_ENDPOINT_ID;
        }
        AlfrescoUser user = null;
        try {
            String uri;
            HttpSession session;
            Connector connector;
            Response response;
            String currentUserId = context.getUserId();
            if (currentUserId == null) {
                currentUserId = requestedUserId;
            }
            if (200 != (response = (connector = this.frameworkUtils.getConnector(session = ServletUtil.getSession(), currentUserId, endpointId)).call(uri = this.buildUserMetadataRestUrl(context, requestedUserId, endpointId))).getStatus().getCode()) {
                throw new UserFactoryException("Unable to create user - failed to retrieve user metadata: " + response.getStatus().getMessage(), (Exception)response.getStatus().getException());
            }
            JSONObject json = new JSONObject(response.getResponse());
            user = this.buildAlfrescoUser(json);
        }
        catch (Exception ex) {
            throw new UserFactoryException("Unable to retrieve user from repository", ex);
        }
        return user;
    }

    protected String buildUserMetadataRestUrl(RequestContext context, String userId, String endpointId) {
        return DEFAULT_USER_URL_PREFIX + URLEncoder.encode((String)userId);
    }

    protected AlfrescoUser buildAlfrescoUser(JSONObject json) throws JSONException, UserFactoryException {
        HashMap<String, Boolean> immutability;
        HashMap<String, Boolean> capabilities;
        JSONObject properties;
        JSONObject jsonData;
        AlfrescoUser user = null;
        String code = json.getString(JSON_RESPONSE_CODE);
        if (JSON_RESPONSE_CODE_VALUE_OK.equals(code)) {
            jsonData = json.getJSONObject("data");
            properties = jsonData.getJSONObject("properties");
            JSONObject capabilityJson = jsonData.getJSONObject("capabilities");
            capabilities = new HashMap<String, Boolean>(capabilityJson.length());
            Iterator i = capabilityJson.keys();
            while (i.hasNext()) {
                String capability = (String)i.next();
                capabilities.put(capability, capabilityJson.getBoolean(capability));
            }
            immutability = null;
            if (jsonData.has("immutableProperties")) {
                JSONObject immutabilityJson = jsonData.getJSONObject("immutableProperties");
                immutability = new HashMap<String, Boolean>(immutabilityJson.length());
                i = immutabilityJson.keys();
                while (i.hasNext()) {
                    String readonly = (String)i.next();
                    immutability.put(readonly, immutabilityJson.getBoolean(readonly));
                }
            }
        } else {
            String message = "none";
            if (json.has("message")) {
                message = json.getString("message");
            }
            throw new UserFactoryException("Code '" + code + "' received while loading user object.  Message: " + message);
        }
        user = this.constructAlfrescoUser(jsonData, properties, capabilities, immutability);
        return user;
    }

    protected AlfrescoUser constructAlfrescoUser(JSONObject jsonData, JSONObject properties, Map<String, Boolean> capabilities, Map<String, Boolean> immutability) throws JSONException {
        JSONObject assocs;
        JSONArray array;
        AlfrescoUser user = this.constructUser(properties, capabilities, immutability);
        user.setFirstName(properties.has(CM_FIRSTNAME) ? properties.getString(CM_FIRSTNAME) : "");
        user.setLastName(properties.has(CM_LASTNAME) ? properties.getString(CM_LASTNAME) : "");
        if (properties.has(CM_JOBTITLE)) {
            user.setJobTitle(properties.getString(CM_JOBTITLE));
        }
        if (properties.has(CM_ORGANIZATION)) {
            user.setOrganization(properties.getString(CM_ORGANIZATION));
        }
        if (properties.has(CM_LOCATION)) {
            user.setLocation(properties.getString(CM_LOCATION));
        }
        if (properties.has(CM_EMAIL)) {
            user.setEmail(properties.getString(CM_EMAIL));
        }
        if (properties.has(CM_PERSONDESCRIPTION)) {
            user.setBiography(properties.getString(CM_PERSONDESCRIPTION));
        }
        if (properties.has(CM_TELEPHONE)) {
            user.setTelephone(properties.getString(CM_TELEPHONE));
        }
        if (properties.has(CM_MOBILE)) {
            user.setMobilePhone(properties.getString(CM_MOBILE));
        }
        if (properties.has(CM_SKYPE)) {
            user.setSkype(properties.getString(CM_SKYPE));
        }
        if (properties.has(CM_INSTANTMSG)) {
            user.setInstantMsg(properties.getString(CM_INSTANTMSG));
        }
        if (properties.has(CM_GOOGLEUSERNAME)) {
            user.setGoogleUsername(properties.getString(CM_GOOGLEUSERNAME));
        }
        if (properties.has(CM_COMPANYADDRESS1)) {
            user.setCompanyAddress1(properties.getString(CM_COMPANYADDRESS1));
        }
        if (properties.has(CM_COMPANYADDRESS2)) {
            user.setCompanyAddress2(properties.getString(CM_COMPANYADDRESS2));
        }
        if (properties.has(CM_COMPANYADDRESS3)) {
            user.setCompanyAddress3(properties.getString(CM_COMPANYADDRESS3));
        }
        if (properties.has(CM_COMPANYPOSTCODE)) {
            user.setCompanyPostcode(properties.getString(CM_COMPANYPOSTCODE));
        }
        if (properties.has(CM_COMPANYTELEPHONE)) {
            user.setCompanyTelephone(properties.getString(CM_COMPANYTELEPHONE));
        }
        if (properties.has(CM_COMPANYFAX)) {
            user.setCompanyFax(properties.getString(CM_COMPANYFAX));
        }
        if (properties.has(CM_COMPANYEMAIL)) {
            user.setCompanyEmail(properties.getString(CM_COMPANYEMAIL));
        }
        if (jsonData.has("associations") && (array = (assocs = jsonData.getJSONObject("associations")).getJSONArray(CM_AVATAR)).length() != 0) {
            user.setAvatarRef(array.getString(0));
        }
        return user;
    }

    protected AlfrescoUser constructUser(JSONObject properties, Map<String, Boolean> capabilities, Map<String, Boolean> immutability) throws JSONException {
        return new AlfrescoUser(properties.getString(CM_USERNAME), capabilities, immutability);
    }
}

