/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.types;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;
import org.springframework.extensions.surf.types.XMLHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Customization {
    private static final long serialVersionUID = 7533983408926003367L;
    public static final String TARGET_PACKAGE = "targetPackageRoot";
    public static final String SOURCE_PACKAGE = "sourcePackageRoot";
    public static final String DEPENDENCIES = "dependencies";
    public static final String CSS = "css";
    public static final String JS = "js";
    public static final String EVALUATOR = "evaluator";
    public static final String EVALUATOR_PROPS = "evaluatorProperties";
    public static final String EVALUATOR_PROP = "evaluatorProperty";
    public static final String EVALUATOR_PROP_NAME = "name";
    public static final String EVALUATOR_PROP_VALUE = "value";
    private String targetPackageName = null;
    private String sourcePackageName = null;
    private List<String> cssDependencies = new ArrayList<String>();
    private List<String> jsDependencies = new ArrayList<String>();
    private String evaluator = null;
    private Map<String, String> evaluatorProperties = new HashMap<String, String>();

    public Customization(Element sourceElement) {
        this.applyConfiguration(sourceElement);
    }

    public void applyConfiguration(Element customizationEl) {
        this.targetPackageName = XMLHelper.getStringData(TARGET_PACKAGE, customizationEl, true);
        this.sourcePackageName = XMLHelper.getStringData(SOURCE_PACKAGE, customizationEl, true);
        this.evaluatorProperties = XMLHelper.getProperties(EVALUATOR_PROPS, customizationEl);
        this.cssDependencies = this.getDependencies(DEPENDENCIES, CSS, customizationEl);
        this.jsDependencies = this.getDependencies(DEPENDENCIES, JS, customizationEl);
    }

    private List<String> getDependencies(String elementName, String dependencyElementName, Element sourceElement) {
        ArrayList<String> dependencies = new ArrayList<String>();
        Element el = sourceElement.element(elementName);
        if (el != null) {
            List elementList = el.elements(dependencyElementName);
            for (Element element : elementList) {
                dependencies.add(element.getTextTrim());
            }
        }
        return dependencies;
    }

    public String getTargetPackageName() {
        return this.targetPackageName;
    }

    public String getSourcePackageName() {
        return this.sourcePackageName;
    }

    public List<String> getCssDependencies() {
        return this.cssDependencies;
    }

    public List<String> getJsDependencies() {
        return this.jsDependencies;
    }

    public String getEvaluator() {
        return this.evaluator;
    }

    public Map<String, String> getEvaluatorProperties() {
        return this.evaluatorProperties;
    }
}

